"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViewService = void 0;
const common_1 = require("@nestjs/common");
const asset_response_dto_1 = require("../dtos/asset-response.dto");
const base_service_1 = require("./base.service");
let ViewService = class ViewService extends base_service_1.BaseService {
    getUniqueOriginalPaths(auth) {
        return this.viewRepository.getUniqueOriginalPaths(auth.user.id);
    }
    async getAssetsByOriginalPath(auth, path) {
        const assets = await this.viewRepository.getAssetsByOriginalPath(auth.user.id, path);
        return assets.map((asset) => (0, asset_response_dto_1.mapAsset)(asset, { auth }));
    }
};
exports.ViewService = ViewService;
exports.ViewService = ViewService = __decorate([
    (0, common_1.Injectable)()
], ViewService);
//# sourceMappingURL=view.service.js.map