"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `
    DO $$
      DECLARE
        constraint_name text;
      BEGIN
        SELECT con.conname
        INTO constraint_name
        FROM pg_catalog.pg_constraint con
               JOIN pg_catalog.pg_class rel ON rel.oid = con.conrelid
        WHERE rel.relname = 'geodata_places' AND con.contype = 'p';

        IF constraint_name IS NOT NULL THEN
          EXECUTE 'ALTER TABLE "geodata_places" DROP CONSTRAINT "' || constraint_name || '"';
        END IF;
      END;
    $$;
  `.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "geodata_places" ADD CONSTRAINT "geodata_places_pkey" PRIMARY KEY ("id");`.execute(db);
}
async function down() { }
//# sourceMappingURL=1752161055253-RenameGeodataPKConstraint.js.map