import { NextFunction, Request, Response } from 'express';
import { MaintenanceAuthDto, MaintenanceDetectInstallResponseDto, MaintenanceLoginDto, MaintenanceStatusResponseDto, SetMaintenanceModeDto } from 'src/dtos/maintenance.dto';
import { ServerConfigDto, ServerVersionResponseDto } from 'src/dtos/server.dto';
import { MaintenanceWorkerService } from 'src/maintenance/maintenance-worker.service';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { LoginDetails } from 'src/services/auth.service';
import { FilenameParamDto } from 'src/validation';
import { DatabaseBackupDeleteDto, DatabaseBackupListResponseDto } from 'src/dtos/database-backup.dto';
import { DatabaseBackupService } from 'src/services/database-backup.service';
export declare class MaintenanceWorkerController {
    private logger;
    private service;
    private databaseBackupService;
    constructor(logger: LoggingRepository, service: MaintenanceWorkerService, databaseBackupService: DatabaseBackupService);
    getServerConfig(): ServerConfigDto;
    getServerVersion(): ServerVersionResponseDto;
    listDatabaseBackups(): Promise<DatabaseBackupListResponseDto>;
    downloadDatabaseBackup({ filename }: FilenameParamDto, res: Response, next: NextFunction): Promise<void>;
    deleteDatabaseBackup(dto: DatabaseBackupDeleteDto): Promise<void>;
    uploadDatabaseBackup(file: Express.Multer.File): Promise<void>;
    maintenanceStatus(request: Request): Promise<MaintenanceStatusResponseDto>;
    detectPriorInstall(): Promise<MaintenanceDetectInstallResponseDto>;
    maintenanceLogin(request: Request, dto: MaintenanceLoginDto, loginDetails: LoginDetails, res: Response): Promise<MaintenanceAuthDto>;
    setMaintenanceMode(dto: SetMaintenanceModeDto): void;
}
