export declare enum AssetEditAction {
    Crop = "crop",
    Rotate = "rotate",
    Mirror = "mirror"
}
export declare enum MirrorAxis {
    Horizontal = "horizontal",
    Vertical = "vertical"
}
export declare class CropParameters {
    x: number;
    y: number;
    width: number;
    height: number;
}
export declare class RotateParameters {
    angle: number;
}
export declare class MirrorParameters {
    axis: MirrorAxis;
}
declare class AssetEditActionBase {
    action: AssetEditAction;
}
export declare class AssetEditActionCrop extends AssetEditActionBase {
    parameters: CropParameters;
}
export declare class AssetEditActionRotate extends AssetEditActionBase {
    parameters: RotateParameters;
}
export declare class AssetEditActionMirror extends AssetEditActionBase {
    parameters: MirrorParameters;
}
export type AssetEditActionItem = {
    action: AssetEditAction.Crop;
    parameters: CropParameters;
} | {
    action: AssetEditAction.Rotate;
    parameters: RotateParameters;
} | {
    action: AssetEditAction.Mirror;
    parameters: MirrorParameters;
};
export type AssetEditActionParameter = {
    [AssetEditAction.Crop]: CropParameters;
    [AssetEditAction.Rotate]: RotateParameters;
    [AssetEditAction.Mirror]: MirrorParameters;
};
export declare class AssetEditActionListDto {
    edits: AssetEditActionItem[];
}
export declare class AssetEditsDto extends AssetEditActionListDto {
    assetId: string;
}
export {};
