"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HistoryBuilder = exports.Property = exports.Endpoint = exports.OnJob = exports.OnEvent = exports.GenerateSql = exports.Telemetry = exports.GENERATE_SQL_KEY = exports.DummyValue = exports.DATABASE_PARAMETER_CHUNK_SIZE = exports.UpdatedAtTrigger = exports.PrimaryGeneratedUuidV7Column = exports.CreateIdColumn = exports.UpdateIdColumn = void 0;
exports.Chunked = Chunked;
exports.ChunkedArray = ChunkedArray;
exports.ChunkedSet = ChunkedSet;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const lodash_1 = __importDefault(require("lodash"));
const enum_1 = require("./enum");
const functions_1 = require("./schema/functions");
const sql_tools_1 = require("./sql-tools");
const set_1 = require("./utils/set");
const GeneratedUuidV7Column = (options = {}) => (0, sql_tools_1.Column)({ ...options, type: 'uuid', nullable: false, default: () => `${functions_1.immich_uuid_v7.name}()` });
const UpdateIdColumn = (options = {}) => GeneratedUuidV7Column(options);
exports.UpdateIdColumn = UpdateIdColumn;
const CreateIdColumn = (options = {}) => GeneratedUuidV7Column(options);
exports.CreateIdColumn = CreateIdColumn;
const PrimaryGeneratedUuidV7Column = () => GeneratedUuidV7Column({ primary: true });
exports.PrimaryGeneratedUuidV7Column = PrimaryGeneratedUuidV7Column;
const UpdatedAtTrigger = (name) => (0, sql_tools_1.BeforeUpdateTrigger)({
    name,
    scope: 'row',
    function: functions_1.updated_at,
});
exports.UpdatedAtTrigger = UpdatedAtTrigger;
exports.DATABASE_PARAMETER_CHUNK_SIZE = 65_500;
function chunks(collection, size) {
    if (collection instanceof Set) {
        const result = [];
        let chunk = new Set();
        for (const element of collection) {
            chunk.add(element);
            if (chunk.size === size) {
                result.push(chunk);
                chunk = new Set();
            }
        }
        if (chunk.size > 0) {
            result.push(chunk);
        }
        return result;
    }
    else {
        return lodash_1.default.chunk(collection, size);
    }
}
function Chunked(options = {}) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        const parameterIndex = options.paramIndex ?? 0;
        const chunkSize = options.chunkSize || exports.DATABASE_PARAMETER_CHUNK_SIZE;
        descriptor.value = async function (...arguments_) {
            const argument = arguments_[parameterIndex];
            if ((Array.isArray(argument) && argument.length <= chunkSize) ||
                (argument instanceof Set && argument.size <= chunkSize)) {
                return await originalMethod.apply(this, arguments_);
            }
            return Promise.all(chunks(argument, chunkSize).map(async (chunk) => {
                return await Reflect.apply(originalMethod, this, [
                    ...arguments_.slice(0, parameterIndex),
                    chunk,
                    ...arguments_.slice(parameterIndex + 1),
                ]);
            })).then((results) => (options.mergeFn ? options.mergeFn(results) : results));
        };
    };
}
function ChunkedArray(options) {
    return Chunked({ ...options, mergeFn: lodash_1.default.flatten });
}
function ChunkedSet(options) {
    return Chunked({ ...options, mergeFn: (args) => (0, set_1.setUnion)(...args) });
}
const UUID = '00000000-0000-4000-a000-000000000000';
exports.DummyValue = {
    UUID,
    UUID_SET: new Set([UUID]),
    PAGINATION: { take: 10, skip: 0 },
    EMAIL: 'user@immich.app',
    STRING: 'abcdefghi',
    NUMBER: 50,
    BUFFER: Buffer.from('abcdefghi'),
    DATE: new Date(),
    TIME_BUCKET: '2024-01-01T00:00:00.000Z',
    BOOLEAN: true,
    VECTOR: JSON.stringify(Array.from({ length: 512 }, () => 0)),
};
exports.GENERATE_SQL_KEY = 'generate-sql-key';
const Telemetry = (options) => (0, common_1.SetMetadata)(enum_1.MetadataKey.TelemetryEnabled, options?.enabled ?? true);
exports.Telemetry = Telemetry;
const GenerateSql = (...options) => (0, common_1.SetMetadata)(exports.GENERATE_SQL_KEY, options);
exports.GenerateSql = GenerateSql;
const OnEvent = (config) => (0, common_1.SetMetadata)(enum_1.MetadataKey.EventConfig, config);
exports.OnEvent = OnEvent;
const OnJob = (config) => (0, common_1.SetMetadata)(enum_1.MetadataKey.JobConfig, config);
exports.OnJob = OnJob;
const Endpoint = ({ history, ...options }) => {
    const decorators = [];
    const extensions = history?.getExtensions() ?? {};
    if (!extensions[enum_1.ApiCustomExtension.History]) {
        console.log(`Missing history for endpoint: ${options.summary}`);
    }
    if (history?.isDeprecated()) {
        options.deprecated = true;
        decorators.push((0, swagger_1.ApiTags)(enum_1.ApiTag.Deprecated));
    }
    decorators.push((0, swagger_1.ApiOperation)({ ...options, ...extensions }));
    return (0, common_1.applyDecorators)(...decorators);
};
exports.Endpoint = Endpoint;
const Property = ({ history, ...options }) => {
    const extensions = history?.getExtensions() ?? {};
    if (history?.isDeprecated()) {
        options.deprecated = true;
    }
    return (0, swagger_1.ApiProperty)({ ...options, ...extensions });
};
exports.Property = Property;
var ApiState;
(function (ApiState) {
    ApiState["Stable"] = "Stable";
    ApiState["Alpha"] = "Alpha";
    ApiState["Beta"] = "Beta";
    ApiState["Internal"] = "Internal";
    ApiState["Deprecated"] = "Deprecated";
})(ApiState || (ApiState = {}));
class HistoryBuilder {
    hasDeprecated = false;
    items = [];
    added(version, description) {
        return this.push({ version, state: 'Added', description });
    }
    updated(version, description) {
        return this.push({ version, state: 'Updated', description });
    }
    alpha(version) {
        return this.push({ version, state: ApiState.Alpha });
    }
    beta(version) {
        return this.push({ version, state: ApiState.Beta });
    }
    internal(version) {
        return this.push({ version, state: ApiState.Internal });
    }
    stable(version) {
        return this.push({ version, state: ApiState.Stable });
    }
    deprecated(version, options) {
        const { replacementId } = options || {};
        this.hasDeprecated = true;
        return this.push({ version, state: ApiState.Deprecated, replacementId });
    }
    isDeprecated() {
        return this.hasDeprecated;
    }
    getExtensions() {
        const extensions = {};
        if (this.items.length > 0) {
            extensions[enum_1.ApiCustomExtension.History] = this.items;
        }
        for (const item of this.items.toReversed()) {
            if (item.state === 'Added' || item.state === 'Updated') {
                continue;
            }
            extensions[enum_1.ApiCustomExtension.State] = item.state;
            break;
        }
        return extensions;
    }
    push(item) {
        if (!item.version.startsWith('v')) {
            throw new Error(`Version string must start with 'v': received '${JSON.stringify(item)}'`);
        }
        this.items.push(item);
        return this;
    }
}
exports.HistoryBuilder = HistoryBuilder;
//# sourceMappingURL=decorators.js.map