"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbumController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const album_dto_1 = require("../dtos/album.dto");
const asset_ids_response_dto_1 = require("../dtos/asset-ids.response.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const album_service_1 = require("../services/album.service");
const validation_1 = require("../validation");
let AlbumController = class AlbumController {
    service;
    constructor(service) {
        this.service = service;
    }
    getAllAlbums(auth, query) {
        return this.service.getAll(auth, query);
    }
    createAlbum(auth, dto) {
        return this.service.create(auth, dto);
    }
    getAlbumStatistics(auth) {
        return this.service.getStatistics(auth);
    }
    getAlbumInfo(auth, { id }, dto) {
        return this.service.get(auth, id, dto);
    }
    updateAlbumInfo(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    deleteAlbum(auth, { id }) {
        return this.service.delete(auth, id);
    }
    addAssetsToAlbum(auth, { id }, dto) {
        return this.service.addAssets(auth, id, dto);
    }
    addAssetsToAlbums(auth, dto) {
        return this.service.addAssetsToAlbums(auth, dto);
    }
    removeAssetFromAlbum(auth, dto, { id }) {
        return this.service.removeAssets(auth, id, dto);
    }
    addUsersToAlbum(auth, { id }, dto) {
        return this.service.addUsers(auth, id, dto);
    }
    updateAlbumUser(auth, { id }, userId, dto) {
        return this.service.updateUser(auth, id, userId, dto);
    }
    removeUserFromAlbum(auth, { id }, userId) {
        return this.service.removeUser(auth, id, userId);
    }
};
exports.AlbumController = AlbumController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumRead }),
    (0, decorators_1.Endpoint)({
        summary: 'List all albums',
        description: 'Retrieve a list of albums available to the authenticated user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/album.dto").AlbumResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, album_dto_1.GetAlbumsDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "getAllAlbums", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Create an album',
        description: 'Create a new album. The album can also be created with initial users and assets.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/album.dto").AlbumResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, album_dto_1.CreateAlbumDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "createAlbum", null);
__decorate([
    (0, common_1.Get)('statistics'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumStatistics }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve album statistics',
        description: 'Returns statistics about the albums available to the authenticated user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/album.dto").AlbumStatisticsResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "getAlbumStatistics", null);
__decorate([
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumRead, sharedLink: true }),
    (0, common_1.Get)(':id'),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve an album',
        description: 'Retrieve information about a specific album by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/album.dto").AlbumResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        album_dto_1.AlbumInfoDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "getAlbumInfo", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumUpdate }),
    (0, decorators_1.Endpoint)({
        summary: 'Update an album',
        description: 'Update the information of a specific album by its ID. This endpoint can be used to update the album name, description, sort order, etc. However, it is not used to add or remove assets or users from the album.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/album.dto").AlbumResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        album_dto_1.UpdateAlbumDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "updateAlbumInfo", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Delete an album',
        description: 'Delete a specific album by its ID. Note the album is initially trashed and then immediately scheduled for deletion, but relies on a background job to complete the process.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", void 0)
], AlbumController.prototype, "deleteAlbum", null);
__decorate([
    (0, common_1.Put)(':id/assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumAssetCreate, sharedLink: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Add assets to an album',
        description: 'Add multiple assets to a specific album by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-ids.response.dto").BulkIdResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        asset_ids_response_dto_1.BulkIdsDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "addAssetsToAlbum", null);
__decorate([
    (0, common_1.Put)('assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumAssetCreate, sharedLink: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Add assets to albums',
        description: 'Send a list of asset IDs and album IDs to add each asset to each album.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/album.dto").AlbumsAddAssetsResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, album_dto_1.AlbumsAddAssetsDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "addAssetsToAlbums", null);
__decorate([
    (0, common_1.Delete)(':id/assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumAssetDelete }),
    (0, decorators_1.Endpoint)({
        summary: 'Remove assets from an album',
        description: 'Remove multiple assets from a specific album by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-ids.response.dto").BulkIdResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        asset_ids_response_dto_1.BulkIdsDto,
        validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "removeAssetFromAlbum", null);
__decorate([
    (0, common_1.Put)(':id/users'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumUserCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Share album with users',
        description: 'Share an album with multiple users. Each user can be given a specific role in the album.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/album.dto").AlbumResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        album_dto_1.AddUsersDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "addUsersToAlbum", null);
__decorate([
    (0, common_1.Put)(':id/user/:userId'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumUserUpdate }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Update user role',
        description: 'Change the role for a specific user in a specific album.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Param)('userId', new validation_1.ParseMeUUIDPipe({ version: '4' }))),
    __param(3, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto, String, album_dto_1.UpdateAlbumUserDto]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "updateAlbumUser", null);
__decorate([
    (0, common_1.Delete)(':id/user/:userId'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AlbumUserDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Remove user from album',
        description: 'Remove a user from an album. Use an ID of "me" to leave a shared album.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Param)('userId', new validation_1.ParseMeUUIDPipe({ version: '4' }))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto, String]),
    __metadata("design:returntype", Promise)
], AlbumController.prototype, "removeUserFromAlbum", null);
exports.AlbumController = AlbumController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Albums),
    (0, common_1.Controller)('albums'),
    __metadata("design:paramtypes", [album_service_1.AlbumService])
], AlbumController);
//# sourceMappingURL=album.controller.js.map