"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromptEmailQuestion = exports.RevokeAdminCommand = exports.GrantAdminCommand = void 0;
const nest_commander_1 = require("nest-commander");
const cli_service_1 = require("../services/cli.service");
const prompt = (inquirer) => {
    return function ask() {
        return inquirer.ask('prompt-email', {}).then(({ email }) => email);
    };
};
let GrantAdminCommand = class GrantAdminCommand extends nest_commander_1.CommandRunner {
    service;
    inquirer;
    constructor(service, inquirer) {
        super();
        this.service = service;
        this.inquirer = inquirer;
    }
    async run() {
        try {
            const email = await prompt(this.inquirer)();
            await this.service.grantAdminAccess(email);
            console.debug('Admin access has been granted to', email);
        }
        catch (error) {
            console.error(error);
            console.error('Unable to grant admin access to user');
        }
    }
};
exports.GrantAdminCommand = GrantAdminCommand;
exports.GrantAdminCommand = GrantAdminCommand = __decorate([
    (0, nest_commander_1.Command)({
        name: 'grant-admin',
        description: 'Grant admin privileges to a user (by email)',
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService,
        nest_commander_1.InquirerService])
], GrantAdminCommand);
let RevokeAdminCommand = class RevokeAdminCommand extends nest_commander_1.CommandRunner {
    service;
    inquirer;
    constructor(service, inquirer) {
        super();
        this.service = service;
        this.inquirer = inquirer;
    }
    async run() {
        try {
            const email = await prompt(this.inquirer)();
            await this.service.revokeAdminAccess(email);
            console.debug('Admin access has been revoked from', email);
        }
        catch (error) {
            console.error(error);
            console.error('Unable to revoke admin access from user');
        }
    }
};
exports.RevokeAdminCommand = RevokeAdminCommand;
exports.RevokeAdminCommand = RevokeAdminCommand = __decorate([
    (0, nest_commander_1.Command)({
        name: 'revoke-admin',
        description: 'Revoke admin privileges from a user (by email)',
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService,
        nest_commander_1.InquirerService])
], RevokeAdminCommand);
let PromptEmailQuestion = class PromptEmailQuestion {
    parseEmail(value) {
        return value;
    }
};
exports.PromptEmailQuestion = PromptEmailQuestion;
__decorate([
    (0, nest_commander_1.Question)({
        message: 'Please enter the user email: ',
        name: 'email',
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PromptEmailQuestion.prototype, "parseEmail", null);
exports.PromptEmailQuestion = PromptEmailQuestion = __decorate([
    (0, nest_commander_1.QuestionSet)({ name: 'prompt-email' })
], PromptEmailQuestion);
//# sourceMappingURL=grant-admin.js.map