import { AssetType } from 'src/enum';
import { previewFile } from 'test/fixtures/asset.stub';
import { userStub } from 'test/fixtures/user.stub';

const updateId = '0d1173e3-4d80-4d76-b41e-57d56de21125';

export const personStub = {
  noName: Object.freeze({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: '',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
    isFavorite: false,
    color: 'red',
  }),
  hidden: Object.freeze({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: '',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: true,
    isFavorite: false,
    color: 'red',
  }),
  withName: Object.freeze({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: 'Person 1',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: 'assetFaceId',
    faceAsset: null,
    isHidden: false,
    isFavorite: false,
    color: 'red',
  }),
  withBirthDate: Object.freeze({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: 'Person 1',
    birthDate: new Date('1976-06-30'),
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
    isFavorite: false,
    color: 'red',
  }),
  noThumbnail: Object.freeze({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: '',
    birthDate: null,
    thumbnailPath: '',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
    isFavorite: false,
    color: 'red',
  }),
  newThumbnail: Object.freeze({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: '',
    birthDate: null,
    thumbnailPath: '/new/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: 'asset-id',
    faceAsset: null,
    isHidden: false,
    isFavorite: false,
    color: 'red',
  }),
  primaryPerson: Object.freeze({
    id: 'person-1',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: 'Person 1',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
    isFavorite: false,
    color: 'red',
  }),
  mergePerson: Object.freeze({
    id: 'person-2',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: 'Person 2',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
    isFavorite: false,
    color: 'red',
  }),
  randomPerson: Object.freeze({
    id: 'person-3',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: '',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail',
    faces: [],
    faceAssetId: null,
    faceAsset: null,
    isHidden: false,
    isFavorite: false,
    color: 'red',
  }),
  isFavorite: Object.freeze({
    id: 'person-4',
    createdAt: new Date('2021-01-01'),
    updatedAt: new Date('2021-01-01'),
    updateId,
    ownerId: userStub.admin.id,
    name: 'Person 1',
    birthDate: null,
    thumbnailPath: '/path/to/thumbnail.jpg',
    faces: [],
    faceAssetId: 'assetFaceId',
    faceAsset: null,
    isHidden: false,
    isFavorite: true,
    color: 'red',
  }),
};

export const personThumbnailStub = {
  newThumbnailStart: Object.freeze({
    ownerId: userStub.admin.id,
    x1: 5,
    y1: 5,
    x2: 505,
    y2: 505,
    oldHeight: 2880,
    oldWidth: 2160,
    type: AssetType.Image,
    originalPath: '/original/path.jpg',
    exifOrientation: '1',
    previewPath: previewFile.path,
  }),
  newThumbnailMiddle: Object.freeze({
    ownerId: userStub.admin.id,
    x1: 100,
    y1: 100,
    x2: 200,
    y2: 200,
    oldHeight: 500,
    oldWidth: 400,
    type: AssetType.Image,
    originalPath: '/original/path.jpg',
    exifOrientation: '1',
    previewPath: previewFile.path,
  }),
  newThumbnailEnd: Object.freeze({
    ownerId: userStub.admin.id,
    x1: 300,
    y1: 300,
    x2: 495,
    y2: 495,
    oldHeight: 500,
    oldWidth: 500,
    type: AssetType.Image,
    originalPath: '/original/path.jpg',
    exifOrientation: '1',
    previewPath: previewFile.path,
  }),
  rawEmbeddedThumbnail: Object.freeze({
    ownerId: userStub.admin.id,
    x1: 100,
    y1: 100,
    x2: 200,
    y2: 200,
    oldHeight: 500,
    oldWidth: 400,
    type: AssetType.Image,
    originalPath: '/original/path.dng',
    exifOrientation: '1',
    previewPath: previewFile.path,
  }),
  negativeCoordinate: Object.freeze({
    ownerId: userStub.admin.id,
    x1: -176,
    y1: -230,
    x2: 193,
    y2: 251,
    oldHeight: 1440,
    oldWidth: 2162,
    type: AssetType.Image,
    originalPath: '/original/path.jpg',
    exifOrientation: '1',
    previewPath: previewFile.path,
  }),
  overflowingCoordinate: Object.freeze({
    ownerId: userStub.admin.id,
    x1: 2097,
    y1: 0,
    x2: 2171,
    y2: 152,
    oldHeight: 1440,
    oldWidth: 2162,
    type: AssetType.Image,
    originalPath: '/original/path.jpg',
    exifOrientation: '1',
    previewPath: previewFile.path,
  }),
  videoThumbnail: Object.freeze({
    ownerId: userStub.admin.id,
    x1: 100,
    y1: 100,
    x2: 200,
    y2: 200,
    oldHeight: 500,
    oldWidth: 400,
    type: AssetType.Video,
    originalPath: '/original/path.mp4',
    exifOrientation: '1',
    previewPath: previewFile.path,
  }),
};
