"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var OpenTelemetryCoreModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenTelemetryCoreModule = void 0;
const common_1 = require("@nestjs/common");
const host_metrics_1 = require("@opentelemetry/host-metrics");
const api_1 = require("@opentelemetry/api");
const metric_service_1 = require("./metrics/metric.service");
const middleware_1 = require("./middleware");
const opentelemetry_constants_1 = require("./opentelemetry.constants");
const trace_service_1 = require("./tracing/trace.service");
const core_1 = require("@nestjs/core");
const middleware_utils_1 = require("./middleware.utils");
/**
 * The internal OpenTelemetry Module which handles the integration
 * with the third party OpenTelemetry library and Nest
 *
 * @internal
 */
let OpenTelemetryCoreModule = OpenTelemetryCoreModule_1 = class OpenTelemetryCoreModule {
    options;
    adapterHost;
    logger = new common_1.Logger('OpenTelemetryModule');
    constructor(options = {}, adapterHost) {
        this.options = options;
        this.adapterHost = adapterHost;
    }
    /**
     * Bootstraps the internal OpenTelemetry Module with the given options
     * synchronously and sets the correct providers
     * @param options The options to bootstrap the module synchronously
     */
    static forRoot(options = {}) {
        const openTelemetryModuleOptions = {
            provide: opentelemetry_constants_1.OPENTELEMETRY_MODULE_OPTIONS,
            useValue: options,
        };
        return {
            module: OpenTelemetryCoreModule_1,
            providers: [openTelemetryModuleOptions, trace_service_1.TraceService, metric_service_1.MetricService],
            exports: [trace_service_1.TraceService, metric_service_1.MetricService],
        };
    }
    /**
     * Bootstraps the internal OpenTelemetry Module with the given
     * options asynchronously and sets the correct providers
     * @param options The options to bootstrap the module
     */
    static forRootAsync(options) {
        const asyncProviders = this.createAsyncProviders(options);
        return {
            module: OpenTelemetryCoreModule_1,
            imports: [...(options.imports || [])],
            providers: [...asyncProviders, trace_service_1.TraceService, metric_service_1.MetricService],
            exports: [trace_service_1.TraceService, metric_service_1.MetricService],
        };
    }
    configure(consumer) {
        const { apiMetrics = { enable: false } } = this.options?.metrics ?? {};
        if (apiMetrics.enable === true) {
            const adapter = this.adapterHost.httpAdapter;
            const mountPoint = (0, middleware_utils_1.getMiddlewareMountPoint)(adapter);
            if (apiMetrics?.ignoreRoutes && apiMetrics?.ignoreRoutes.length > 0) {
                consumer
                    .apply(middleware_1.ApiMetricsMiddleware)
                    .exclude(...apiMetrics.ignoreRoutes)
                    .forRoutes(mountPoint);
            }
            else {
                consumer.apply(middleware_1.ApiMetricsMiddleware).forRoutes(mountPoint);
            }
        }
    }
    async onApplicationBootstrap() {
        let hostMetrics = false;
        if (this.options?.metrics) {
            hostMetrics =
                this.options.metrics.hostMetrics !== undefined ? this.options.metrics.hostMetrics : false;
        }
        const meterProvider = api_1.metrics.getMeterProvider();
        if (hostMetrics) {
            const host = new host_metrics_1.HostMetrics({ meterProvider, name: 'host-metrics' });
            host.start();
        }
    }
    /**
     * Returns the asynchrnous OpenTelemetry options providers depending on the
     * given module options
     * @param options Options for the asynchrnous OpenTelemetry module
     */
    static createAsyncOptionsProvider(options) {
        if (options.useFactory) {
            return {
                provide: opentelemetry_constants_1.OPENTELEMETRY_MODULE_OPTIONS,
                useFactory: options.useFactory,
                inject: options.inject || [],
            };
        }
        if (options.useClass || options.useExisting) {
            const inject = [
                (options.useClass || options.useExisting),
            ];
            return {
                provide: opentelemetry_constants_1.OPENTELEMETRY_MODULE_OPTIONS,
                useFactory: async (optionsFactory) => optionsFactory.createOpenTelemetryOptions(),
                inject,
            };
        }
        throw new Error();
    }
    /**
     * Returns the asynchrnous providers depending on the given module
     * options
     * @param options Options for the asynchrnous OpenTelemetry module
     */
    static createAsyncProviders(options) {
        if (options.useFactory || options.useExisting) {
            return [this.createAsyncOptionsProvider(options)];
        }
        const useClass = options.useClass;
        return [
            this.createAsyncOptionsProvider(options),
            {
                provide: useClass,
                useClass,
            },
        ];
    }
};
exports.OpenTelemetryCoreModule = OpenTelemetryCoreModule;
exports.OpenTelemetryCoreModule = OpenTelemetryCoreModule = OpenTelemetryCoreModule_1 = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({}),
    __param(0, (0, common_1.Inject)(opentelemetry_constants_1.OPENTELEMETRY_MODULE_OPTIONS)),
    __metadata("design:paramtypes", [Object, core_1.HttpAdapterHost])
], OpenTelemetryCoreModule);
