"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMiddlewareMountPoint = getMiddlewareMountPoint;
const feature_detection_utils_1 = require("./feature-detection.utils");
const MOUNT_POINT_EXPRESS_5 = '/';
const MOUNT_POINT_FASTIFY_5 = '{*path}';
function getMiddlewareMountPoint(adapter) {
    const httpAdapterType = (0, feature_detection_utils_1.detectHttpAdapterType)(adapter);
    if (httpAdapterType === feature_detection_utils_1.HttpAdapterType.FASTIFY) {
        return MOUNT_POINT_FASTIFY_5;
    }
    else {
        return MOUNT_POINT_EXPRESS_5;
    }
}
