//#region rolldown:runtime
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function() {
	return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
	if (from && typeof from === "object" || typeof from === "function") for (var keys = __getOwnPropNames(from), i = 0, n = keys.length, key; i < n; i++) {
		key = keys[i];
		if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
			get: ((k) => from[k]).bind(null, key),
			enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
		});
	}
	return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
	value: mod,
	enumerable: true
}) : target, mod));

//#endregion
const __nestjs_common = __toESM(require("@nestjs/common"));
const kysely = __toESM(require("kysely"));

//#region src/constants/kysely.constants.ts
const KYSELY_MODULE_CONNECTION_TOKEN = (namespace) => `KyselyModuleConnectionToken${namespace ? "_" + namespace : ""}`;
const KYSELY_MODULE_OPTIONS_TOKEN = "KyselyModuleOptionsToken";

//#endregion
//#region src/decorators/kysely.decorator.ts
const InjectKysely = (namespace) => (0, __nestjs_common.Inject)(KYSELY_MODULE_CONNECTION_TOKEN(namespace));

//#endregion
//#region src/kysely.service.ts
var KyselyService = class {
	storedActiveClients = /* @__PURE__ */ new Set();
	get activeClients() {
		return Array.from(this.storedActiveClients);
	}
	addClient(client) {
		this.storedActiveClients.add(client);
	}
	async onApplicationShutdown() {
		for (const client of this.storedActiveClients.values()) try {
			await client.destroy();
			this.storedActiveClients.delete(client);
		} catch (e) {
			console.error(`Failed to destroy Kysely client: ${e}`);
		}
	}
};

//#endregion
//#region src/factories/kysely-client.factory.ts
const createKyselyClient = ({ config, service }) => {
	const client = new kysely.Kysely(config);
	service.addClient(client);
	return client;
};
const createKyselyProvider = (options) => {
	if (Array.isArray(options)) return options.map((opt) => {
		return {
			inject: [KyselyService],
			provide: KYSELY_MODULE_CONNECTION_TOKEN(opt.namespace),
			useFactory: (kyselyService) => createKyselyClient({
				config: opt,
				service: kyselyService
			})
		};
	});
	else return [{
		inject: [KyselyService],
		provide: KYSELY_MODULE_CONNECTION_TOKEN(),
		useFactory: (kyselyService) => createKyselyClient({
			config: options,
			service: kyselyService
		})
	}];
};

//#endregion
//#region src/providers/kysely.provider-factory.ts
const createAsyncProviders = (options) => {
	const { useExisting, useFactory, useClass } = options;
	if (useExisting || useFactory) return [createAsyncOptionsProvider(options)];
	if (!useClass) throw new Error("Invalid options");
	return [createAsyncOptionsProvider(options), {
		provide: useClass,
		useClass
	}];
};
const createAsyncOptionsProvider = (options) => {
	const { useFactory, inject, useExisting, useClass } = options;
	if (useFactory) return {
		inject,
		provide: KYSELY_MODULE_OPTIONS_TOKEN,
		useFactory
	};
	if (useExisting) return {
		inject: [useExisting || useClass],
		provide: KYSELY_MODULE_OPTIONS_TOKEN,
		useFactory: (optionsFactory) => optionsFactory.createKyselyModuleOptions()
	};
	throw new Error("Invalid options");
};

//#endregion
//#region node_modules/@oxc-project/runtime/src/helpers/decorate.js
var require_decorate = /* @__PURE__ */ __commonJS({ "node_modules/@oxc-project/runtime/src/helpers/decorate.js": ((exports, module) => {
	function __decorate(decorators, target, key, desc) {
		var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
		if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
		else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
		return c > 3 && r && Object.defineProperty(target, key, r), r;
	}
	module.exports = __decorate, module.exports.__esModule = true, module.exports["default"] = module.exports;
}) });

//#endregion
//#region src/kysely.core.module.ts
var import_decorate$1 = /* @__PURE__ */ __toESM(require_decorate(), 1);
var _KyselyCoreModule;
let KyselyCoreModule = _KyselyCoreModule = class KyselyCoreModule$1 {
	static forRoot(config) {
		const providers = createKyselyProvider(config);
		return {
			exports: providers,
			module: _KyselyCoreModule,
			providers: [...providers, KyselyService]
		};
	}
	static forRootAsync(options) {
		const provider = {
			inject: [KYSELY_MODULE_OPTIONS_TOKEN, KyselyService],
			provide: KYSELY_MODULE_CONNECTION_TOKEN(options?.namespace),
			useFactory: (config, service) => createKyselyClient({
				config,
				service
			})
		};
		return {
			exports: [provider],
			imports: options.imports,
			module: _KyselyCoreModule,
			providers: [
				...createAsyncProviders(options),
				provider,
				KyselyService
			]
		};
	}
};
KyselyCoreModule = _KyselyCoreModule = (0, import_decorate$1.default)([(0, __nestjs_common.Global)(), (0, __nestjs_common.Module)({})], KyselyCoreModule);

//#endregion
//#region src/kysely.module.ts
var import_decorate = /* @__PURE__ */ __toESM(require_decorate(), 1);
var _KyselyModule;
let KyselyModule = _KyselyModule = class KyselyModule$1 {
	static forRoot(config) {
		return {
			module: _KyselyModule,
			imports: [KyselyCoreModule.forRoot(config)]
		};
	}
	static forRootAsync(options) {
		return {
			module: _KyselyModule,
			imports: [KyselyCoreModule.forRootAsync(options)]
		};
	}
};
KyselyModule = _KyselyModule = (0, import_decorate.default)([(0, __nestjs_common.Module)({})], KyselyModule);

//#endregion
exports.InjectKysely = InjectKysely;
exports.KYSELY_MODULE_CONNECTION_TOKEN = KYSELY_MODULE_CONNECTION_TOKEN;
exports.KYSELY_MODULE_OPTIONS_TOKEN = KYSELY_MODULE_OPTIONS_TOKEN;
Object.defineProperty(exports, 'KyselyModule', {
  enumerable: true,
  get: function () {
    return KyselyModule;
  }
});
//# sourceMappingURL=index.cjs.map