"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Promise_withResolvers = Promise_withResolvers;
/**
 * Simulates the behavior of Promise.withResolvers
 * that is available in Node 22
 *
 * FUTURE: Remove this polyfill once we target Node 22
 */
function Promise_withResolvers() {
    let resolve;
    let reject;
    const promise = new Promise((res, rej) => {
        resolve = res;
        reject = rej;
    });
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    return { promise, resolve: resolve, reject: reject };
}
//# sourceMappingURL=promise-with-resolvers.polyfill.js.map