"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClsPluginManager = void 0;
const cls_service_globals_1 = require("../cls-service.globals");
const cls_plugin_module_1 = require("./cls-plugin.module");
class ClsPluginManager {
    static registerPlugins(plugins = []) {
        this.plugins.push(...plugins);
        return plugins.map((plugin) => (0, cls_plugin_module_1.createClsPluginModule)(plugin));
    }
    static getPlugins() {
        return this.plugins;
    }
    static async onClsInit() {
        for (const plugin of this.plugins) {
            await plugin.onClsInit?.(this.clsService);
        }
    }
}
exports.ClsPluginManager = ClsPluginManager;
ClsPluginManager.clsService = cls_service_globals_1.globalClsService;
ClsPluginManager.plugins = [];
//# sourceMappingURL=cls-plugin-manager.js.map