"use strict";

var _extractNationalNumber = _interopRequireDefault(require("./extractNationalNumber.js"));
var _metadata = _interopRequireDefault(require("../metadata.js"));
var _metadataMin = _interopRequireDefault(require("../../test/metadata/1.0.0/metadata.min.json"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
describe('extractNationalNumber', function () {
  it('should extract a national number when using old metadata (no `country` or `defaultCountry` specified)', function () {
    var _oldMetadata = new _metadata["default"](_metadataMin["default"]);
    _oldMetadata.selectNumberingPlan('RU');
    expect((0, _extractNationalNumber["default"])('88005553535', undefined, _oldMetadata)).to.deep.equal({
      nationalNumber: '8005553535',
      carrierCode: undefined
    });
  });
  it('should extract a national number when using old metadata (`country` is specified)', function () {
    var _oldMetadata = new _metadata["default"](_metadataMin["default"]);
    _oldMetadata.selectNumberingPlan('RU');
    expect((0, _extractNationalNumber["default"])('88005553535', 'RU', _oldMetadata)).to.deep.equal({
      nationalNumber: '8005553535',
      carrierCode: undefined
    });
  });
});
//# sourceMappingURL=extractNationalNumber.test.js.map