import { ExifToolOptions } from "./ExifToolOptions";
import { ExifToolTask, ExifToolTaskOptions } from "./ExifToolTask";
import { WriteTags } from "./WriteTags";
export declare function htmlEncode(s: string): string;
export declare const WriteTaskOptionFields: ["useMWG", "struct", "ignoreMinorErrors", "writeArgs"];
/**
 * Options for {@link ExifTool.write}
 *
 * @see {@link ExifToolOptions#useMWG}
 * @see {@link ExifToolOptions#struct}
 * @see {@link ExifToolOptions#ignoreMinorErrors}
 * @see {@link ExifToolOptions#writeArgs}
 */
export type WriteTaskOptions = Partial<Pick<ExifToolOptions, (typeof WriteTaskOptionFields)[number]>>;
export declare const DefaultWriteTaskOptions: {
    readonly useMWG: boolean;
    readonly ignoreMinorErrors: boolean;
    readonly struct: "undef" | 0 | 1 | 2;
    readonly writeArgs: string[];
};
export interface WriteTaskResult {
    /**
     * Number of files created by ExifTool
     */
    created: number;
    /**
     * Number of files updated by ExifTool. Note that this does not mean any
     * field values were _changed_ from prior values.
     */
    updated: number;
    /**
     * Number of files that ExifTool knew it did not need change. Note that
     * ExifTool (at least as of v12.70) only realizes it doesn't need to change
     * a file if you are clearing an already empty value.
     */
    unchanged: number;
    /**
     * Non-exceptional warnings from ExifTool, like "Error: Nothing to write",
     * or "Nothing to do."
     *
     * Any invalid tag names or values will cause Errors to be thrown.
     */
    warnings?: string[];
}
/**
 * Task for writing metadata tags to a file.
 */
export declare class WriteTask extends ExifToolTask<WriteTaskResult> {
    readonly sourceFile: string;
    readonly args: string[];
    readonly options: ExifToolTaskOptions;
    /**
     * @param sourceFile the file to write metadata to
     * @param args the ExifTool arguments
     * @param options task options
     */
    constructor(sourceFile: string, args: string[], options: ExifToolTaskOptions);
    /**
     * Creates a WriteTask for the given file and tags.
     * @param filename the file to write metadata to
     * @param tags the metadata tags to write
     * @param options write task options
     * @returns a new WriteTask instance
     */
    static for(filename: string, tags: WriteTags, options: Partial<WriteTaskOptions> & Required<ExifToolTaskOptions>): WriteTask;
    toString(): string;
    parse(data: string, error?: Error): WriteTaskResult;
}
