"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isStruct = isStruct;
const DateTime_1 = require("./DateTime");
function isStruct(o) {
    return (o != null &&
        o.constructor?.name === "Object" &&
        Object.values(o).every((v) => {
            const t = typeof v;
            return (t === "string" ||
                t === "number" ||
                (0, DateTime_1.isDateOrTime)(v) ||
                isStruct(v) ||
                Array.isArray(v));
        }));
}
//# sourceMappingURL=Struct.js.map