import { ExifToolTask, ExifToolTaskOptions } from "./ExifToolTask";
/**
 * Task for rewriting all metadata tags in a file, which can repair corrupted metadata.
 */
export declare class RewriteAllTagsTask extends ExifToolTask<void> {
    private constructor();
    /**
     * Creates a task to rewrite all metadata tags from source to destination.
     * @param imgSrc the source image file path
     * @param imgDest the destination file path
     * @param opts options including allowMakerNoteRepair for fixing corrupted MakerNote data
     * @returns a new RewriteAllTagsTask instance
     */
    static for(imgSrc: string, imgDest: string, opts: {
        allowMakerNoteRepair?: boolean;
    } & ExifToolTaskOptions): RewriteAllTagsTask;
    parse(data: string, error?: Error): void;
}
