"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Utf8FilenameCharsetArgs = void 0;
const IsWin32_1 = require("./IsWin32");
/**
 * Tells ExifTool to handle UTF-8-encoded filenames on Windows.
 *
 * Without this setting, non-latin filename characters on Windows won't be
 * encoded correctly, and the file will be erroneously reported as not
 * existing.
 *
 * This setting isn't necessary on non-Windows platforms, nor on Windows
 * machines that have been configured to use UTF-8, but it doesn't hurt
 * anything to include this option.
 *
 * @see https://github.com/photostructure/exiftool-vendored.js/issues/124
 * @see https://exiftool.org/exiftool_pod.html#WINDOWS-UNICODE-FILE-NAMES
 * @see https://exiftool.org/faq.html#Q10
 */
exports.Utf8FilenameCharsetArgs = (0, IsWin32_1.isWin32)()
    ? ["-charset", "filename=utf8"]
    : [];
//# sourceMappingURL=FilenameCharsetArgs.js.map