/**
 * Checks if a file is empty or does not exist.
 * @param path - the file path to check
 * @returns true if the file is empty or does not exist, false otherwise
 * @throws if path is blank or if a non-ENOENT error occurs
 */
export declare function isFileEmpty(path: string): Promise<boolean>;
/**
 * Returns true if the current platform has case-sensitive file paths.
 */
export declare const isPlatformCaseSensitive: import("./Lazy").Lazy<boolean>;
/**
 * Compares two file paths for equality, respecting platform case sensitivity.
 * @param a - first file path
 * @param b - second file path
 * @returns true if paths refer to the same file
 */
export declare function compareFilePaths(a: string, b: string): boolean;
