"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.exiftoolPath = exiftoolPath;
const _fs = __importStar(require("node:fs"));
const _path = __importStar(require("node:path"));
const IsWin32_1 = require("./IsWin32");
const Which_1 = require("./Which");
function vendorPackage() {
    return "exiftool-vendored." + ((0, IsWin32_1.isWin32)() ? "exe" : "pl");
}
async function tryImport({ prefix = "", logger, } = {}) {
    const id = prefix + vendorPackage();
    try {
        const module = await Promise.resolve(`${id}`).then(s => __importStar(require(s)));
        return module.default ?? module;
    }
    catch (error) {
        logger?.warn(id + " not found: ", error);
        return;
    }
}
/**
 * This implementation relies on the fact that both `exiftool-vendored.pl` and
 * `exiftool-vendored.exe` both export the path to their respective exiftool
 * binary.
 *
 * When running in node, this method should suffice.
 *
 * When running in Electron, all bets are off, due to ASAR packaging and other
 * nonsense. As perl can't run from within an ASAR archive, `electron-builder`
 * must be configured to `asarUnpack`
 * "**&#47;node_modules/exiftool-vendored.{pl,exe}/". See
 * <https://www.electron.build/generated/platformspecificbuildoptions#configuration-asarUnpack>
 * for details.
 *
 * If you're using `electron-forge`, add something like the following to your
 * ForgeConfig.packagerConfig.extraResource array: `fs.join(".", "node_modules",
 * "exiftool-vendored." + (isWin ? "exe" : "pl"))` but then you must specify a
 * custom exiftoolPath in your options hash, as subprocesses that use
 * ELECTRON_RUN_AS_NODE will no longer have process.resourcesPath set.
 *
 * If none of the above work for your use case, you can provide your own
 * `exiftoolPath` implementation to your instance of ExifTool
 *
 * @return the path to the exiftool binary, preferring the vendored version in
 * node_modules.
 */
async function exiftoolPath(logger) {
    const path = await tryImport({ prefix: "", logger });
    // This s/app.asar/app.asar.unpacked/ path switch adds support for Electron
    // apps whose modules are ASAR-packed (like by electron-builder).
    const asarUnpackedPath = path
        ?.split(_path.sep)
        .map((ea) => (ea === "app.asar" ? "app.asar.unpacked" : ea))
        .join(_path.sep);
    // NOTE: we must check for the fixedPath FIRST, because Electron's ASAR
    // shenanigans will make existsSync return true for asar-packed resources
    if (asarUnpackedPath != null && _fs.existsSync(asarUnpackedPath)) {
        return asarUnpackedPath;
    }
    if (path != null && _fs.existsSync(path)) {
        return path;
    }
    logger?.warn("Failed to find exiftool via " + vendorPackage());
    // process.resourcesPath is set by electron-forge:
    const electronResourcePath = process
        .resourcesPath;
    if (electronResourcePath != null) {
        const forgePath = _path.join(electronResourcePath, vendorPackage(), "bin", "exiftool" + ((0, IsWin32_1.isWin32)() ? ".exe" : ""));
        if (_fs.existsSync(forgePath)) {
            return forgePath;
        }
        else {
            logger?.warn("Failed to find exiftool in electron forge resources path: " +
                forgePath);
        }
    }
    // Last ditch: is there a globally installed exiftool in the PATH?
    const fromPath = await (0, Which_1.which)("exiftool");
    if (fromPath != null) {
        return fromPath;
    }
    throw new Error(`Failed to find ExifTool installation: set exiftoolPath explicitly.`);
}
//# sourceMappingURL=ExiftoolPath.js.map