import { ErrorsAndWarnings } from "./ErrorsAndWarnings";
import { StrEnum, StrEnumKeys } from "./StrEnum";
/**
 * This tags are added to {@link Tags} from this library.
 */
export interface ExifToolVendoredTags extends ErrorsAndWarnings {
    /**
     * Either an offset, like `UTC-7`, or an actual IANA timezone, like
     * `America/Los_Angeles`.
     *
     * This will be missing if we can't intuit a timezone from the metadata.
     * @deprecated use `zone` instead
     */
    tz?: string;
    /**
     * The IANA timezone, like `America/Los_Angeles`, or a IANA-rendered static offset, like `UTC-7`.
     *
     * This will be missing if we can't intuit a timezone from the metadata.
     */
    zone?: string;
    /**
     * Description of where and how `tz` was extracted
     * @deprecated use `zoneSource` instead
     */
    tzSource?: string;
    /**
     * Description of where and how `zone` was extracted
     */
    zoneSource?: string;
}
export declare const ExifToolVendoredTagNames: StrEnum<"zone" | "tz" | "tzSource" | "zoneSource" | "errors" | "warnings">;
export type ExifToolVendoredTagName = StrEnumKeys<typeof ExifToolVendoredTagNames>;
