import * as bc from "batch-cluster";
import { ExifToolOptions } from "./ExifToolOptions";
export type ExifToolTaskOptions = Pick<ExifToolOptions, "ignoreMinorErrors">;
export declare abstract class ExifToolTask<T> extends bc.Task<T> {
    #private;
    readonly args: string[];
    readonly options?: ExifToolTaskOptions | undefined;
    static renderCommand(args: string[], options?: ExifToolTaskOptions): string;
    readonly errors: string[];
    readonly warnings: string[];
    constructor(args: string[], options?: ExifToolTaskOptions | undefined);
    onStderr(buf: string | Buffer): void;
    protected abstract parse(input: string, error?: Error): T;
}
