import child_process from "node:child_process";
import { InternalBatchProcessOptions } from "./InternalBatchProcessOptions";
import { Task } from "./Task";
/**
 * Utility class for managing process termination lifecycle
 */
export declare class ProcessTerminator {
    #private;
    private readonly opts;
    constructor(opts: InternalBatchProcessOptions);
    /**
     * Terminates a child process gracefully or forcefully
     *
     * @param proc The child process to terminate
     * @param processName Name for logging purposes
     * @param pid Process ID
     * @param lastTask Current task being processed
     * @param startupTaskId ID of the startup task
     * @param gracefully Whether to wait for current task completion
     * @param reason Reason for termination
     * @param isExited Whether the process has already exited
     * @param isRunning Function to check if process is still running
     * @returns Promise that resolves when termination is complete
     */
    terminate(proc: child_process.ChildProcess, processName: string, lastTask: Task<unknown> | undefined, startupTaskId: number, gracefully: boolean, isExited: boolean, isRunning: () => boolean): Promise<void>;
}
