"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseMetrics = void 0;
const api_1 = require("@opentelemetry/api");
/** @knipignore */
const version_1 = require("./version");
const DEFAULT_NAME = version_1.PACKAGE_NAME;
/**
 * Base Class for metrics
 */
class BaseMetrics {
    _logger = api_1.diag;
    _meter;
    _name;
    constructor(config) {
        // Do not use `??` operator to allow falling back to default when the
        // specified name is an empty string.
        this._name = config?.name || DEFAULT_NAME;
        const meterProvider = config?.meterProvider ?? api_1.metrics.getMeterProvider();
        this._meter = meterProvider.getMeter(this._name, version_1.PACKAGE_VERSION);
    }
}
exports.BaseMetrics = BaseMetrics;
//# sourceMappingURL=BaseMetrics.js.map