import { BulkIdResponseDto, BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetFaceCreateDto, AssetFaceDeleteDto, AssetFaceResponseDto, AssetFaceUpdateDto, FaceDto, MergePersonDto, PeopleResponseDto, PeopleUpdateDto, PersonCreateDto, PersonResponseDto, PersonSearchDto, PersonStatisticsResponseDto, PersonUpdateDto } from 'src/dtos/person.dto';
import { JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
import { ImmichFileResponse } from 'src/utils/file';
export declare class PersonService extends BaseService {
    getAll(auth: AuthDto, dto: PersonSearchDto): Promise<PeopleResponseDto>;
    reassignFaces(auth: AuthDto, personId: string, dto: AssetFaceUpdateDto): Promise<PersonResponseDto[]>;
    reassignFacesById(auth: AuthDto, personId: string, dto: FaceDto): Promise<PersonResponseDto>;
    getFacesById(auth: AuthDto, dto: FaceDto): Promise<AssetFaceResponseDto[]>;
    createNewFeaturePhoto(changeFeaturePhoto: string[]): Promise<void>;
    getById(auth: AuthDto, id: string): Promise<PersonResponseDto>;
    getStatistics(auth: AuthDto, id: string): Promise<PersonStatisticsResponseDto>;
    getThumbnail(auth: AuthDto, id: string): Promise<ImmichFileResponse>;
    create(auth: AuthDto, dto: PersonCreateDto): Promise<PersonResponseDto>;
    update(auth: AuthDto, id: string, dto: PersonUpdateDto): Promise<PersonResponseDto>;
    delete(auth: AuthDto, id: string): Promise<void>;
    updateAll(auth: AuthDto, dto: PeopleUpdateDto): Promise<BulkIdResponseDto[]>;
    deleteAll(auth: AuthDto, { ids }: BulkIdsDto): Promise<void>;
    private removeAllPeople;
    handlePersonCleanup(): Promise<JobStatus>;
    handleQueueDetectFaces({ force }: JobOf<JobName.AssetDetectFacesQueueAll>): Promise<JobStatus>;
    handleDetectFaces({ id }: JobOf<JobName.AssetDetectFaces>): Promise<JobStatus>;
    private iou;
    handleQueueRecognizeFaces({ force, nightly }: JobOf<JobName.FacialRecognitionQueueAll>): Promise<JobStatus>;
    handleRecognizeFaces({ id, deferred }: JobOf<JobName.FacialRecognition>): Promise<JobStatus>;
    handlePersonMigration({ id }: JobOf<JobName.PersonFileMigration>): Promise<JobStatus>;
    mergePerson(auth: AuthDto, id: string, dto: MergePersonDto): Promise<BulkIdResponseDto[]>;
    private findOrFail;
    createFace(auth: AuthDto, dto: AssetFaceCreateDto): Promise<void>;
    deleteFace(auth: AuthDto, id: string, dto: AssetFaceDeleteDto): Promise<void>;
}
