"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerService = void 0;
const common_1 = require("@nestjs/common");
const user_dto_1 = require("../dtos/user.dto");
const enum_1 = require("../enum");
const partner_repository_1 = require("../repositories/partner.repository");
const base_service_1 = require("./base.service");
let PartnerService = class PartnerService extends base_service_1.BaseService {
    async create(auth, { sharedWithId }) {
        const partnerId = { sharedById: auth.user.id, sharedWithId };
        const exists = await this.partnerRepository.get(partnerId);
        if (exists) {
            throw new common_1.BadRequestException(`Partner already exists`);
        }
        const partner = await this.partnerRepository.create(partnerId);
        return this.mapPartner(partner, partner_repository_1.PartnerDirection.SharedBy);
    }
    async remove(auth, sharedWithId) {
        const partnerId = { sharedById: auth.user.id, sharedWithId };
        const partner = await this.partnerRepository.get(partnerId);
        if (!partner) {
            throw new common_1.BadRequestException('Partner not found');
        }
        await this.partnerRepository.remove(partnerId);
    }
    async search(auth, { direction }) {
        const partners = await this.partnerRepository.getAll(auth.user.id);
        const key = direction === partner_repository_1.PartnerDirection.SharedBy ? 'sharedById' : 'sharedWithId';
        return partners
            .filter((partner) => !!(partner.sharedBy && partner.sharedWith))
            .filter((partner) => partner[key] === auth.user.id)
            .map((partner) => this.mapPartner(partner, direction));
    }
    async update(auth, sharedById, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.PartnerUpdate, ids: [sharedById] });
        const partnerId = { sharedById, sharedWithId: auth.user.id };
        const entity = await this.partnerRepository.update(partnerId, { inTimeline: dto.inTimeline });
        return this.mapPartner(entity, partner_repository_1.PartnerDirection.SharedWith);
    }
    mapPartner(partner, direction) {
        const user = (0, user_dto_1.mapUser)(direction === partner_repository_1.PartnerDirection.SharedBy ? partner.sharedWith : partner.sharedBy);
        return { ...user, inTimeline: partner.inTimeline };
    }
};
exports.PartnerService = PartnerService;
exports.PartnerService = PartnerService = __decorate([
    (0, common_1.Injectable)()
], PartnerService);
//# sourceMappingURL=partner.service.js.map