import { Insertable } from 'kysely';
import { SystemConfig } from 'src/config';
import { StorageCore } from 'src/cores/storage.core';
import { UserAdmin } from 'src/database';
import { AccessRepository } from 'src/repositories/access.repository';
import { ActivityRepository } from 'src/repositories/activity.repository';
import { AlbumUserRepository } from 'src/repositories/album-user.repository';
import { AlbumRepository } from 'src/repositories/album.repository';
import { ApiKeyRepository } from 'src/repositories/api-key.repository';
import { AppRepository } from 'src/repositories/app.repository';
import { AssetJobRepository } from 'src/repositories/asset-job.repository';
import { AssetRepository } from 'src/repositories/asset.repository';
import { AuditRepository } from 'src/repositories/audit.repository';
import { ConfigRepository } from 'src/repositories/config.repository';
import { CronRepository } from 'src/repositories/cron.repository';
import { CryptoRepository } from 'src/repositories/crypto.repository';
import { DatabaseRepository } from 'src/repositories/database.repository';
import { DownloadRepository } from 'src/repositories/download.repository';
import { DuplicateRepository } from 'src/repositories/duplicate.repository';
import { EmailRepository } from 'src/repositories/email.repository';
import { EventRepository } from 'src/repositories/event.repository';
import { JobRepository } from 'src/repositories/job.repository';
import { LibraryRepository } from 'src/repositories/library.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { MachineLearningRepository } from 'src/repositories/machine-learning.repository';
import { MapRepository } from 'src/repositories/map.repository';
import { MediaRepository } from 'src/repositories/media.repository';
import { MemoryRepository } from 'src/repositories/memory.repository';
import { MetadataRepository } from 'src/repositories/metadata.repository';
import { MoveRepository } from 'src/repositories/move.repository';
import { NotificationRepository } from 'src/repositories/notification.repository';
import { OAuthRepository } from 'src/repositories/oauth.repository';
import { OcrRepository } from 'src/repositories/ocr.repository';
import { PartnerRepository } from 'src/repositories/partner.repository';
import { PersonRepository } from 'src/repositories/person.repository';
import { PluginRepository } from 'src/repositories/plugin.repository';
import { ProcessRepository } from 'src/repositories/process.repository';
import { SearchRepository } from 'src/repositories/search.repository';
import { ServerInfoRepository } from 'src/repositories/server-info.repository';
import { SessionRepository } from 'src/repositories/session.repository';
import { SharedLinkAssetRepository } from 'src/repositories/shared-link-asset.repository';
import { SharedLinkRepository } from 'src/repositories/shared-link.repository';
import { StackRepository } from 'src/repositories/stack.repository';
import { StorageRepository } from 'src/repositories/storage.repository';
import { SyncCheckpointRepository } from 'src/repositories/sync-checkpoint.repository';
import { SyncRepository } from 'src/repositories/sync.repository';
import { SystemMetadataRepository } from 'src/repositories/system-metadata.repository';
import { TagRepository } from 'src/repositories/tag.repository';
import { TelemetryRepository } from 'src/repositories/telemetry.repository';
import { TrashRepository } from 'src/repositories/trash.repository';
import { UserRepository } from 'src/repositories/user.repository';
import { VersionHistoryRepository } from 'src/repositories/version-history.repository';
import { ViewRepository } from 'src/repositories/view-repository';
import { WebsocketRepository } from 'src/repositories/websocket.repository';
import { WorkflowRepository } from 'src/repositories/workflow.repository';
import { UserTable } from 'src/schema/tables/user.table';
import { AccessRequest } from 'src/utils/access';
export declare const BASE_SERVICE_DEPENDENCIES: (typeof AppRepository | typeof ConfigRepository | typeof LoggingRepository | typeof DatabaseRepository | typeof SearchRepository | typeof AssetRepository | typeof EventRepository | typeof SystemMetadataRepository | typeof CryptoRepository | typeof MoveRepository | typeof PersonRepository | typeof StorageRepository | typeof AccessRepository | typeof PartnerRepository | typeof OAuthRepository | typeof ActivityRepository | typeof AlbumUserRepository | typeof AlbumRepository | typeof ApiKeyRepository | typeof AssetJobRepository | typeof AuditRepository | typeof CronRepository | typeof DownloadRepository | typeof DuplicateRepository | typeof EmailRepository | typeof JobRepository | typeof LibraryRepository | typeof MachineLearningRepository | typeof MapRepository | typeof MediaRepository | typeof MemoryRepository | typeof MetadataRepository | typeof NotificationRepository | typeof OcrRepository | typeof PluginRepository | typeof ProcessRepository | typeof ServerInfoRepository | typeof SessionRepository | typeof SharedLinkAssetRepository | typeof SharedLinkRepository | typeof StackRepository | typeof SyncCheckpointRepository | typeof SyncRepository | typeof TagRepository | typeof TelemetryRepository | typeof TrashRepository | typeof UserRepository | typeof VersionHistoryRepository | typeof ViewRepository | typeof WebsocketRepository | typeof WorkflowRepository)[];
export declare class BaseService {
    protected logger: LoggingRepository;
    protected accessRepository: AccessRepository;
    protected activityRepository: ActivityRepository;
    protected albumRepository: AlbumRepository;
    protected albumUserRepository: AlbumUserRepository;
    protected apiKeyRepository: ApiKeyRepository;
    protected appRepository: AppRepository;
    protected assetRepository: AssetRepository;
    protected assetJobRepository: AssetJobRepository;
    protected auditRepository: AuditRepository;
    protected configRepository: ConfigRepository;
    protected cronRepository: CronRepository;
    protected cryptoRepository: CryptoRepository;
    protected databaseRepository: DatabaseRepository;
    protected downloadRepository: DownloadRepository;
    protected duplicateRepository: DuplicateRepository;
    protected emailRepository: EmailRepository;
    protected eventRepository: EventRepository;
    protected jobRepository: JobRepository;
    protected libraryRepository: LibraryRepository;
    protected machineLearningRepository: MachineLearningRepository;
    protected mapRepository: MapRepository;
    protected mediaRepository: MediaRepository;
    protected memoryRepository: MemoryRepository;
    protected metadataRepository: MetadataRepository;
    protected moveRepository: MoveRepository;
    protected notificationRepository: NotificationRepository;
    protected oauthRepository: OAuthRepository;
    protected ocrRepository: OcrRepository;
    protected partnerRepository: PartnerRepository;
    protected personRepository: PersonRepository;
    protected pluginRepository: PluginRepository;
    protected processRepository: ProcessRepository;
    protected searchRepository: SearchRepository;
    protected serverInfoRepository: ServerInfoRepository;
    protected sessionRepository: SessionRepository;
    protected sharedLinkRepository: SharedLinkRepository;
    protected sharedLinkAssetRepository: SharedLinkAssetRepository;
    protected stackRepository: StackRepository;
    protected storageRepository: StorageRepository;
    protected syncRepository: SyncRepository;
    protected syncCheckpointRepository: SyncCheckpointRepository;
    protected systemMetadataRepository: SystemMetadataRepository;
    protected tagRepository: TagRepository;
    protected telemetryRepository: TelemetryRepository;
    protected trashRepository: TrashRepository;
    protected userRepository: UserRepository;
    protected versionRepository: VersionHistoryRepository;
    protected viewRepository: ViewRepository;
    protected websocketRepository: WebsocketRepository;
    protected workflowRepository: WorkflowRepository;
    protected storageCore: StorageCore;
    constructor(logger: LoggingRepository, accessRepository: AccessRepository, activityRepository: ActivityRepository, albumRepository: AlbumRepository, albumUserRepository: AlbumUserRepository, apiKeyRepository: ApiKeyRepository, appRepository: AppRepository, assetRepository: AssetRepository, assetJobRepository: AssetJobRepository, auditRepository: AuditRepository, configRepository: ConfigRepository, cronRepository: CronRepository, cryptoRepository: CryptoRepository, databaseRepository: DatabaseRepository, downloadRepository: DownloadRepository, duplicateRepository: DuplicateRepository, emailRepository: EmailRepository, eventRepository: EventRepository, jobRepository: JobRepository, libraryRepository: LibraryRepository, machineLearningRepository: MachineLearningRepository, mapRepository: MapRepository, mediaRepository: MediaRepository, memoryRepository: MemoryRepository, metadataRepository: MetadataRepository, moveRepository: MoveRepository, notificationRepository: NotificationRepository, oauthRepository: OAuthRepository, ocrRepository: OcrRepository, partnerRepository: PartnerRepository, personRepository: PersonRepository, pluginRepository: PluginRepository, processRepository: ProcessRepository, searchRepository: SearchRepository, serverInfoRepository: ServerInfoRepository, sessionRepository: SessionRepository, sharedLinkRepository: SharedLinkRepository, sharedLinkAssetRepository: SharedLinkAssetRepository, stackRepository: StackRepository, storageRepository: StorageRepository, syncRepository: SyncRepository, syncCheckpointRepository: SyncCheckpointRepository, systemMetadataRepository: SystemMetadataRepository, tagRepository: TagRepository, telemetryRepository: TelemetryRepository, trashRepository: TrashRepository, userRepository: UserRepository, versionRepository: VersionHistoryRepository, viewRepository: ViewRepository, websocketRepository: WebsocketRepository, workflowRepository: WorkflowRepository);
    get worker(): import("../enum").ImmichWorker | undefined;
    private get configRepos();
    getConfig(options: {
        withCache: boolean;
    }): Promise<SystemConfig>;
    updateConfig(newConfig: SystemConfig): Promise<SystemConfig>;
    requireAccess(request: AccessRequest): Promise<void>;
    checkAccess(request: AccessRequest): Promise<Set<string>>;
    createUser(dto: Insertable<UserTable> & {
        email: string;
    }): Promise<UserAdmin>;
}
