"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetTable = void 0;
const decorators_1 = require("../../decorators");
const enum_1 = require("../../enum");
const enums_1 = require("../enums");
const functions_1 = require("../functions");
const library_table_1 = require("./library.table");
const stack_table_1 = require("./stack.table");
const user_table_1 = require("./user.table");
const sql_tools_1 = require("../../sql-tools");
const database_1 = require("../../utils/database");
let AssetTable = class AssetTable {
    id;
    deviceAssetId;
    ownerId;
    deviceId;
    type;
    originalPath;
    fileCreatedAt;
    fileModifiedAt;
    isFavorite;
    duration;
    encodedVideoPath;
    checksum;
    livePhotoVideoId;
    updatedAt;
    createdAt;
    originalFileName;
    thumbhash;
    isOffline;
    libraryId;
    isExternal;
    deletedAt;
    localDateTime;
    stackId;
    duplicateId;
    status;
    updateId;
    visibility;
};
exports.AssetTable = AssetTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Object)
], AssetTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.Column)(),
    __metadata("design:type", String)
], AssetTable.prototype, "deviceAssetId", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => user_table_1.UserTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE', nullable: false }),
    __metadata("design:type", String)
], AssetTable.prototype, "ownerId", void 0);
__decorate([
    (0, sql_tools_1.Column)(),
    __metadata("design:type", String)
], AssetTable.prototype, "deviceId", void 0);
__decorate([
    (0, sql_tools_1.Column)(),
    __metadata("design:type", String)
], AssetTable.prototype, "type", void 0);
__decorate([
    (0, sql_tools_1.Column)(),
    __metadata("design:type", String)
], AssetTable.prototype, "originalPath", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone', index: true }),
    __metadata("design:type", Object)
], AssetTable.prototype, "fileCreatedAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone' }),
    __metadata("design:type", Object)
], AssetTable.prototype, "fileModifiedAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Object)
], AssetTable.prototype, "isFavorite", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'character varying', nullable: true }),
    __metadata("design:type", Object)
], AssetTable.prototype, "duration", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'character varying', nullable: true, default: '' }),
    __metadata("design:type", Object)
], AssetTable.prototype, "encodedVideoPath", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'bytea', index: true }),
    __metadata("design:type", Buffer)
], AssetTable.prototype, "checksum", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => AssetTable, { nullable: true, onUpdate: 'CASCADE', onDelete: 'SET NULL' }),
    __metadata("design:type", Object)
], AssetTable.prototype, "livePhotoVideoId", void 0);
__decorate([
    (0, sql_tools_1.UpdateDateColumn)(),
    __metadata("design:type", Object)
], AssetTable.prototype, "updatedAt", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Object)
], AssetTable.prototype, "createdAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ index: true }),
    __metadata("design:type", String)
], AssetTable.prototype, "originalFileName", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'bytea', nullable: true }),
    __metadata("design:type", Object)
], AssetTable.prototype, "thumbhash", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Object)
], AssetTable.prototype, "isOffline", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => library_table_1.LibraryTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE', nullable: true }),
    __metadata("design:type", Object)
], AssetTable.prototype, "libraryId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Object)
], AssetTable.prototype, "isExternal", void 0);
__decorate([
    (0, sql_tools_1.DeleteDateColumn)(),
    __metadata("design:type", Object)
], AssetTable.prototype, "deletedAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone' }),
    __metadata("design:type", Object)
], AssetTable.prototype, "localDateTime", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => stack_table_1.StackTable, { nullable: true, onDelete: 'SET NULL', onUpdate: 'CASCADE' }),
    __metadata("design:type", Object)
], AssetTable.prototype, "stackId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'uuid', nullable: true, index: true }),
    __metadata("design:type", Object)
], AssetTable.prototype, "duplicateId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ enum: enums_1.assets_status_enum, default: enum_1.AssetStatus.Active }),
    __metadata("design:type", Object)
], AssetTable.prototype, "status", void 0);
__decorate([
    (0, decorators_1.UpdateIdColumn)({ index: true }),
    __metadata("design:type", Object)
], AssetTable.prototype, "updateId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ enum: enums_1.asset_visibility_enum, default: enum_1.AssetVisibility.Timeline }),
    __metadata("design:type", Object)
], AssetTable.prototype, "visibility", void 0);
exports.AssetTable = AssetTable = __decorate([
    (0, sql_tools_1.Table)('asset'),
    (0, decorators_1.UpdatedAtTrigger)('asset_updatedAt'),
    (0, sql_tools_1.AfterDeleteTrigger)({
        scope: 'statement',
        function: functions_1.asset_delete_audit,
        referencingOldTableAs: 'old',
        when: 'pg_trigger_depth() = 0',
    }),
    (0, sql_tools_1.Index)({
        name: database_1.ASSET_CHECKSUM_CONSTRAINT,
        columns: ['ownerId', 'checksum'],
        unique: true,
        where: '("libraryId" IS NULL)',
    }),
    (0, sql_tools_1.Index)({
        columns: ['ownerId', 'libraryId', 'checksum'],
        unique: true,
        where: '("libraryId" IS NOT NULL)',
    }),
    (0, sql_tools_1.Index)({
        name: 'asset_localDateTime_idx',
        expression: `(("localDateTime" at time zone 'UTC')::date)`,
    }),
    (0, sql_tools_1.Index)({
        name: 'asset_localDateTime_month_idx',
        expression: `(date_trunc('MONTH'::text, ("localDateTime" AT TIME ZONE 'UTC'::text)) AT TIME ZONE 'UTC'::text)`,
    }),
    (0, sql_tools_1.Index)({ columns: ['originalPath', 'libraryId'] }),
    (0, sql_tools_1.Index)({ columns: ['id', 'stackId'] }),
    (0, sql_tools_1.Index)({
        name: 'asset_originalFilename_trigram_idx',
        using: 'gin',
        expression: 'f_unaccent("originalFileName") gin_trgm_ops',
    })
], AssetTable);
//# sourceMappingURL=asset.table.js.map