"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `ALTER TABLE "shared_link" ADD "slug" character varying;`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "shared_link" ADD CONSTRAINT "shared_link_slug_uq" UNIQUE ("slug");`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `ALTER TABLE "shared_link" DROP CONSTRAINT "shared_link_slug_uq";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "shared_link" DROP COLUMN "slug";`.execute(db);
}
//# sourceMappingURL=1753471866748-AddSharedLinkSlug.js.map