import { Insertable, Kysely, Updateable } from 'kysely';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { DB } from 'src/schema';
import { TagAssetTable } from 'src/schema/tables/tag-asset.table';
import { TagTable } from 'src/schema/tables/tag.table';
export declare class TagRepository {
    private db;
    private logger;
    constructor(db: Kysely<DB>, logger: LoggingRepository);
    get(id: string): Promise<{
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    } | undefined>;
    getByValue(userId: string, value: string): Promise<{
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    } | undefined>;
    upsertValue({ userId, value, parentId: _parentId }: {
        userId: string;
        value: string;
        parentId?: string;
    }): Promise<{
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    }>;
    getAll(userId: string): Promise<{
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    }[]>;
    create(tag: Insertable<TagTable>): Promise<{
        id: string;
        value: string;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        userId: string;
        color: string | null;
        parentId: string | null;
    }>;
    update(id: string, dto: Updateable<TagTable>): Promise<{
        id: string;
        value: string;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        userId: string;
        color: string | null;
        parentId: string | null;
    }>;
    delete(id: string): Promise<void>;
    getAssetIds(tagId: string, assetIds: string[]): Promise<Set<string>>;
    addAssetIds(tagId: string, assetIds: string[]): Promise<void>;
    removeAssetIds(tagId: string, assetIds: string[]): Promise<void>;
    upsertAssetIds(items: Insertable<TagAssetTable>[]): Promise<{
        assetId: string;
        tagId: string;
    }[]>;
    replaceAssetTags(assetId: string, tagIds: string[]): Promise<{
        assetId: string;
        tagId: string;
    }[] | undefined>;
    deleteEmptyTags(): Promise<void>;
}
