import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
export interface GitHubRelease {
    id: number;
    url: string;
    tag_name: string;
    name: string;
    created_at: string;
    published_at: string;
    body: string;
}
export interface ServerBuildVersions {
    nodejs: string;
    ffmpeg: string;
    libvips: string;
    exiftool: string;
    imagemagick: string;
}
export declare class ServerInfoRepository {
    private configRepository;
    private logger;
    constructor(configRepository: ConfigRepository, logger: LoggingRepository);
    getGitHubRelease(): Promise<GitHubRelease>;
    buildVersions?: ServerBuildVersions;
    private retrieveVersionFallback;
    getBuildVersions(): Promise<ServerBuildVersions>;
}
