import { OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit } from '@nestjs/websockets';
import { Server, Socket } from 'socket.io';
import { AppRepository } from 'src/repositories/app.repository';
import { AppRestartEvent, ArgsOf } from 'src/repositories/event.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
export declare const serverEvents: readonly ["AppRestart"];
export type ServerEvents = (typeof serverEvents)[number];
export interface ClientEventMap {
    AppRestartV1: [AppRestartEvent];
}
export declare class MaintenanceWebsocketRepository implements OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit {
    private logger;
    private appRepository;
    private websocketServer?;
    constructor(logger: LoggingRepository, appRepository: AppRepository);
    afterInit(websocketServer: Server): void;
    clientBroadcast<T extends keyof ClientEventMap>(event: T, ...data: ClientEventMap[T]): void;
    serverSend<T extends ServerEvents>(event: T, ...args: ArgsOf<T>): void;
    handleConnection(client: Socket): void;
    handleDisconnect(client: Socket): void;
}
