import { WorkflowAction, WorkflowFilter } from 'src/database';
import { PluginTriggerType } from 'src/enum';
import type { ActionConfig, FilterConfig } from 'src/types/plugin-schema.types';
export declare class WorkflowFilterItemDto {
    pluginFilterId: string;
    filterConfig?: FilterConfig;
}
export declare class WorkflowActionItemDto {
    pluginActionId: string;
    actionConfig?: ActionConfig;
}
export declare class WorkflowCreateDto {
    triggerType: PluginTriggerType;
    name: string;
    description?: string;
    enabled?: boolean;
    filters: WorkflowFilterItemDto[];
    actions: WorkflowActionItemDto[];
}
export declare class WorkflowUpdateDto {
    name?: string;
    description?: string;
    enabled?: boolean;
    filters?: WorkflowFilterItemDto[];
    actions?: WorkflowActionItemDto[];
}
export declare class WorkflowResponseDto {
    id: string;
    ownerId: string;
    triggerType: PluginTriggerType;
    name: string | null;
    description: string;
    createdAt: string;
    enabled: boolean;
    filters: WorkflowFilterResponseDto[];
    actions: WorkflowActionResponseDto[];
}
export declare class WorkflowFilterResponseDto {
    id: string;
    workflowId: string;
    pluginFilterId: string;
    filterConfig: FilterConfig | null;
    order: number;
}
export declare class WorkflowActionResponseDto {
    id: string;
    workflowId: string;
    pluginActionId: string;
    actionConfig: ActionConfig | null;
    order: number;
}
export declare function mapWorkflowFilter(filter: WorkflowFilter): WorkflowFilterResponseDto;
export declare function mapWorkflowAction(action: WorkflowAction): WorkflowActionResponseDto;
