"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapActivity = exports.ActivityCreateDto = exports.ActivitySearchDto = exports.ActivityDto = exports.ActivityStatisticsResponseDto = exports.ActivityResponseDto = exports.ReactionLevel = exports.ReactionType = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const user_dto_1 = require("./user.dto");
const validation_1 = require("../validation");
var ReactionType;
(function (ReactionType) {
    ReactionType["COMMENT"] = "comment";
    ReactionType["LIKE"] = "like";
})(ReactionType || (exports.ReactionType = ReactionType = {}));
var ReactionLevel;
(function (ReactionLevel) {
    ReactionLevel["ALBUM"] = "album";
    ReactionLevel["ASSET"] = "asset";
})(ReactionLevel || (exports.ReactionLevel = ReactionLevel = {}));
class ActivityResponseDto {
    id;
    createdAt;
    type;
    user;
    assetId;
    comment;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, type: { required: true, enum: require("./activity.dto").ReactionType }, user: { required: true, type: () => require("./user.dto").UserResponseDto }, assetId: { required: true, type: () => String, nullable: true }, comment: { required: false, type: () => String, nullable: true } };
    }
}
exports.ActivityResponseDto = ActivityResponseDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: ReactionType, name: 'ReactionType' }),
    __metadata("design:type", String)
], ActivityResponseDto.prototype, "type", void 0);
class ActivityStatisticsResponseDto {
    comments;
    likes;
    static _OPENAPI_METADATA_FACTORY() {
        return { comments: { required: true, type: () => Number }, likes: { required: true, type: () => Number } };
    }
}
exports.ActivityStatisticsResponseDto = ActivityStatisticsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], ActivityStatisticsResponseDto.prototype, "comments", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], ActivityStatisticsResponseDto.prototype, "likes", void 0);
class ActivityDto {
    albumId;
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumId: { required: true, type: () => String }, assetId: { required: false, type: () => String } };
    }
}
exports.ActivityDto = ActivityDto;
__decorate([
    (0, validation_1.ValidateUUID)(),
    __metadata("design:type", String)
], ActivityDto.prototype, "albumId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], ActivityDto.prototype, "assetId", void 0);
class ActivitySearchDto extends ActivityDto {
    type;
    level;
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: false, enum: require("./activity.dto").ReactionType }, level: { required: false, enum: require("./activity.dto").ReactionLevel }, userId: { required: false, type: () => String } };
    }
}
exports.ActivitySearchDto = ActivitySearchDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: ReactionType, name: 'ReactionType', optional: true }),
    __metadata("design:type", String)
], ActivitySearchDto.prototype, "type", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: ReactionLevel, name: 'ReactionLevel', optional: true }),
    __metadata("design:type", String)
], ActivitySearchDto.prototype, "level", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], ActivitySearchDto.prototype, "userId", void 0);
const isComment = (dto) => dto.type === ReactionType.COMMENT;
class ActivityCreateDto extends ActivityDto {
    type;
    comment;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: true, enum: require("./activity.dto").ReactionType }, comment: { required: false, type: () => String } };
    }
}
exports.ActivityCreateDto = ActivityCreateDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: ReactionType, name: 'ReactionType' }),
    __metadata("design:type", String)
], ActivityCreateDto.prototype, "type", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)(isComment),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ActivityCreateDto.prototype, "comment", void 0);
const mapActivity = (activity) => {
    return {
        id: activity.id,
        assetId: activity.assetId,
        createdAt: activity.createdAt,
        comment: activity.comment,
        type: activity.isLiked ? ReactionType.LIKE : ReactionType.COMMENT,
        user: (0, user_dto_1.mapUser)(activity.user),
    };
};
exports.mapActivity = mapActivity;
//# sourceMappingURL=activity.dto.js.map