"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedLinkController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const asset_dto_1 = require("../dtos/asset.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const shared_link_dto_1 = require("../dtos/shared-link.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const shared_link_service_1 = require("../services/shared-link.service");
const response_1 = require("../utils/response");
const validation_1 = require("../validation");
let SharedLinkController = class SharedLinkController {
    service;
    constructor(service) {
        this.service = service;
    }
    getAllSharedLinks(auth, dto) {
        return this.service.getAll(auth, dto);
    }
    async getMySharedLink(auth, dto, request, res, loginDetails) {
        const sharedLinkToken = request.cookies?.[enum_1.ImmichCookie.SharedLinkToken];
        if (sharedLinkToken) {
            dto.token = sharedLinkToken;
        }
        const body = await this.service.getMine(auth, dto);
        return (0, response_1.respondWithCookie)(res, body, {
            isSecure: loginDetails.isSecure,
            values: body.token ? [{ key: enum_1.ImmichCookie.SharedLinkToken, value: body.token }] : [],
        });
    }
    getSharedLinkById(auth, { id }) {
        return this.service.get(auth, id);
    }
    createSharedLink(auth, dto) {
        return this.service.create(auth, dto);
    }
    updateSharedLink(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    removeSharedLink(auth, { id }) {
        return this.service.remove(auth, id);
    }
    addSharedLinkAssets(auth, { id }, dto) {
        return this.service.addAssets(auth, id, dto);
    }
    removeSharedLinkAssets(auth, { id }, dto) {
        return this.service.removeAssets(auth, id, dto);
    }
};
exports.SharedLinkController = SharedLinkController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SharedLinkRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve all shared links',
        description: 'Retrieve a list of all shared links.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/shared-link.dto").SharedLinkResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, shared_link_dto_1.SharedLinkSearchDto]),
    __metadata("design:returntype", Promise)
], SharedLinkController.prototype, "getAllSharedLinks", null);
__decorate([
    (0, common_1.Get)('me'),
    (0, auth_guard_1.Authenticated)({ sharedLink: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve current shared link',
        description: 'Retrieve the current shared link associated with authentication method.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/shared-link.dto").SharedLinkResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __param(2, (0, common_1.Req)()),
    __param(3, (0, common_1.Res)({ passthrough: true })),
    __param(4, (0, auth_guard_1.GetLoginDetails)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        shared_link_dto_1.SharedLinkPasswordDto, Object, Object, Object]),
    __metadata("design:returntype", Promise)
], SharedLinkController.prototype, "getMySharedLink", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SharedLinkRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve a shared link',
        description: 'Retrieve a specific shared link by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/shared-link.dto").SharedLinkResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], SharedLinkController.prototype, "getSharedLinkById", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SharedLinkCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Create a shared link',
        description: 'Create a new shared link.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/shared-link.dto").SharedLinkResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, shared_link_dto_1.SharedLinkCreateDto]),
    __metadata("design:returntype", void 0)
], SharedLinkController.prototype, "createSharedLink", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SharedLinkUpdate }),
    (0, decorators_1.Endpoint)({
        summary: 'Update a shared link',
        description: 'Update an existing shared link by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/shared-link.dto").SharedLinkResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        shared_link_dto_1.SharedLinkEditDto]),
    __metadata("design:returntype", Promise)
], SharedLinkController.prototype, "updateSharedLink", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SharedLinkDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Delete a shared link',
        description: 'Delete a specific shared link by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], SharedLinkController.prototype, "removeSharedLink", null);
__decorate([
    (0, common_1.Put)(':id/assets'),
    (0, auth_guard_1.Authenticated)({ sharedLink: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Add assets to a shared link',
        description: 'Add assets to a specific shared link by its ID. This endpoint is only relevant for shared link of type individual.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-ids.response.dto").AssetIdsResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        asset_dto_1.AssetIdsDto]),
    __metadata("design:returntype", Promise)
], SharedLinkController.prototype, "addSharedLinkAssets", null);
__decorate([
    (0, common_1.Delete)(':id/assets'),
    (0, auth_guard_1.Authenticated)({ sharedLink: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Remove assets from a shared link',
        description: 'Remove assets from a specific shared link by its ID. This endpoint is only relevant for shared link of type individual.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-ids.response.dto").AssetIdsResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        asset_dto_1.AssetIdsDto]),
    __metadata("design:returntype", Promise)
], SharedLinkController.prototype, "removeSharedLinkAssets", null);
exports.SharedLinkController = SharedLinkController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.SharedLinks),
    (0, common_1.Controller)('shared-links'),
    __metadata("design:paramtypes", [shared_link_service_1.SharedLinkService])
], SharedLinkController);
//# sourceMappingURL=shared-link.controller.js.map