import { AuthDto } from 'src/dtos/auth.dto';
import { SessionCreateDto, SessionCreateResponseDto, SessionResponseDto, SessionUpdateDto } from 'src/dtos/session.dto';
import { SessionService } from 'src/services/session.service';
import { UUIDParamDto } from 'src/validation';
export declare class SessionController {
    private service;
    constructor(service: SessionService);
    createSession(auth: AuthDto, dto: SessionCreateDto): Promise<SessionCreateResponseDto>;
    getSessions(auth: AuthDto): Promise<SessionResponseDto[]>;
    deleteAllSessions(auth: AuthDto): Promise<void>;
    updateSession(auth: AuthDto, { id }: UUIDParamDto, dto: SessionUpdateDto): Promise<SessionResponseDto>;
    deleteSession(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
    lockSession(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
