"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const license_dto_1 = require("../dtos/license.dto");
const server_dto_1 = require("../dtos/server.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const server_service_1 = require("../services/server.service");
const system_metadata_service_1 = require("../services/system-metadata.service");
const version_service_1 = require("../services/version.service");
let ServerController = class ServerController {
    service;
    systemMetadataService;
    versionService;
    constructor(service, systemMetadataService, versionService) {
        this.service = service;
        this.systemMetadataService = systemMetadataService;
        this.versionService = versionService;
    }
    getAboutInfo() {
        return this.service.getAboutInfo();
    }
    getApkLinks() {
        return this.service.getApkLinks();
    }
    getStorage() {
        return this.service.getStorage();
    }
    pingServer() {
        return this.service.ping();
    }
    getServerVersion() {
        return this.versionService.getVersion();
    }
    getVersionHistory() {
        return this.versionService.getVersionHistory();
    }
    getServerFeatures() {
        return this.service.getFeatures();
    }
    getTheme() {
        return this.service.getTheme();
    }
    getServerConfig() {
        return this.service.getSystemConfig();
    }
    getServerStatistics() {
        return this.service.getStatistics();
    }
    getSupportedMediaTypes() {
        return this.service.getSupportedMediaTypes();
    }
    getServerLicense() {
        return this.service.getLicense();
    }
    setServerLicense(license) {
        return this.service.setLicense(license);
    }
    deleteServerLicense() {
        return this.service.deleteLicense();
    }
    getVersionCheck() {
        return this.systemMetadataService.getVersionCheckState();
    }
};
exports.ServerController = ServerController;
__decorate([
    (0, common_1.Get)('about'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ServerAbout }),
    (0, decorators_1.Endpoint)({
        summary: 'Get server information',
        description: 'Retrieve a list of information about the server.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerAboutResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getAboutInfo", null);
__decorate([
    (0, common_1.Get)('apk-links'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ServerApkLinks }),
    (0, decorators_1.Endpoint)({
        summary: 'Get APK links',
        description: 'Retrieve links to the APKs for the current server version.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerApkLinksDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerApkLinksDto)
], ServerController.prototype, "getApkLinks", null);
__decorate([
    (0, common_1.Get)('storage'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ServerStorage }),
    (0, decorators_1.Endpoint)({
        summary: 'Get storage',
        description: 'Retrieve the current storage utilization information of the server.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerStorageResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getStorage", null);
__decorate([
    (0, common_1.Get)('ping'),
    (0, decorators_1.Endpoint)({
        summary: 'Ping',
        description: 'Pong',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerPingResponse }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerPingResponse)
], ServerController.prototype, "pingServer", null);
__decorate([
    (0, common_1.Get)('version'),
    (0, decorators_1.Endpoint)({
        summary: 'Get server version',
        description: 'Retrieve the current server version in semantic versioning (semver) format.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerVersionResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerVersionResponseDto)
], ServerController.prototype, "getServerVersion", null);
__decorate([
    (0, common_1.Get)('version-history'),
    (0, decorators_1.Endpoint)({
        summary: 'Get version history',
        description: 'Retrieve a list of past versions the server has been on.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/server.dto").ServerVersionHistoryResponseDto] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getVersionHistory", null);
__decorate([
    (0, common_1.Get)('features'),
    (0, decorators_1.Endpoint)({
        summary: 'Get features',
        description: 'Retrieve available features supported by this server.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerFeaturesDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getServerFeatures", null);
__decorate([
    (0, common_1.Get)('theme'),
    (0, decorators_1.Endpoint)({
        summary: 'Get theme',
        description: 'Retrieve the custom CSS, if existent.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerThemeDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getTheme", null);
__decorate([
    (0, common_1.Get)('config'),
    (0, decorators_1.Endpoint)({
        summary: 'Get config',
        description: 'Retrieve the current server configuration.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerConfigDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getServerConfig", null);
__decorate([
    (0, common_1.Get)('statistics'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ServerStatistics, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Get statistics',
        description: 'Retrieve statistics about the entire Immich instance such as asset counts.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerStatsResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getServerStatistics", null);
__decorate([
    (0, common_1.Get)('media-types'),
    (0, decorators_1.Endpoint)({
        summary: 'Get supported media types',
        description: 'Retrieve all media types supported by the server.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerMediaTypesResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", server_dto_1.ServerMediaTypesResponseDto)
], ServerController.prototype, "getSupportedMediaTypes", null);
__decorate([
    (0, common_1.Get)('license'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ServerLicenseRead, admin: true }),
    (0, swagger_1.ApiNotFoundResponse)(),
    (0, decorators_1.Endpoint)({
        summary: 'Get product key',
        description: 'Retrieve information about whether the server currently has a product key registered.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/license.dto").LicenseResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getServerLicense", null);
__decorate([
    (0, common_1.Put)('license'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ServerLicenseUpdate, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Set server product key',
        description: 'Validate and set the server product key if successful.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/license.dto").LicenseResponseDto }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [license_dto_1.LicenseKeyDto]),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "setServerLicense", null);
__decorate([
    (0, common_1.Delete)('license'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ServerLicenseDelete, admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Delete server product key',
        description: 'Delete the currently set server product key.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "deleteServerLicense", null);
__decorate([
    (0, common_1.Get)('version-check'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ServerVersionCheck }),
    (0, decorators_1.Endpoint)({
        summary: 'Get version check status',
        description: 'Retrieve information about the last time the version check ran.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/system-metadata.dto").VersionCheckStateResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServerController.prototype, "getVersionCheck", null);
exports.ServerController = ServerController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Server),
    (0, common_1.Controller)('server'),
    __metadata("design:paramtypes", [server_service_1.ServerService,
        system_metadata_service_1.SystemMetadataService,
        version_service_1.VersionService])
], ServerController);
//# sourceMappingURL=server.controller.js.map