import { HttpStatus } from '@nestjs/common';
import { Request, Response } from 'express';
import { AuthDto, LoginResponseDto, OAuthAuthorizeResponseDto, OAuthCallbackDto, OAuthConfigDto } from 'src/dtos/auth.dto';
import { UserAdminResponseDto } from 'src/dtos/user.dto';
import { AuthService, LoginDetails } from 'src/services/auth.service';
export declare class OAuthController {
    private service;
    constructor(service: AuthService);
    redirectOAuthToMobile(request: Request): {
        url: string;
        statusCode: HttpStatus;
    };
    startOAuth(dto: OAuthConfigDto, res: Response, loginDetails: LoginDetails): Promise<OAuthAuthorizeResponseDto>;
    finishOAuth(request: Request, res: Response, dto: OAuthCallbackDto, loginDetails: LoginDetails): Promise<LoginResponseDto>;
    linkOAuthAccount(request: Request, auth: AuthDto, dto: OAuthCallbackDto): Promise<UserAdminResponseDto>;
    unlinkOAuthAccount(auth: AuthDto): Promise<UserAdminResponseDto>;
}
