"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const asset_ids_response_dto_1 = require("../dtos/asset-ids.response.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const memory_dto_1 = require("../dtos/memory.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const memory_service_1 = require("../services/memory.service");
const validation_1 = require("../validation");
let MemoryController = class MemoryController {
    service;
    constructor(service) {
        this.service = service;
    }
    searchMemories(auth, dto) {
        return this.service.search(auth, dto);
    }
    createMemory(auth, dto) {
        return this.service.create(auth, dto);
    }
    memoriesStatistics(auth, dto) {
        return this.service.statistics(auth, dto);
    }
    getMemory(auth, { id }) {
        return this.service.get(auth, id);
    }
    updateMemory(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    deleteMemory(auth, { id }) {
        return this.service.remove(auth, id);
    }
    addMemoryAssets(auth, { id }, dto) {
        return this.service.addAssets(auth, id, dto);
    }
    removeMemoryAssets(auth, dto, { id }) {
        return this.service.removeAssets(auth, id, dto);
    }
};
exports.MemoryController = MemoryController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.MemoryRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve memories',
        description: 'Retrieve a list of memories. Memories are sorted descending by creation date by default, although they can also be sorted in ascending order, or randomly.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/memory.dto").MemoryResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, memory_dto_1.MemorySearchDto]),
    __metadata("design:returntype", Promise)
], MemoryController.prototype, "searchMemories", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.MemoryCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Create a memory',
        description: 'Create a new memory by providing a name, description, and a list of asset IDs to include in the memory.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/memory.dto").MemoryResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, memory_dto_1.MemoryCreateDto]),
    __metadata("design:returntype", Promise)
], MemoryController.prototype, "createMemory", null);
__decorate([
    (0, common_1.Get)('statistics'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.MemoryStatistics }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve memories statistics',
        description: 'Retrieve statistics about memories, such as total count and other relevant metrics.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/memory.dto").MemoryStatisticsResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, memory_dto_1.MemorySearchDto]),
    __metadata("design:returntype", Promise)
], MemoryController.prototype, "memoriesStatistics", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.MemoryRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve a memory',
        description: 'Retrieve a specific memory by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/memory.dto").MemoryResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], MemoryController.prototype, "getMemory", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.MemoryUpdate }),
    (0, decorators_1.Endpoint)({
        summary: 'Update a memory',
        description: 'Update an existing memory by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/memory.dto").MemoryResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        memory_dto_1.MemoryUpdateDto]),
    __metadata("design:returntype", Promise)
], MemoryController.prototype, "updateMemory", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.MemoryDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Delete a memory',
        description: 'Delete a specific memory by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], MemoryController.prototype, "deleteMemory", null);
__decorate([
    (0, common_1.Put)(':id/assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.MemoryAssetCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Add assets to a memory',
        description: 'Add a list of asset IDs to a specific memory.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-ids.response.dto").BulkIdResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        asset_ids_response_dto_1.BulkIdsDto]),
    __metadata("design:returntype", Promise)
], MemoryController.prototype, "addMemoryAssets", null);
__decorate([
    (0, common_1.Delete)(':id/assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.MemoryAssetDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Remove assets from a memory',
        description: 'Remove a list of asset IDs from a specific memory.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: [require("../dtos/asset-ids.response.dto").BulkIdResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        asset_ids_response_dto_1.BulkIdsDto,
        validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], MemoryController.prototype, "removeMemoryAssets", null);
exports.MemoryController = MemoryController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Memories),
    (0, common_1.Controller)('memories'),
    __metadata("design:paramtypes", [memory_service_1.MemoryService])
], MemoryController);
//# sourceMappingURL=memory.controller.js.map