import { Response } from 'express';
import { ActivityCreateDto, ActivityDto, ActivityResponseDto, ActivitySearchDto, ActivityStatisticsResponseDto } from 'src/dtos/activity.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { ActivityService } from 'src/services/activity.service';
import { UUIDParamDto } from 'src/validation';
export declare class ActivityController {
    private service;
    constructor(service: ActivityService);
    getActivities(auth: AuthDto, dto: ActivitySearchDto): Promise<ActivityResponseDto[]>;
    createActivity(auth: AuthDto, dto: ActivityCreateDto, res: Response): Promise<ActivityResponseDto>;
    getActivityStatistics(auth: AuthDto, dto: ActivityDto): Promise<ActivityStatisticsResponseDto>;
    deleteActivity(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
