"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.endpointTags = exports.ORIENTATION_TO_SHARP_ROTATION = exports.CLIP_MODEL_INFO = exports.FACE_THUMBNAIL_SIZE = exports.excludePaths = exports.LOGIN_URL = exports.MOBILE_REDIRECT = exports.reverseGeocodeMaxDistance = exports.citiesFile = exports.ONE_HOUR = exports.AUDIT_LOG_MAX_DURATION = exports.serverVersion = exports.IWorker = exports.SALT_ROUNDS = exports.VECTORCHORD_LIST_SLACK_FACTOR = exports.VECTOR_INDEX_TABLES = exports.VECTOR_EXTENSIONS = exports.EXTENSION_NAMES = exports.JOBS_LIBRARY_PAGINATION_SIZE = exports.JOBS_ASSET_PAGINATION_SIZE = exports.VECTOR_VERSION_RANGE = exports.VECTORS_VERSION_RANGE = exports.VECTORCHORD_VERSION_RANGE = exports.POSTGRES_VERSION_RANGE = void 0;
const luxon_1 = require("luxon");
const node_fs_1 = require("node:fs");
const node_path_1 = require("node:path");
const semver_1 = require("semver");
const enum_1 = require("./enum");
exports.POSTGRES_VERSION_RANGE = '>=14.0.0';
exports.VECTORCHORD_VERSION_RANGE = '>=0.3 <0.6';
exports.VECTORS_VERSION_RANGE = '>=0.2 <0.4';
exports.VECTOR_VERSION_RANGE = '>=0.5 <1';
exports.JOBS_ASSET_PAGINATION_SIZE = 1000;
exports.JOBS_LIBRARY_PAGINATION_SIZE = 10_000;
exports.EXTENSION_NAMES = {
    cube: 'cube',
    earthdistance: 'earthdistance',
    vector: 'pgvector',
    vectors: 'pgvecto.rs',
    vchord: 'VectorChord',
};
exports.VECTOR_EXTENSIONS = [
    enum_1.DatabaseExtension.VectorChord,
    enum_1.DatabaseExtension.Vectors,
    enum_1.DatabaseExtension.Vector,
];
exports.VECTOR_INDEX_TABLES = {
    [enum_1.VectorIndex.Clip]: 'smart_search',
    [enum_1.VectorIndex.Face]: 'face_search',
};
exports.VECTORCHORD_LIST_SLACK_FACTOR = 1.2;
exports.SALT_ROUNDS = 10;
exports.IWorker = 'IWorker';
const basePath = (0, node_path_1.dirname)(__filename);
const packageFile = (0, node_path_1.join)(basePath, '..', 'package.json');
const { version } = JSON.parse((0, node_fs_1.readFileSync)(packageFile, 'utf8'));
exports.serverVersion = new semver_1.SemVer(version);
exports.AUDIT_LOG_MAX_DURATION = luxon_1.Duration.fromObject({ days: 100 });
exports.ONE_HOUR = luxon_1.Duration.fromObject({ hours: 1 });
exports.citiesFile = 'cities500.txt';
exports.reverseGeocodeMaxDistance = 25_000;
exports.MOBILE_REDIRECT = 'app.immich:///oauth-callback';
exports.LOGIN_URL = '/auth/login?autoLaunch=0';
exports.excludePaths = ['/.well-known/immich', '/custom.css', '/favicon.ico'];
exports.FACE_THUMBNAIL_SIZE = 250;
exports.CLIP_MODEL_INFO = {
    RN101__openai: { dimSize: 512 },
    RN101__yfcc15m: { dimSize: 512 },
    'ViT-B-16__laion400m_e31': { dimSize: 512 },
    'ViT-B-16__laion400m_e32': { dimSize: 512 },
    'ViT-B-16__openai': { dimSize: 512 },
    'ViT-B-32__laion2b-s34b-b79k': { dimSize: 512 },
    'ViT-B-32__laion2b_e16': { dimSize: 512 },
    'ViT-B-32__laion400m_e31': { dimSize: 512 },
    'ViT-B-32__laion400m_e32': { dimSize: 512 },
    'ViT-B-32__openai': { dimSize: 512 },
    'XLM-Roberta-Base-ViT-B-32__laion5b_s13b_b90k': { dimSize: 512 },
    'XLM-Roberta-Large-Vit-B-32': { dimSize: 512 },
    RN50x4__openai: { dimSize: 640 },
    'ViT-B-16-plus-240__laion400m_e31': { dimSize: 640 },
    'ViT-B-16-plus-240__laion400m_e32': { dimSize: 640 },
    'XLM-Roberta-Large-Vit-B-16Plus': { dimSize: 640 },
    'LABSE-Vit-L-14': { dimSize: 768 },
    RN50x16__openai: { dimSize: 768 },
    'ViT-B-16-SigLIP-256__webli': { dimSize: 768 },
    'ViT-B-16-SigLIP-384__webli': { dimSize: 768 },
    'ViT-B-16-SigLIP-512__webli': { dimSize: 768 },
    'ViT-B-16-SigLIP-i18n-256__webli': { dimSize: 768 },
    'ViT-B-16-SigLIP__webli': { dimSize: 768 },
    'ViT-L-14-336__openai': { dimSize: 768 },
    'ViT-L-14-quickgelu__dfn2b': { dimSize: 768 },
    'ViT-L-14__laion2b-s32b-b82k': { dimSize: 768 },
    'ViT-L-14__laion400m_e31': { dimSize: 768 },
    'ViT-L-14__laion400m_e32': { dimSize: 768 },
    'ViT-L-14__openai': { dimSize: 768 },
    'XLM-Roberta-Large-Vit-L-14': { dimSize: 768 },
    'nllb-clip-base-siglip__mrl': { dimSize: 768 },
    'nllb-clip-base-siglip__v1': { dimSize: 768 },
    RN50__cc12m: { dimSize: 1024 },
    RN50__openai: { dimSize: 1024 },
    RN50__yfcc15m: { dimSize: 1024 },
    RN50x64__openai: { dimSize: 1024 },
    'ViT-H-14-378-quickgelu__dfn5b': { dimSize: 1024 },
    'ViT-H-14-quickgelu__dfn5b': { dimSize: 1024 },
    'ViT-H-14__laion2b-s32b-b79k': { dimSize: 1024 },
    'ViT-L-16-SigLIP-256__webli': { dimSize: 1024 },
    'ViT-L-16-SigLIP-384__webli': { dimSize: 1024 },
    'ViT-g-14__laion2b-s12b-b42k': { dimSize: 1024 },
    'XLM-Roberta-Large-ViT-H-14__frozen_laion5b_s13b_b90k': { dimSize: 1024 },
    'ViT-SO400M-14-SigLIP-384__webli': { dimSize: 1152 },
    'nllb-clip-large-siglip__mrl': { dimSize: 1152 },
    'nllb-clip-large-siglip__v1': { dimSize: 1152 },
    'ViT-B-16-SigLIP2__webli': { dimSize: 768 },
    'ViT-B-32-SigLIP2-256__webli': { dimSize: 768 },
    'ViT-L-16-SigLIP2-256__webli': { dimSize: 1024 },
    'ViT-L-16-SigLIP2-384__webli': { dimSize: 1024 },
    'ViT-L-16-SigLIP2-512__webli': { dimSize: 1024 },
    'ViT-SO400M-14-SigLIP2__webli': { dimSize: 1152 },
    'ViT-SO400M-14-SigLIP2-378__webli': { dimSize: 1152 },
    'ViT-SO400M-16-SigLIP2-256__webli': { dimSize: 1152 },
    'ViT-SO400M-16-SigLIP2-384__webli': { dimSize: 1152 },
    'ViT-SO400M-16-SigLIP2-512__webli': { dimSize: 1152 },
    'ViT-gopt-16-SigLIP2-256__webli': { dimSize: 1536 },
    'ViT-gopt-16-SigLIP2-384__webli': { dimSize: 1536 },
};
exports.ORIENTATION_TO_SHARP_ROTATION = {
    [enum_1.ExifOrientation.Horizontal]: { angle: 0 },
    [enum_1.ExifOrientation.MirrorHorizontal]: { angle: 0, flop: true },
    [enum_1.ExifOrientation.Rotate180]: { angle: 180 },
    [enum_1.ExifOrientation.MirrorVertical]: { angle: 180, flop: true },
    [enum_1.ExifOrientation.MirrorHorizontalRotate270CW]: { angle: 270, flip: true },
    [enum_1.ExifOrientation.Rotate90CW]: { angle: 90 },
    [enum_1.ExifOrientation.MirrorHorizontalRotate90CW]: { angle: 90, flip: true },
    [enum_1.ExifOrientation.Rotate270CW]: { angle: 270 },
};
exports.endpointTags = {
    [enum_1.ApiTag.Activities]: 'An activity is a like or a comment made by a user on an asset or album.',
    [enum_1.ApiTag.Albums]: 'An album is a collection of assets that can be shared with other users or via shared links.',
    [enum_1.ApiTag.ApiKeys]: 'An api key can be used to programmatically access the Immich API.',
    [enum_1.ApiTag.Assets]: 'An asset is an image or video that has been uploaded to Immich.',
    [enum_1.ApiTag.Authentication]: 'Endpoints related to user authentication, including OAuth.',
    [enum_1.ApiTag.AuthenticationAdmin]: 'Administrative endpoints related to authentication.',
    [enum_1.ApiTag.Deprecated]: 'Deprecated endpoints that are planned for removal in the next major release.',
    [enum_1.ApiTag.Download]: 'Endpoints for downloading assets or collections of assets.',
    [enum_1.ApiTag.Duplicates]: 'Endpoints for managing and identifying duplicate assets.',
    [enum_1.ApiTag.Faces]: 'A face is a detected human face within an asset, which can be associated with a person. Faces are normally detected via machine learning, but can also be created via manually.',
    [enum_1.ApiTag.Jobs]: 'Queues and background jobs are used for processing tasks asynchronously. Queues can be paused and resumed as needed.',
    [enum_1.ApiTag.Libraries]: 'An external library is made up of input file paths or expressions that are scanned for asset files. Discovered files are automatically imported. Assets much be unique within a library, but can be duplicated across libraries. Each user has a default upload library, and can have one or more external libraries.',
    [enum_1.ApiTag.Maintenance]: 'Maintenance mode allows you to put Immich in a read-only state to perform various operations.',
    [enum_1.ApiTag.Map]: 'Map endpoints include supplemental functionality related to geolocation, such as reverse geocoding and retrieving map markers for assets with geolocation data.',
    [enum_1.ApiTag.Memories]: 'A memory is a specialized collection of assets with dedicated viewing implementations in the web and mobile clients. A memory includes fields related to visibility and are automatically generated per user via a background job.',
    [enum_1.ApiTag.Notifications]: 'A notification is a specialized message sent to users to inform them of important events. Currently, these notifications are only shown in the Immich web application.',
    [enum_1.ApiTag.NotificationsAdmin]: 'Notification administrative endpoints.',
    [enum_1.ApiTag.Partners]: 'A partner is a link with another user that allows sharing of assets between two users.',
    [enum_1.ApiTag.People]: 'A person is a collection of faces, which can be favorited and named. A person can also be merged into another person. People are automatically created via the face recognition job.',
    [enum_1.ApiTag.Plugins]: 'A plugin is an installed module that makes filters and actions available for the workflow feature.',
    [enum_1.ApiTag.Queues]: 'Queues and background jobs are used for processing tasks asynchronously. Queues can be paused and resumed as needed.',
    [enum_1.ApiTag.Search]: 'Endpoints related to searching assets via text, smart search, optical character recognition (OCR), and other filters like person, album, and other metadata. Search endpoints usually support pagination and sorting.',
    [enum_1.ApiTag.Server]: 'Information about the current server deployment, including version and build information, available features, supported media types, and more.',
    [enum_1.ApiTag.Sessions]: 'A session represents an authenticated login session for a user. Sessions also appear in the web application as "Authorized devices".',
    [enum_1.ApiTag.SharedLinks]: 'A shared link is a public url that provides access to a specific album, asset, or collection of assets. A shared link can be protected with a password, include a specific slug, allow or disallow downloads, and optionally include an expiration date.',
    [enum_1.ApiTag.Stacks]: 'A stack is a group of related assets. One asset is the "primary" asset, and the rest are "child" assets. On the main timeline, stack parents are included by default, while child assets are hidden.',
    [enum_1.ApiTag.Sync]: 'A collection of endpoints for the new mobile synchronization implementation.',
    [enum_1.ApiTag.SystemConfig]: 'Endpoints to view, modify, and validate the system configuration settings.',
    [enum_1.ApiTag.SystemMetadata]: 'Endpoints to view, modify, and validate the system metadata, which includes information about things like admin onboarding status.',
    [enum_1.ApiTag.Tags]: 'A tag is a user-defined label that can be applied to assets for organizational purposes. Tags can also be hierarchical, allowing for parent-child relationships between tags.',
    [enum_1.ApiTag.Timeline]: 'Specialized endpoints related to the timeline implementation used in the web application. External applications or tools should not use or rely on these endpoints, as they are subject to change without notice.',
    [enum_1.ApiTag.Trash]: 'Endpoints for managing the trash can, which includes assets that have been discarded. Items in the trash are automatically deleted after a configured amount of time.',
    [enum_1.ApiTag.UsersAdmin]: 'Administrative endpoints for managing users, including creating, updating, deleting, and restoring users. Also includes endpoints for resetting passwords and PIN codes.',
    [enum_1.ApiTag.Users]: 'Endpoints for viewing and updating the current users, including product key information, profile picture data, onboarding progress, and more.',
    [enum_1.ApiTag.Views]: 'Endpoints for specialized views, such as the folder view.',
    [enum_1.ApiTag.Workflows]: 'A workflow is a set of actions that run whenever a triggering event occurs. Workflows also can include filters to further limit execution.',
};
//# sourceMappingURL=constants.js.map