/*
 * CoreFreq
 * Copyright (C) 2015-2025 CYRIL COURTIAT
 * Licenses: GPL2
 */

#define _GNU_SOURCE
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <locale.h>
#include <sched.h>
#include <errno.h>

#include "bitasm.h"
#include "corefreq-ui.h"
#include "corefreq-cli-rsc.h"
#include "corefreq-cli-rsc-en.h"
#include "corefreq-cli-rsc-fr.h"
#include "corefreq-cli-rsc-theme-dflt.h"
#include "corefreq-cli-rsc-theme-usr1.h"
#include "corefreq-cli-rsc-theme-usr2.h"

#define DEF_LDA(_rsc)							\
ATTRIBUTE _rsc##_##ATTR_ARRAY						\
	[THM_CNT]							\
	[(sizeof((ATTRIBUTE[]) _rsc##_##THM_DFLT_ATTR) / sizeof(ATTRIBUTE))] = \
{									\
	[THM_DFLT] = _rsc##_##THM_DFLT_ATTR,				\
	[THM_USR1] = _rsc##_##THM_USR1_ATTR,				\
	[THM_USR2] = _rsc##_##THM_USR2_ATTR				\
};									\
ASCII	_rsc##_##CODE_EN_ARRAY[] = _rsc##_##CODE_EN,			\
	_rsc##_##CODE_FR_ARRAY[] = _rsc##_##CODE_FR

#define DEF_LDB(_rsc)							\
ATTRIBUTE _rsc##_##ATTR_ARRAY						\
	[THM_CNT]							\
	[(sizeof((ATTRIBUTE[]) _rsc##_##THM_DFLT_ATTR) / sizeof(ATTRIBUTE))] = \
{									\
	[THM_DFLT] = _rsc##_##THM_DFLT_ATTR,				\
	[THM_USR1] = _rsc##_##THM_USR1_ATTR,				\
	[THM_USR2] = _rsc##_##THM_USR2_ATTR				\
}

#define LDV(attr_var, en_var, fr_var)					\
	.Attr = {							\
		[THM_DFLT] = attr_var[THM_DFLT],			\
		[THM_USR1] = attr_var[THM_USR1],			\
		[THM_USR2] = attr_var[THM_USR2] 			\
	},								\
	.Code = {							\
		[LOC_EN] = (ASCII*) en_var,				\
		[LOC_FR] = (ASCII*) fr_var				\
	}

#define LDA(_rsc)							\
[_rsc] = {								\
	LDV(_rsc##_ATTR_ARRAY, _rsc##_CODE_EN_ARRAY, _rsc##_CODE_FR_ARRAY),\
	.Size = {							\
		[LOC_EN] = sizeof(_rsc##_CODE_EN_ARRAY),		\
		[LOC_FR] = sizeof(_rsc##_CODE_FR_ARRAY)			\
	}								\
}

#define LDB(_rsc)							\
[_rsc] = {								\
	LDV(_rsc##_ATTR_ARRAY, hSpace, hSpace) ,			\
	.Size = {							\
		[LOC_EN] = sizeof(HSPACE),				\
		[LOC_FR] = sizeof(HSPACE)				\
	}								\
}

#define LDS(_rsc)							\
[_rsc] = {								\
	LDV(_rsc##_ATTR_ARRAY, _rsc##_CODE_EN, _rsc##_CODE_FR) ,	\
	.Size = {							\
		[LOC_EN] = __builtin_strlen(_rsc##_CODE_EN),		\
		[LOC_FR] = __builtin_strlen(_rsc##_CODE_FR)		\
	}								\
}

#define LDT(_rsc)							\
[_rsc] = {								\
	LDV(RSC_VOID_ATTR_ARRAY, _rsc##_CODE_EN, _rsc##_CODE_FR),	\
	.Size = {							\
		[LOC_EN] = __builtin_strlen(_rsc##_CODE_EN),		\
		[LOC_FR] = __builtin_strlen(_rsc##_CODE_FR)		\
	}								\
}

#define LDC(_rsc, _ref) 						\
[_rsc] = {								\
	LDV(_ref##_ATTR_ARRAY, _rsc##_CODE_EN, _rsc##_CODE_FR) ,	\
	.Size = {							\
		[LOC_EN] = __builtin_strlen(_rsc##_CODE_EN),		\
		[LOC_FR] = __builtin_strlen(_rsc##_CODE_FR)		\
	}								\
}

#define LDQ(_rsc)							\
[_rsc] = {								\
	LDV(RSC_VOID_ATTR_ARRAY, _rsc##_CODE, _rsc##_CODE),		\
	.Size = {							\
		[LOC_EN] = __builtin_strlen(_rsc##_CODE),		\
		[LOC_FR] = __builtin_strlen(_rsc##_CODE)		\
	}								\
}

DEF_LDB(RSC_UI);
DEF_LDB(RSC_VOID);

#ifndef NO_HEADER
DEF_LDA(RSC_LAYOUT_HEADER_PROC);
DEF_LDA(RSC_LAYOUT_HEADER_CPU);
DEF_LDA(RSC_LAYOUT_HEADER_ARCH);
DEF_LDA(RSC_LAYOUT_HEADER_CACHE_L1);
DEF_LDA(RSC_LAYOUT_HEADER_BCLK);
DEF_LDA(RSC_LAYOUT_HEADER_CACHES);
#endif /* NO_HEADER */

#ifndef NO_UPPER
DEF_LDA(RSC_LAYOUT_RULER_LOAD);
DEF_LDA(RSC_LAYOUT_RULER_REL_LOAD);
DEF_LDA(RSC_LAYOUT_RULER_ABS_LOAD);
#endif /* NO_UPPER */

#ifndef NO_LOWER
DEF_LDA(RSC_LAYOUT_MONITOR_FREQUENCY);
DEF_LDA(RSC_LAYOUT_MONITOR_INST);
DEF_LDA(RSC_LAYOUT_MONITOR_COMMON);
DEF_LDA(RSC_LAYOUT_MONITOR_TASKS);
DEF_LDA(RSC_LAYOUT_MONITOR_SLICE);
DEF_LDA(RSC_LAYOUT_CUSTOM_FIELD);
DEF_LDA(RSC_LAYOUT_RULER_FREQUENCY);
DEF_LDA(RSC_LAYOUT_RULER_FREQUENCY_AVG);
DEF_LDA(RSC_LAYOUT_RULER_FREQUENCY_PKG);
DEF_LDA(RSC_LAYOUT_RULER_INST);
DEF_LDA(RSC_LAYOUT_RULER_CYCLES);
DEF_LDA(RSC_LAYOUT_RULER_CSTATES);
DEF_LDA(RSC_LAYOUT_RULER_INTERRUPTS);
DEF_LDA(RSC_LAYOUT_RULER_PACKAGE);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC02);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC03);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC04);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC06);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC07);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC08);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC09);
DEF_LDA(RSC_LAYOUT_PACKAGE_PC10);
DEF_LDA(RSC_LAYOUT_PACKAGE_MC06);
DEF_LDA(RSC_LAYOUT_PACKAGE_CTR0);
DEF_LDA(RSC_LAYOUT_PACKAGE_CTR1);
DEF_LDA(RSC_LAYOUT_PACKAGE_CTR2);
DEF_LDA(RSC_LAYOUT_PACKAGE_CTR3);
DEF_LDA(RSC_LAYOUT_PACKAGE_CTR4);
DEF_LDA(RSC_LAYOUT_PACKAGE_CTR5);
DEF_LDA(RSC_LAYOUT_PACKAGE_CTR6);
DEF_LDA(RSC_LAYOUT_PACKAGE_CTR7);
DEF_LDA(RSC_LAYOUT_PACKAGE_FCLK);
DEF_LDA(RSC_LAYOUT_PACKAGE_UNCORE);
DEF_LDA(RSC_LAYOUT_PACKAGE_FABRIC);
DEF_LDA(RSC_LAYOUT_RULER_TASKS);
DEF_LDA(RSC_LAYOUT_TASKS_TRACKING);
DEF_LDA(RSC_LAYOUT_TASKS_STATE_SORTED);
DEF_LDA(RSC_LAYOUT_TASKS_RUNTIME_SORTED);
DEF_LDA(RSC_LAYOUT_TASKS_USRTIME_SORTED);
DEF_LDA(RSC_LAYOUT_TASKS_SYSTIME_SORTED);
DEF_LDA(RSC_LAYOUT_TASKS_PROCESS_SORTED);
DEF_LDA(RSC_LAYOUT_TASKS_COMMAND_SORTED);
DEF_LDA(RSC_LAYOUT_TASKS_REVERSE_SORT_OFF);
DEF_LDA(RSC_LAYOUT_TASKS_REVERSE_SORT_ON);
DEF_LDA(RSC_LAYOUT_TASKS_VALUE_SWITCH);
DEF_LDA(RSC_LAYOUT_TASKS_VALUE_OFF);
DEF_LDA(RSC_LAYOUT_TASKS_VALUE_ON);
DEF_LDA(RSC_LAYOUT_RULER_SENSORS);
DEF_LDA(RSC_LAYOUT_RULER_PWR_UNCORE);
DEF_LDA(RSC_LAYOUT_RULER_PWR_PLATFORM);
DEF_LDA(RSC_LAYOUT_RULER_PWR_SOC);
DEF_LDA(RSC_LAYOUT_RULER_VOLTAGE);
DEF_LDA(RSC_LAYOUT_RULER_VPKG_SAV);
DEF_LDA(RSC_LAYOUT_RULER_VPKG_SOC);
DEF_LDA(RSC_LAYOUT_RULER_ENERGY);
DEF_LDA(RSC_LAYOUT_RULER_POWER);
DEF_LDA(RSC_LAYOUT_RULER_SLICE);
DEF_LDA(RSC_LAYOUT_RULER_CUSTOM);
#endif /* NO_LOWER */

#ifndef NO_FOOTER
DEF_LDA(RSC_LAYOUT_FOOTER_TECH_X86);
DEF_LDA(RSC_LAYOUT_FOOTER_TECH_INTEL);
DEF_LDA(RSC_LAYOUT_FOOTER_TECH_AMD);
DEF_LDA(RSC_LAYOUT_FOOTER_VOLT_TEMP);
DEF_LDA(RSC_LAYOUT_FOOTER_SYSTEM);
#endif /* NO_FOOTER */

DEF_LDA(RSC_LAYOUT_CARD_CORE_ONLINE_COND0);
DEF_LDA(RSC_LAYOUT_CARD_CORE_ONLINE_COND1);
DEF_LDA(RSC_LAYOUT_CARD_CORE_OFFLINE);
DEF_LDA(RSC_LAYOUT_CARD_CLK);
DEF_LDA(RSC_LAYOUT_CARD_UNCORE);
DEF_LDA(RSC_LAYOUT_CARD_BUS);
DEF_LDA(RSC_LAYOUT_CARD_MC);
DEF_LDA(RSC_LAYOUT_CARD_LOAD);
DEF_LDA(RSC_LAYOUT_CARD_IDLE);
DEF_LDA(RSC_LAYOUT_CARD_RAM);
DEF_LDA(RSC_LAYOUT_CARD_TASK);

DEF_LDB(RSC_RUN_STATE_COLOR);
DEF_LDB(RSC_UNINT_STATE_COLOR);
DEF_LDB(RSC_ZOMBIE_STATE_COLOR);
DEF_LDB(RSC_SLEEP_STATE_COLOR);
DEF_LDB(RSC_WAIT_STATE_COLOR);
DEF_LDB(RSC_OTHER_STATE_COLOR);
DEF_LDB(RSC_TRACKER_STATE_COLOR);

DEF_LDB(RSC_SYSINFO_CPUID_COND0);
DEF_LDB(RSC_SYSINFO_CPUID_COND1);
DEF_LDB(RSC_SYSINFO_CPUID_COND2);
DEF_LDB(RSC_SYSINFO_CPUID_COND3);

DEF_LDB(RSC_SYSTEM_REGISTERS_COND0);
DEF_LDB(RSC_SYSTEM_REGISTERS_COND1);
DEF_LDB(RSC_SYSTEM_REGISTERS_COND2);
DEF_LDB(RSC_SYSTEM_REGISTERS_COND3);
DEF_LDB(RSC_SYSTEM_REGISTERS_COND4);

DEF_LDB(RSC_SYSINFO_PROC_COND0);
DEF_LDB(RSC_SYSINFO_PROC_COND1);
DEF_LDB(RSC_SYSINFO_PROC_COND2);
DEF_LDB(RSC_SYSINFO_PROC_COND3);

DEF_LDB(RSC_SYSINFO_ISA_COND_0_0);
DEF_LDB(RSC_SYSINFO_ISA_COND_0_1);
DEF_LDB(RSC_SYSINFO_ISA_COND_0_2);
DEF_LDB(RSC_SYSINFO_ISA_COND_0_3);
DEF_LDB(RSC_SYSINFO_ISA_COND_0_4);

DEF_LDB(RSC_SYSINFO_ISA_COND_1_0);
DEF_LDB(RSC_SYSINFO_ISA_COND_1_1);
DEF_LDB(RSC_SYSINFO_ISA_COND_1_2);
DEF_LDB(RSC_SYSINFO_ISA_COND_1_3);
DEF_LDB(RSC_SYSINFO_ISA_COND_1_4);

DEF_LDB(RSC_SYSINFO_FEATURES_COND0);
DEF_LDB(RSC_SYSINFO_FEATURES_COND1);
DEF_LDB(RSC_SYSINFO_FEATURES_COND2);
DEF_LDB(RSC_SYSINFO_FEATURES_COND3);
DEF_LDB(RSC_SYSINFO_FEATURES_COND4);

DEF_LDB(RSC_SYSINFO_TECH_COND0);
DEF_LDB(RSC_SYSINFO_TECH_COND1);

DEF_LDB(RSC_SYSINFO_PERFMON_COND0);
DEF_LDB(RSC_SYSINFO_PERFMON_COND1);
DEF_LDB(RSC_SYSINFO_PERFMON_COND2);
DEF_LDB(RSC_SYSINFO_PERFMON_COND3);
DEF_LDB(RSC_SYSINFO_PERFMON_COND4);

DEF_LDB(RSC_SYSINFO_PERFMON_HWP_CAP_COND0);
DEF_LDB(RSC_SYSINFO_PERFMON_HWP_CAP_COND1);

DEF_LDB(RSC_SYSINFO_PWR_THERMAL_COND0);
DEF_LDB(RSC_SYSINFO_PWR_THERMAL_COND1);
DEF_LDB(RSC_SYSINFO_PWR_THERMAL_COND2);
DEF_LDB(RSC_SYSINFO_PWR_THERMAL_COND3);
DEF_LDB(RSC_SYSINFO_PWR_THERMAL_COND4);
DEF_LDB(RSC_SYSINFO_PWR_THERMAL_COND5);
DEF_LDB(RSC_SYSINFO_PWR_THERMAL_COND6);

DEF_LDB(RSC_SYSINFO_KERNEL);

DEF_LDB(RSC_TOPOLOGY_COND0);
DEF_LDB(RSC_TOPOLOGY_COND1);
DEF_LDB(RSC_TOPOLOGY_COND2);
DEF_LDB(RSC_TOPOLOGY_COND3);
DEF_LDB(RSC_TOPOLOGY_COND4);

DEF_LDB(RSC_MEMORY_CONTROLLER_COND0);
DEF_LDB(RSC_MEMORY_CONTROLLER_COND1);

DEF_LDB(RSC_CREATE_MENU_DISABLE);
DEF_LDB(RSC_MENU_ITEM_MENU);
DEF_LDB(RSC_MENU_ITEM_VIEW);
DEF_LDB(RSC_MENU_ITEM_WINDOW);
DEF_LDB(RSC_CREATE_MENU_FN_KEY);
DEF_LDB(RSC_CREATE_MENU_SHORTKEY);
DEF_LDB(RSC_CREATE_MENU_CTRL_KEY);

DEF_LDB(RSC_CREATE_SETTINGS_COND0);
DEF_LDB(RSC_CREATE_SETTINGS_COND1);

DEF_LDB(RSC_CREATE_ADV_HELP_COND0);
DEF_LDB(RSC_CREATE_ADV_HELP_COND1);

DEF_LDB(RSC_CREATE_HOTPLUG_CPU_ENABLE);
DEF_LDB(RSC_CREATE_HOTPLUG_CPU_DISABLE);
DEF_LDB(RSC_CREATE_HOTPLUG_CPU_ONLINE);
DEF_LDB(RSC_CREATE_HOTPLUG_CPU_OFFLINE);

DEF_LDB(RSC_CREATE_RATIO_CLOCK_COND0);
DEF_LDB(RSC_CREATE_RATIO_CLOCK_COND1);
DEF_LDB(RSC_CREATE_RATIO_CLOCK_COND2);
DEF_LDB(RSC_CREATE_RATIO_CLOCK_COND3);
DEF_LDB(RSC_CREATE_RATIO_CLOCK_COND4);
DEF_LDB(RSC_CREATE_RATIO_CLOCK_COND5);
DEF_LDB(RSC_CREATE_RATIO_CLOCK_COND6);

DEF_LDB(RSC_CREATE_SELECT_CPU_COND0);
DEF_LDB(RSC_CREATE_SELECT_CPU_COND1);
DEF_LDB(RSC_CREATE_SELECT_CPU_COND2);

#ifndef NO_FOOTER
DEF_LDB(RSC_HOT_EVENT_COND0);
DEF_LDB(RSC_HOT_EVENT_COND1);
DEF_LDB(RSC_HOT_EVENT_COND2);
DEF_LDB(RSC_HOT_EVENT_COND3);
DEF_LDB(RSC_HOT_EVENT_COND4);
#endif

DEF_LDB(RSC_BOX_EVENT_COND00);
DEF_LDB(RSC_BOX_EVENT_COND01);
DEF_LDB(RSC_BOX_EVENT_COND10);
DEF_LDB(RSC_BOX_EVENT_COND11);
DEF_LDB(RSC_BOX_EVENT_BUTTON);

DEF_LDB(RSC_CREATE_RECORDER);
DEF_LDB(RSC_SMBIOS_ITEM);

DEF_LDB(RSC_CREATE_SELECT_FREQ_PKG);
DEF_LDB(RSC_CREATE_SELECT_FREQ_COND0);
DEF_LDB(RSC_CREATE_SELECT_FREQ_COND1);

RESOURCE_ST Resource[] = {
	LDB(RSC_UI),
	LDB(RSC_VOID),
	LDQ(RSC_THEME_DFLT),
	LDQ(RSC_THEME_USR1),
	LDQ(RSC_THEME_USR2),
	LDQ(RSC_LAYOUT_LCD_RESET),
#ifndef NO_HEADER
	LDA(RSC_LAYOUT_HEADER_PROC),
	LDA(RSC_LAYOUT_HEADER_CPU),
	LDA(RSC_LAYOUT_HEADER_ARCH),
	LDA(RSC_LAYOUT_HEADER_CACHE_L1),
	LDA(RSC_LAYOUT_HEADER_BCLK),
	LDA(RSC_LAYOUT_HEADER_CACHES),
#endif /* NO_HEADER */
#ifndef NO_UPPER
	LDA(RSC_LAYOUT_RULER_LOAD),
	LDA(RSC_LAYOUT_RULER_REL_LOAD),
	LDA(RSC_LAYOUT_RULER_ABS_LOAD),
#endif /* NO_UPPER */
#ifndef NO_LOWER
	LDA(RSC_LAYOUT_MONITOR_FREQUENCY),
	LDA(RSC_LAYOUT_MONITOR_INST),
	LDA(RSC_LAYOUT_MONITOR_COMMON),
	LDA(RSC_LAYOUT_MONITOR_TASKS),
	LDA(RSC_LAYOUT_MONITOR_SLICE),
	LDA(RSC_LAYOUT_CUSTOM_FIELD),
	LDA(RSC_LAYOUT_RULER_FREQUENCY),
	LDA(RSC_LAYOUT_RULER_FREQUENCY_AVG),
	LDA(RSC_LAYOUT_RULER_FREQUENCY_PKG),
	LDA(RSC_LAYOUT_RULER_INST),
	LDA(RSC_LAYOUT_RULER_CYCLES),
	LDA(RSC_LAYOUT_RULER_CSTATES),
	LDA(RSC_LAYOUT_RULER_INTERRUPTS),
	LDA(RSC_LAYOUT_RULER_PACKAGE),
	LDA(RSC_LAYOUT_PACKAGE_PC),
	LDA(RSC_LAYOUT_PACKAGE_PC02),
	LDA(RSC_LAYOUT_PACKAGE_PC03),
	LDA(RSC_LAYOUT_PACKAGE_PC04),
	LDA(RSC_LAYOUT_PACKAGE_PC06),
	LDA(RSC_LAYOUT_PACKAGE_PC07),
	LDA(RSC_LAYOUT_PACKAGE_PC08),
	LDA(RSC_LAYOUT_PACKAGE_PC09),
	LDA(RSC_LAYOUT_PACKAGE_PC10),
	LDA(RSC_LAYOUT_PACKAGE_MC06),
	LDA(RSC_LAYOUT_PACKAGE_CTR0),
	LDA(RSC_LAYOUT_PACKAGE_CTR1),
	LDA(RSC_LAYOUT_PACKAGE_CTR2),
	LDA(RSC_LAYOUT_PACKAGE_CTR3),
	LDA(RSC_LAYOUT_PACKAGE_CTR4),
	LDA(RSC_LAYOUT_PACKAGE_CTR5),
	LDA(RSC_LAYOUT_PACKAGE_CTR6),
	LDA(RSC_LAYOUT_PACKAGE_CTR7),
	LDA(RSC_LAYOUT_PACKAGE_FCLK),
	LDA(RSC_LAYOUT_PACKAGE_UNCORE),
	LDA(RSC_LAYOUT_PACKAGE_FABRIC),
	LDA(RSC_LAYOUT_RULER_TASKS),
	LDA(RSC_LAYOUT_TASKS_TRACKING),
	LDA(RSC_LAYOUT_TASKS_STATE_SORTED),
	LDA(RSC_LAYOUT_TASKS_RUNTIME_SORTED),
	LDA(RSC_LAYOUT_TASKS_USRTIME_SORTED),
	LDA(RSC_LAYOUT_TASKS_SYSTIME_SORTED),
	LDA(RSC_LAYOUT_TASKS_PROCESS_SORTED),
	LDA(RSC_LAYOUT_TASKS_COMMAND_SORTED),
	LDA(RSC_LAYOUT_TASKS_REVERSE_SORT_OFF),
	LDA(RSC_LAYOUT_TASKS_REVERSE_SORT_ON),
	LDA(RSC_LAYOUT_TASKS_VALUE_SWITCH),
	LDA(RSC_LAYOUT_TASKS_VALUE_OFF),
	LDA(RSC_LAYOUT_TASKS_VALUE_ON),
	LDA(RSC_LAYOUT_RULER_SENSORS),
	LDA(RSC_LAYOUT_RULER_PWR_UNCORE),
	LDA(RSC_LAYOUT_RULER_PWR_PLATFORM),
	LDA(RSC_LAYOUT_RULER_PWR_SOC),
	LDA(RSC_LAYOUT_RULER_VOLTAGE),
	LDA(RSC_LAYOUT_RULER_VPKG_SAV),
	LDA(RSC_LAYOUT_RULER_VPKG_SOC),
	LDA(RSC_LAYOUT_RULER_ENERGY),
	LDA(RSC_LAYOUT_RULER_POWER),
	LDA(RSC_LAYOUT_RULER_SLICE),
	LDA(RSC_LAYOUT_RULER_CUSTOM),
#endif /* NO_LOWER */
#ifndef NO_FOOTER
	LDA(RSC_LAYOUT_FOOTER_TECH_X86),
	LDA(RSC_LAYOUT_FOOTER_TECH_INTEL),
	LDA(RSC_LAYOUT_FOOTER_TECH_AMD),
	LDA(RSC_LAYOUT_FOOTER_VOLT_TEMP),
	LDA(RSC_LAYOUT_FOOTER_SYSTEM),
	LDQ(RSC_LAYOUT_FOOTER_TSC_NONE),
	LDQ(RSC_LAYOUT_FOOTER_TSC_VAR),
	LDQ(RSC_LAYOUT_FOOTER_TSC_INV),
#endif /* NO_FOOTER */
	LDA(RSC_LAYOUT_CARD_CORE_ONLINE_COND0),
	LDA(RSC_LAYOUT_CARD_CORE_ONLINE_COND1),
	LDA(RSC_LAYOUT_CARD_CORE_OFFLINE),
	LDA(RSC_LAYOUT_CARD_CLK),
	LDA(RSC_LAYOUT_CARD_UNCORE),
	LDA(RSC_LAYOUT_CARD_BUS),
	LDA(RSC_LAYOUT_CARD_MC),
	LDA(RSC_LAYOUT_CARD_LOAD),
	LDA(RSC_LAYOUT_CARD_IDLE),
	LDA(RSC_LAYOUT_CARD_RAM),
	LDA(RSC_LAYOUT_CARD_TASK),
/* ATTRIBUTE */
	LDB(RSC_RUN_STATE_COLOR),
	LDB(RSC_UNINT_STATE_COLOR),
	LDB(RSC_ZOMBIE_STATE_COLOR),
	LDB(RSC_SLEEP_STATE_COLOR),
	LDB(RSC_WAIT_STATE_COLOR),
	LDB(RSC_OTHER_STATE_COLOR),
#ifndef NO_LOWER
	LDB(RSC_TRACKER_STATE_COLOR),
#endif
	LDB(RSC_SYSINFO_CPUID_COND0),
	LDB(RSC_SYSINFO_CPUID_COND1),
	LDB(RSC_SYSINFO_CPUID_COND2),
	LDB(RSC_SYSINFO_CPUID_COND3),
	LDB(RSC_SYSTEM_REGISTERS_COND0),
	LDB(RSC_SYSTEM_REGISTERS_COND1),
	LDB(RSC_SYSTEM_REGISTERS_COND2),
	LDB(RSC_SYSTEM_REGISTERS_COND3),
	LDB(RSC_SYSTEM_REGISTERS_COND4),
	LDB(RSC_SYSINFO_PROC_COND0),
	LDB(RSC_SYSINFO_PROC_COND1),
	LDB(RSC_SYSINFO_PROC_COND2),
	LDB(RSC_SYSINFO_PROC_COND3),
	LDB(RSC_SYSINFO_ISA_COND_0_0),
	LDB(RSC_SYSINFO_ISA_COND_0_1),
	LDB(RSC_SYSINFO_ISA_COND_0_2),
	LDB(RSC_SYSINFO_ISA_COND_0_3),
	LDB(RSC_SYSINFO_ISA_COND_0_4),
	LDB(RSC_SYSINFO_ISA_COND_1_0),
	LDB(RSC_SYSINFO_ISA_COND_1_1),
	LDB(RSC_SYSINFO_ISA_COND_1_2),
	LDB(RSC_SYSINFO_ISA_COND_1_3),
	LDB(RSC_SYSINFO_ISA_COND_1_4),
	LDB(RSC_SYSINFO_FEATURES_COND0),
	LDB(RSC_SYSINFO_FEATURES_COND1),
	LDB(RSC_SYSINFO_FEATURES_COND2),
	LDB(RSC_SYSINFO_FEATURES_COND3),
	LDB(RSC_SYSINFO_FEATURES_COND4),
	LDB(RSC_SYSINFO_TECH_COND0),
	LDB(RSC_SYSINFO_TECH_COND1),
	LDB(RSC_SYSINFO_PERFMON_COND0),
	LDB(RSC_SYSINFO_PERFMON_COND1),
	LDB(RSC_SYSINFO_PERFMON_COND2),
	LDB(RSC_SYSINFO_PERFMON_COND3),
	LDB(RSC_SYSINFO_PERFMON_COND4),
	LDB(RSC_SYSINFO_PERFMON_HWP_CAP_COND0),
	LDB(RSC_SYSINFO_PERFMON_HWP_CAP_COND1),
	LDB(RSC_SYSINFO_PWR_THERMAL_COND0),
	LDB(RSC_SYSINFO_PWR_THERMAL_COND1),
	LDB(RSC_SYSINFO_PWR_THERMAL_COND2),
	LDB(RSC_SYSINFO_PWR_THERMAL_COND3),
	LDB(RSC_SYSINFO_PWR_THERMAL_COND4),
	LDB(RSC_SYSINFO_PWR_THERMAL_COND5),
	LDB(RSC_SYSINFO_PWR_THERMAL_COND6),
	LDB(RSC_SYSINFO_KERNEL),
	LDB(RSC_TOPOLOGY_COND0),
	LDB(RSC_TOPOLOGY_COND1),
	LDB(RSC_TOPOLOGY_COND2),
	LDB(RSC_TOPOLOGY_COND3),
	LDB(RSC_TOPOLOGY_COND4),
	LDB(RSC_MEMORY_CONTROLLER_COND0),
	LDB(RSC_MEMORY_CONTROLLER_COND1),
	LDB(RSC_CREATE_MENU_DISABLE),
	LDB(RSC_CREATE_MENU_FN_KEY),
	LDB(RSC_CREATE_MENU_SHORTKEY),
	LDB(RSC_CREATE_MENU_CTRL_KEY),
	LDS(RSC_CREATE_SETTINGS_COND0),
	LDS(RSC_CREATE_SETTINGS_COND1),
	LDS(RSC_CREATE_ADV_HELP_COND0),
	LDS(RSC_CREATE_ADV_HELP_COND1),
	LDQ(RSC_CREATE_HOTPLUG_CPU_TITLE),
	LDS(RSC_CREATE_HOTPLUG_CPU_ENABLE),
	LDS(RSC_CREATE_HOTPLUG_CPU_DISABLE),
	LDS(RSC_CREATE_HOTPLUG_CPU_ONLINE),
	LDS(RSC_CREATE_HOTPLUG_CPU_OFFLINE),
	LDB(RSC_CREATE_RATIO_CLOCK_COND0),
	LDB(RSC_CREATE_RATIO_CLOCK_COND1),
	LDB(RSC_CREATE_RATIO_CLOCK_COND2),
	LDB(RSC_CREATE_RATIO_CLOCK_COND3),
	LDB(RSC_CREATE_RATIO_CLOCK_COND4),
	LDB(RSC_CREATE_RATIO_CLOCK_COND5),
	LDB(RSC_CREATE_RATIO_CLOCK_COND6),
	LDB(RSC_CREATE_SELECT_CPU_COND0),
	LDB(RSC_CREATE_SELECT_CPU_COND1),
	LDB(RSC_CREATE_SELECT_CPU_COND2),
#ifndef NO_FOOTER
	LDB(RSC_HOT_EVENT_COND0),
	LDB(RSC_HOT_EVENT_COND1),
	LDB(RSC_HOT_EVENT_COND2),
	LDB(RSC_HOT_EVENT_COND3),
	LDB(RSC_HOT_EVENT_COND4),
#endif
	LDB(RSC_BOX_EVENT_COND00),
	LDB(RSC_BOX_EVENT_COND01),
	LDB(RSC_BOX_EVENT_COND10),
	LDB(RSC_BOX_EVENT_COND11),
	LDB(RSC_BOX_EVENT_BUTTON),
	LDB(RSC_CREATE_RECORDER),
	LDB(RSC_SMBIOS_ITEM),
	LDB(RSC_CREATE_SELECT_FREQ_PKG),
	LDB(RSC_CREATE_SELECT_FREQ_COND0),
	LDB(RSC_CREATE_SELECT_FREQ_COND1),
/* ASCII */
	LDQ(RSC_COREFREQ_TITLE),
	LDT(RSC_PROCESSOR_TITLE),
	LDT(RSC_PROCESSOR),
	LDT(RSC_ARCHITECTURE),
	LDT(RSC_VENDOR_ID),
	LDQ(RSC_FIRMWARE),
	LDQ(RSC_HYBRID),
	LDT(RSC_MICROCODE),
	LDT(RSC_SIGNATURE),
	LDT(RSC_STEPPING),
	LDT(RSC_ONLINE_CPU),
	LDT(RSC_BASE_CLOCK),
	LDT(RSC_FREQUENCY),
	LDT(RSC_RATIO),
	LDT(RSC_FACTORY),
	LDT(RSC_OVERCLOCK),
	LDT(RSC_OC_BINS_COMM),
	LDT(RSC_PERFORMANCE),
	LDT(RSC_TARGET),
	LDT(RSC_LEVEL),
	LDT(RSC_PROGRAMMABLE),
	LDT(RSC_CONFIGURATION),
	LDT(RSC_TURBO_ACTIVATION),
	LDT(RSC_NOMINAL),
	LDT(RSC_UNLOCK),
	LDT(RSC_LOCK),
	LDT(RSC_ENABLE),
	LDT(RSC_DISABLE),
	LDT(RSC_CAPABILITIES),
	LDT(RSC_LOWEST),
	LDT(RSC_EFFICIENT),
	LDT(RSC_GUARANTEED),
	LDT(RSC_HIGHEST),
	LDT(RSC_RECORDER),
	LDT(RSC_STRESS),
	LDQ(RSC_SYSGATE),
	LDQ(RSC_FREQ_UNIT_MHZ),
	LDQ(RSC_PPIN),
	LDQ(RSC_PSTATE),
	LDQ(RSC_UNCORE),
	LDQ(RSC_BOOST),
	LDQ(RSC_TURBO),
	LDQ(RSC_CPPC),
	LDQ(RSC_MAX),
	LDQ(RSC_MIN),
	LDQ(RSC_BIN),
	LDQ(RSC_UCLK),
	LDQ(RSC_MCLK),
	LDQ(RSC_TGT),
	LDQ(RSC_HWP),
	LDQ(RSC_XFR),
	LDQ(RSC_CPB),
	LDQ(RSC_TDP),
	LDQ(RSC_ACT),
	LDT(RSC_SCOPE_NONE),
	LDT(RSC_SCOPE_THREAD),
	LDT(RSC_SCOPE_CORE),
	LDT(RSC_SCOPE_PACKAGE),
	LDT(RSC_CPUID_TITLE),
	LDT(RSC_LARGEST_STD_FUNC),
	LDT(RSC_LARGEST_EXT_FUNC),
	LDT(RSC_SYS_REGS_TITLE),
	LDQ(RSC_SYS_REGS_SPACE),
	LDQ(RSC_SYS_REGS_NA),
	LDQ(RSC_SYS_REGS_HDR_CPU),
	LDQ(RSC_SYS_REG_HDR_FLAGS),
	LDQ(RSC_SYS_REG_HDR_CF),
	LDQ(RSC_SYS_REG_HDR_ZF),
	LDQ(RSC_SYS_REG_HDR_SF),
	LDQ(RSC_SYS_REG_HDR_TF),
	LDQ(RSC_SYS_REG_HDR_IF),
	LDQ(RSC_SYS_REG_HDR_DF),
	LDQ(RSC_SYS_REG_HDR_OF),
	LDQ(RSC_SYS_REG_HDR_IOPL),
	LDQ(RSC_SYS_REG_HDR_NT),
	LDQ(RSC_SYS_REG_HDR_RF),
	LDQ(RSC_SYS_REG_HDR_VM),
	LDQ(RSC_SYS_REG_HDR_AC),
	LDQ(RSC_SYS_REG_HDR_VIF),
	LDQ(RSC_SYS_REG_HDR_VIP),
	LDQ(RSC_SYS_REG_HDR_ID),
	LDT(RSC_SYS_REG_FLAGS_CF),
	LDT(RSC_SYS_REG_FLAGS_ZF),
	LDT(RSC_SYS_REG_FLAGS_SF),
	LDT(RSC_SYS_REG_FLAGS_TF),
	LDT(RSC_SYS_REG_FLAGS_IF),
	LDT(RSC_SYS_REG_FLAGS_DF),
	LDT(RSC_SYS_REG_FLAGS_OF),
	LDT(RSC_SYS_REG_FLAGS_IOPL),
	LDT(RSC_SYS_REG_FLAGS_NT),
	LDT(RSC_SYS_REG_FLAGS_RF),
	LDT(RSC_SYS_REG_FLAGS_VM),
	LDT(RSC_SYS_REG_FLAGS_AC),
	LDT(RSC_SYS_REG_FLAGS_VIF),
	LDT(RSC_SYS_REG_FLAGS_VIP),
	LDT(RSC_SYS_REG_FLAGS_ID),
	LDQ(RSC_SYS_REG_HDR_CR0),
	LDQ(RSC_SYS_REG_HDR_CR0_PE),
	LDQ(RSC_SYS_REG_HDR_CR0_MP),
	LDQ(RSC_SYS_REG_HDR_CR0_EM),
	LDQ(RSC_SYS_REG_HDR_CR0_TS),
	LDQ(RSC_SYS_REG_HDR_CR0_ET),
	LDQ(RSC_SYS_REG_HDR_CR0_NE),
	LDQ(RSC_SYS_REG_HDR_CR0_WP),
	LDQ(RSC_SYS_REG_HDR_CR0_AM),
	LDQ(RSC_SYS_REG_HDR_CR0_NW),
	LDQ(RSC_SYS_REG_HDR_CR0_CD),
	LDQ(RSC_SYS_REG_HDR_CR0_PG),
	LDT(RSC_SYS_REGS_CR0),
	LDT(RSC_SYS_REG_CR0_PE),
	LDT(RSC_SYS_REG_CR0_MP),
	LDT(RSC_SYS_REG_CR0_EM),
	LDT(RSC_SYS_REG_CR0_TS),
	LDT(RSC_SYS_REG_CR0_ET),
	LDT(RSC_SYS_REG_CR0_NE),
	LDT(RSC_SYS_REG_CR0_WP),
	LDT(RSC_SYS_REG_CR0_AM),
	LDT(RSC_SYS_REG_CR0_NW),
	LDT(RSC_SYS_REG_CR0_CD),
	LDT(RSC_SYS_REG_CR0_PG),
	LDQ(RSC_SYS_REG_HDR_CR3),
	LDQ(RSC_SYS_REG_HDR_CR3_PWT),
	LDQ(RSC_SYS_REG_HDR_CR3_PCD),
	LDQ(RSC_SYS_REG_HDR_CR3_U57),
	LDQ(RSC_SYS_REG_HDR_CR3_U48),
	LDT(RSC_SYS_REGS_CR3),
	LDT(RSC_SYS_REG_CR3_PWT),
	LDT(RSC_SYS_REG_CR3_PCD),
	LDT(RSC_SYS_REG_CR3_U57),
	LDT(RSC_SYS_REG_CR3_U48),
	LDQ(RSC_SYS_REG_HDR_CR4),
	LDQ(RSC_SYS_REG_HDR_CR4_VME),
	LDQ(RSC_SYS_REG_HDR_CR4_PVI),
	LDQ(RSC_SYS_REG_HDR_CR4_TSD),
	LDQ(RSC_SYS_REG_HDR_CR4_DE),
	LDQ(RSC_SYS_REG_HDR_CR4_PSE),
	LDQ(RSC_SYS_REG_HDR_CR4_PAE),
	LDQ(RSC_SYS_REG_HDR_CR4_MCE),
	LDQ(RSC_SYS_REG_HDR_CR4_PGE),
	LDQ(RSC_SYS_REG_HDR_CR4_PCE),
	LDQ(RSC_SYS_REG_HDR_CR4_FX),
	LDQ(RSC_SYS_REG_HDR_CR4_XMM),
	LDQ(RSC_SYS_REG_HDR_CR4_UMIP),
	LDQ(RSC_SYS_REG_HDR_CR4_5LP),
	LDQ(RSC_SYS_REG_HDR_CR4_VMX),
	LDQ(RSC_SYS_REG_HDR_CR4_SMX),
	LDQ(RSC_SYS_REG_HDR_CR4_FS),
	LDQ(RSC_SYS_REG_HDR_CR4_PCID),
	LDQ(RSC_SYS_REG_HDR_CR4_SAV),
	LDQ(RSC_SYS_REG_HDR_CR4_KL),
	LDQ(RSC_SYS_REG_HDR_CR4_SME),
	LDQ(RSC_SYS_REG_HDR_CR4_SMA),
	LDQ(RSC_SYS_REG_HDR_CR4_PKE),
	LDQ(RSC_SYS_REG_HDR_CR4_CET),
	LDQ(RSC_SYS_REG_HDR_CR4_PKS),
	LDQ(RSC_SYS_REG_HDR_CR4_UINTR),
	LDQ(RSC_SYS_REG_HDR_CR4_LAM),
	LDQ(RSC_SYS_REG_HDR_CR4_FRED),
	LDT(RSC_SYS_REGS_CR4),
	LDT(RSC_SYS_REG_CR4_VME),
	LDT(RSC_SYS_REG_CR4_PVI),
	LDT(RSC_SYS_REG_CR4_TSD),
	LDT(RSC_SYS_REG_CR4_DE),
	LDT(RSC_SYS_REG_CR4_PSE),
	LDT(RSC_SYS_REG_CR4_PAE),
	LDT(RSC_SYS_REG_CR4_MCE),
	LDT(RSC_SYS_REG_CR4_PGE),
	LDT(RSC_SYS_REG_CR4_PCE),
	LDT(RSC_SYS_REG_CR4_FX),
	LDT(RSC_SYS_REG_CR4_XMM),
	LDT(RSC_SYS_REG_CR4_UMIP),
	LDT(RSC_SYS_REG_CR4_5LP),
	LDT(RSC_SYS_REG_CR4_VMX),
	LDT(RSC_SYS_REG_CR4_SMX),
	LDT(RSC_SYS_REG_CR4_FS),
	LDT(RSC_SYS_REG_CR4_PCID),
	LDT(RSC_SYS_REG_CR4_SAV),
	LDT(RSC_SYS_REG_CR4_KL),
	LDT(RSC_SYS_REG_CR4_SME),
	LDT(RSC_SYS_REG_CR4_SMA),
	LDT(RSC_SYS_REG_CR4_PKE),
	LDT(RSC_SYS_REG_CR4_CET),
	LDT(RSC_SYS_REG_CR4_PKS),
	LDT(RSC_SYS_REG_CR4_UINTR),
	LDT(RSC_SYS_REG_CR4_LAM),
	LDT(RSC_SYS_REG_CR4_FRED),
	LDQ(RSC_SYS_REG_HDR_CR8),
	LDQ(RSC_SYS_REG_HDR_CR8_TPL),
	LDT(RSC_SYS_REGS_CR8),
	LDT(RSC_SYS_REG_CR8_TPL),
	LDQ(RSC_SYS_REG_HDR_EFCR),
	LDQ(RSC_SYS_REG_HDR_EFCR_LCK),
	LDQ(RSC_SYS_REG_HDR_EFCR_VMX),
	LDQ(RSC_SYS_REG_HDR_EFCR_SGX),
	LDQ(RSC_SYS_REG_HDR_EFCR_LSE),
	LDQ(RSC_SYS_REG_HDR_EFCR_GSE),
	LDQ(RSC_SYS_REG_HDR_EFCR_LSGX),
	LDQ(RSC_SYS_REG_HDR_EFCR_GSGX),
	LDQ(RSC_SYS_REG_HDR_EFCR_LMC),
	LDT(RSC_SYS_REGS_EFCR),
	LDT(RSC_SYS_REG_EFCR_LCK),
	LDT(RSC_SYS_REG_EFCR_VMX),
	LDT(RSC_SYS_REG_EFCR_SGX),
	LDT(RSC_SYS_REG_EFCR_LSE),
	LDT(RSC_SYS_REG_EFCR_GSE),
	LDT(RSC_SYS_REG_EFCR_LSGX),
	LDT(RSC_SYS_REG_EFCR_GSGX),
	LDT(RSC_SYS_REG_EFCR_LMC),
	LDQ(RSC_SYS_REG_HDR_EFER),
	LDQ(RSC_SYS_REG_HDR_EFER_SCE),
	LDQ(RSC_SYS_REG_HDR_EFER_LME),
	LDQ(RSC_SYS_REG_HDR_EFER_LMA),
	LDQ(RSC_SYS_REG_HDR_EFER_NXE),
	LDQ(RSC_SYS_REG_HDR_EFER_SVM),
	LDQ(RSC_SYS_REG_HDR_EFER_LMS),
	LDQ(RSC_SYS_REG_HDR_EFER_FFX),
	LDQ(RSC_SYS_REG_HDR_EFER_TCE),
	LDQ(RSC_SYS_REG_HDR_EFER_MCM),
	LDQ(RSC_SYS_REG_HDR_EFER_WBI),
	LDQ(RSC_SYS_REG_HDR_EFER_UAI),
	LDQ(RSC_SYS_REG_HDR_EFER_IBRS),
	LDT(RSC_SYS_REGS_EFER),
	LDT(RSC_SYS_REG_EFER_SCE),
	LDT(RSC_SYS_REG_EFER_LME),
	LDT(RSC_SYS_REG_EFER_LMA),
	LDT(RSC_SYS_REG_EFER_NXE),
	LDT(RSC_SYS_REG_EFER_SVM),
	LDT(RSC_SYS_REG_EFER_LMS),
	LDT(RSC_SYS_REG_EFER_FFX),
	LDT(RSC_SYS_REG_EFER_TCE),
	LDT(RSC_SYS_REG_EFER_MCM),
	LDT(RSC_SYS_REG_EFER_WBI),
	LDT(RSC_SYS_REG_EFER_UAI),
	LDT(RSC_SYS_REG_EFER_IBRS),
	LDQ(RSC_SYS_REG_HDR_XCR0),
	LDQ(RSC_SYS_REG_HDR_XCR0_FPU),
	LDQ(RSC_SYS_REG_HDR_XCR0_SSE),
	LDQ(RSC_SYS_REG_HDR_XCR0_AVX),
	LDQ(RSC_SYS_REG_HDR_XCR0_MPX),
	LDQ(RSC_SYS_REG_HDR_XCR0_512),
	LDQ(RSC_SYS_REG_HDR_XCR0_MPK),
	LDQ(RSC_SYS_REG_HDR_XCR0_CEU),
	LDQ(RSC_SYS_REG_HDR_XCR0_CES),
	LDQ(RSC_SYS_REG_HDR_XCR0_AMX),
	LDQ(RSC_SYS_REG_HDR_XCR0_APX),
	LDQ(RSC_SYS_REG_HDR_XCR0_LWP),
	LDT(RSC_SYS_REGS_XCR0),
	LDT(RSC_SYS_REG_XCR0_FPU),
	LDT(RSC_SYS_REG_XCR0_SSE),
	LDT(RSC_SYS_REG_XCR0_AVX),
	LDT(RSC_SYS_REG_XCR0_MPX),
	LDT(RSC_SYS_REG_XCR0_512),
	LDT(RSC_SYS_REG_XCR0_MPK),
	LDT(RSC_SYS_REG_XCR0_CEU),
	LDT(RSC_SYS_REG_XCR0_CES),
	LDT(RSC_SYS_REG_XCR0_AMX),
	LDT(RSC_SYS_REG_XCR0_APX),
	LDT(RSC_SYS_REG_XCR0_LWP),
	LDQ(RSC_SYS_REG_HDR_CFG),
	LDQ(RSC_SYS_REG_HDR_CFG_MFD),
	LDQ(RSC_SYS_REG_HDR_CFG_MFDM),
	LDQ(RSC_SYS_REG_HDR_CFG_MVDM),
	LDQ(RSC_SYS_REG_HDR_CFG_TOM2),
	LDQ(RSC_SYS_REG_HDR_CFG_FWB),
	LDQ(RSC_SYS_REG_HDR_CFG_MEM),
	LDQ(RSC_SYS_REG_HDR_CFG_SNP),
	LDQ(RSC_SYS_REG_HDR_CFG_VMPL),
	LDQ(RSC_SYS_REG_HDR_CFG_HMK),
	LDT(RSC_SYS_REGS_CFG),
	LDT(RSC_SYS_REG_CFG_MFD),
	LDT(RSC_SYS_REG_CFG_MFDM),
	LDT(RSC_SYS_REG_CFG_MVDM),
	LDT(RSC_SYS_REG_CFG_TOM2),
	LDT(RSC_SYS_REG_CFG_FWB),
	LDT(RSC_SYS_REG_CFG_MEM),
	LDT(RSC_SYS_REG_CFG_SNP),
	LDT(RSC_SYS_REG_CFG_VMPL),
	LDT(RSC_SYS_REG_CFG_HMK),
	LDQ(RSC_SYS_REG_HDR_HWCR),
	LDQ(RSC_SYS_REG_HDR_HWCR_SMM),
	LDQ(RSC_SYS_REG_HDR_HWCR_SLW),
	LDQ(RSC_SYS_REG_HDR_HWCR_TLB),
	LDQ(RSC_SYS_REG_HDR_HWCR_WBI),
	LDQ(RSC_SYS_REG_HDR_HWCR_FF),
	LDQ(RSC_SYS_REG_HDR_HWCR_FRR),
	LDQ(RSC_SYS_REG_HDR_HWCR_IG),
	LDQ(RSC_SYS_REG_HDR_HWCR_SMW),
	LDQ(RSC_SYS_REG_HDR_HWCR_UMW),
	LDQ(RSC_SYS_REG_HDR_HWCR_HLT),
	LDQ(RSC_SYS_REG_HDR_HWCR_SMI),
	LDQ(RSC_SYS_REG_HDR_HWCR_RSM),
	LDQ(RSC_SYS_REG_HDR_HWCR_SSE),
	LDQ(RSC_SYS_REG_HDR_HWCR_WRP),
	LDQ(RSC_SYS_REG_HDR_HWCR_MC),
	LDQ(RSC_SYS_REG_HDR_HWCR_IO),
	LDQ(RSC_SYS_REG_HDR_HWCR_P0),
	LDQ(RSC_SYS_REG_HDR_HWCR_PRB),
	LDQ(RSC_SYS_REG_HDR_HWCR_INC),
	LDQ(RSC_SYS_REG_HDR_HWCR_CPB),
	LDQ(RSC_SYS_REG_HDR_HWCR_HCF),
	LDQ(RSC_SYS_REG_HDR_HWCR_ROC),
	LDQ(RSC_SYS_REG_HDR_HWCR_SMU),
	LDQ(RSC_SYS_REG_HDR_HWCR_CSE),
	LDQ(RSC_SYS_REG_HDR_HWCR_IR),
	LDQ(RSC_SYS_REG_HDR_HWCR_SBR),
	LDQ(RSC_SYS_REG_HDR_HWCR_TPR),
	LDQ(RSC_SYS_REG_HDR_HWCR_PG),
	LDQ(RSC_SYS_REG_HDR_HWCR_ID),
	LDT(RSC_SYS_REGS_HWCR),
	LDT(RSC_SYS_REG_HWCR_SMM),
	LDT(RSC_SYS_REG_HWCR_SLW),
	LDT(RSC_SYS_REG_HWCR_TLB),
	LDT(RSC_SYS_REG_HWCR_WBI),
	LDT(RSC_SYS_REG_HWCR_FF),
	LDT(RSC_SYS_REG_HWCR_FRR),
	LDT(RSC_SYS_REG_HWCR_IG),
	LDT(RSC_SYS_REG_HWCR_SMW),
	LDT(RSC_SYS_REG_HWCR_UMW),
	LDT(RSC_SYS_REG_HWCR_HLT),
	LDT(RSC_SYS_REG_HWCR_SMI),
	LDT(RSC_SYS_REG_HWCR_RSM),
	LDT(RSC_SYS_REG_HWCR_SSE),
	LDT(RSC_SYS_REG_HWCR_WRP),
	LDT(RSC_SYS_REG_HWCR_MC),
	LDT(RSC_SYS_REG_HWCR_IO),
	LDT(RSC_SYS_REG_HWCR_P0),
	LDT(RSC_SYS_REG_HWCR_PRB),
	LDT(RSC_SYS_REG_HWCR_INC),
	LDT(RSC_SYS_REG_HWCR_CPB),
	LDT(RSC_SYS_REG_HWCR_HCF),
	LDT(RSC_SYS_REG_HWCR_ROC),
	LDT(RSC_SYS_REG_HWCR_SMU),
	LDT(RSC_SYS_REG_HWCR_CSE),
	LDT(RSC_SYS_REG_HWCR_IR),
	LDT(RSC_SYS_REG_HWCR_SBR),
	LDT(RSC_SYS_REG_HWCR_TPR),
	LDT(RSC_SYS_REG_HWCR_PG),
	LDT(RSC_SYS_REG_HWCR_ID),
	LDT(RSC_ISA_TITLE),
	LDQ(RSC_ISA_3DNOW),
	LDT(RSC_ISA_3DNOW_COMM),
	LDQ(RSC_ISA_ADX),
	LDT(RSC_ISA_ADX_COMM),
	LDQ(RSC_ISA_AES),
	LDT(RSC_ISA_AES_COMM),
	LDQ(RSC_ISA_AMX_BF16),
	LDT(RSC_ISA_AMX_BF16_COMM),
	LDQ(RSC_ISA_AMX_TILE),
	LDT(RSC_ISA_AMX_TILE_COMM),
	LDQ(RSC_ISA_AMX_INT8),
	LDT(RSC_ISA_AMX_INT8_COMM),
	LDQ(RSC_ISA_AMX_FP16),
	LDT(RSC_ISA_AMX_FP16_COMM),
	LDQ(RSC_ISA_AVX),
	LDT(RSC_ISA_AVX_COMM),
	LDQ(RSC_ISA_AVX512_F),
	LDQ(RSC_ISA_AVX512_DQ),
	LDQ(RSC_ISA_AVX512_IFMA),
	LDQ(RSC_ISA_AVX512_PF),
	LDQ(RSC_ISA_AVX512_ER),
	LDQ(RSC_ISA_AVX512_CD),
	LDQ(RSC_ISA_AVX512_BW),
	LDQ(RSC_ISA_AVX512_VL),
	LDQ(RSC_ISA_AVX512_VBMI),
	LDQ(RSC_ISA_AVX512_VBMI2),
	LDQ(RSC_ISA_AVX512_VNNI),
	LDQ(RSC_ISA_AVX512_ALG),
	LDQ(RSC_ISA_AVX512_VPOP),
	LDQ(RSC_ISA_AVX512_VNNIW),
	LDQ(RSC_ISA_AVX512_FMAPS),
	LDQ(RSC_ISA_AVX512_VP2I),
	LDQ(RSC_ISA_AVX512_BF16),
	LDQ(RSC_ISA_AVX_VEX),
	LDQ(RSC_ISA_AVX_INT8),
	LDQ(RSC_ISA_AVX_NE_CONV),
	LDQ(RSC_ISA_AVX_128),
	LDQ(RSC_ISA_AVX_256),
	LDQ(RSC_ISA_AVX_IFMA),
	LDQ(RSC_ISA_CMPCCXADD),
	LDT(RSC_ISA_CMPCCXADD_COMM),
	LDQ(RSC_ISA_BMI),
	LDT(RSC_ISA_BMI_COMM),
	LDQ(RSC_ISA_CLWB),
	LDT(RSC_ISA_CLWB_COMM),
	LDQ(RSC_ISA_CLFLUSH),
	LDT(RSC_ISA_CLFLUSH_COMM),
	LDQ(RSC_ISA_CLFLUSHOPT),
	LDT(RSC_ISA_CLFLUSHOPT_COMM),
	LDQ(RSC_ISA_AC_FLAG),
	LDT(RSC_ISA_AC_FLAG_COMM),
	LDQ(RSC_ISA_CMOV),
	LDT(RSC_ISA_CMOV_COMM),
	LDQ(RSC_ISA_XCHG8B),
	LDT(RSC_ISA_XCHG8B_COMM),
	LDQ(RSC_ISA_XCHG16B),
	LDT(RSC_ISA_XCHG16B_COMM),
	LDQ(RSC_ISA_F16C),
	LDT(RSC_ISA_F16C_COMM),
	LDQ(RSC_ISA_FPU),
	LDT(RSC_ISA_FPU_COMM),
	LDQ(RSC_ISA_FXSR),
	LDT(RSC_ISA_FXSR_COMM),
	LDQ(RSC_ISA_LSHF),
	LDT(RSC_ISA_LSHF_COMM),
	LDQ(RSC_ISA_MMX),
	LDT(RSC_ISA_MMX_COMM),
	LDQ(RSC_ISA_MWAITX),
	LDT(RSC_ISA_MWAITX_COMM),
	LDQ(RSC_ISA_MOVBE),
	LDT(RSC_ISA_MOVBE_COMM),
	LDQ(RSC_ISA_PCLMULDQ),
	LDT(RSC_ISA_PCLMULDQ_COMM),
	LDQ(RSC_ISA_POPCNT),
	LDT(RSC_ISA_POPCNT_COMM),
	LDQ(RSC_ISA_RDRAND),
	LDT(RSC_ISA_RDRAND_COMM),
	LDQ(RSC_ISA_RDSEED),
	LDT(RSC_ISA_RDSEED_COMM),
	LDQ(RSC_ISA_RDTSCP),
	LDT(RSC_ISA_RDTSCP_COMM),
	LDQ(RSC_ISA_SEP),
	LDT(RSC_ISA_SEP_COMM),
	LDQ(RSC_ISA_SHA),
	LDT(RSC_ISA_SHA_COMM),
	LDQ(RSC_ISA_SSE),
	LDT(RSC_ISA_SSE_COMM),
	LDQ(RSC_ISA_SSE2),
	LDT(RSC_ISA_SSE2_COMM),
	LDQ(RSC_ISA_SSE3),
	LDT(RSC_ISA_SSE3_COMM),
	LDQ(RSC_ISA_SSSE3),
	LDT(RSC_ISA_SSSE3_COMM),
	LDQ(RSC_ISA_SSE4_1),
	LDT(RSC_ISA_SSE4_1_COMM),
	LDQ(RSC_ISA_SSE4_2),
	LDT(RSC_ISA_SSE4_2_COMM),
	LDQ(RSC_ISA_SERIALIZE),
	LDT(RSC_ISA_SERIALIZE_COMM),
	LDQ(RSC_ISA_SYSCALL),
	LDT(RSC_ISA_SYSCALL_COMM),
	LDQ(RSC_ISA_RDPID_FMT),
	LDT(RSC_ISA_RDPID_COMM),
	LDQ(RSC_ISA_UMIP),
	LDT(RSC_ISA_UMIP_COMM),
	LDQ(RSC_ISA_SGX),
	LDT(RSC_ISA_SGX_COMM),
	LDQ(RSC_ISA_MOVDIRI),
	LDT(RSC_ISA_MOVDIRI_COMM),
	LDQ(RSC_ISA_MOVDIR64B),
	LDT(RSC_ISA_MOVDIR64B_COMM),
	LDQ(RSC_ISA_VAES),
	LDT(RSC_ISA_VAES_COMM),
	LDQ(RSC_ISA_VPCLMULQDQ),
	LDT(RSC_ISA_VPCLMULQDQ_COMM),
	LDQ(RSC_ISA_PREFETCH),
	LDT(RSC_ISA_PREFETCH_COMM),
	LDQ(RSC_ISA_LZCNT),
	LDT(RSC_ISA_LZCNT_COMM),
	LDQ(RSC_ISA_ENQCMD),
	LDT(RSC_ISA_ENQCMD_COMM),
	LDQ(RSC_ISA_GFNI),
	LDT(RSC_ISA_GFNI_COMM),
	LDQ(RSC_ISA_OSPKE),
	LDT(RSC_ISA_OSPKE_COMM),
	LDQ(RSC_ISA_WAITPKG),
	LDT(RSC_ISA_WAITPKG_COMM),
	LDT(RSC_FEATURES_TITLE),
	LDT(RSC_ON),
	LDT(RSC_OFF),
	LDT(RSC_FMW),
	LDT(RSC_NOT_AVAILABLE),
	LDT(RSC_AUTOMATIC),
	LDT(RSC_UNABLE),
	LDT(RSC_MISSING),
	LDT(RSC_PRESENT),
	LDT(RSC_UNKNOWN),
	LDT(RSC_VARIANT),
	LDT(RSC_INVARIANT),
	LDQ(RSC_XAPIC),
	LDQ(RSC_X2APIC),
	LDT(RSC_FEATURES_1GB_PAGES),
	LDT(RSC_FEATURES_100MHZ),
	LDT(RSC_FEATURES_ACPI),
	LDT(RSC_FEATURES_APIC),
	LDT(RSC_FEATURES_AVIC),
	LDT(RSC_FEATURES_ARAT),
	LDT(RSC_FEATURES_ALTMOV),
	LDT(RSC_FEATURES_CLZERO),
	LDT(RSC_FEATURES_CORE_MP),
	LDT(RSC_FEATURES_CNXT_ID),
	LDT(RSC_FEATURES_CPPC),
	LDT(RSC_FEATURES_DCA),
	LDT(RSC_FEATURES_DE),
	LDT(RSC_FEATURES_DS_PEBS),
	LDT(RSC_FEATURES_DS_CPL),
	LDT(RSC_FEATURES_DTES_64),
	LDT(RSC_FEATURES_FSRC),
	LDT(RSC_FEATURES_FSRM),
	LDT(RSC_FEATURES_FSRS),
	LDT(RSC_FEATURES_FZRM),
	LDT(RSC_FEATURES_ERMS),
	LDT(RSC_FEATURES_FMA),
	LDT(RSC_FEATURES_FRED),
	LDT(RSC_FEATURES_HFI),
	LDT(RSC_FEATURES_HLE),
	LDT(RSC_FEATURES_HTT),
	LDT(RSC_FEATURES_HwP),
	LDT(RSC_FEATURES_HRESET),
	LDT(RSC_FEATURES_HYBRID),
	LDT(RSC_FEATURES_IBS),
	LDT(RSC_FEATURES_INVLPGB),
	LDT(RSC_FEATURES_INVPCID),
	LDT(RSC_FEATURES_LM),
	LDT(RSC_FEATURES_LASS),
	LDT(RSC_FEATURES_LAM),
	LDT(RSC_FEATURES_LKGS),
	LDT(RSC_FEATURES_LWP),
	LDT(RSC_FEATURES_MBE),
	LDT(RSC_FEATURES_MCA),
	LDT(RSC_FEATURES_MCOMMIT),
	LDT(RSC_FEATURES_MPX),
	LDT(RSC_FEATURES_MSR),
	LDT(RSC_FEATURES_MTRR),
	LDT(RSC_FEATURES_NX),
	LDT(RSC_FEATURES_OSXSAVE),
	LDT(RSC_FEATURES_OSVW),
	LDT(RSC_FEATURES_PAE),
	LDT(RSC_FEATURES_PAT),
	LDT(RSC_FEATURES_PBE),
	LDT(RSC_FEATURES_PCONFIG),
	LDT(RSC_FEATURES_PCID),
	LDT(RSC_FEATURES_PDCM),
	LDT(RSC_FEATURES_PGE),
	LDT(RSC_FEATURES_PSE),
	LDT(RSC_FEATURES_PSE36),
	LDT(RSC_FEATURES_PSN),
	LDT(RSC_FEATURES_PTWRITE),
	LDT(RSC_FEATURES_PREFETCHI),
	LDT(RSC_FEATURES_RDT_PQE),
	LDT(RSC_FEATURES_RDT_PQM),
	LDT(RSC_FEATURES_RDPRU),
	LDT(RSC_FEATURES_RTM),
	LDT(RSC_FEATURES_SMX),
	LDT(RSC_FEATURES_SELF_SNOOP),
	LDT(RSC_FEATURES_SMAP),
	LDT(RSC_FEATURES_SMEP),
	LDT(RSC_FEATURES_ITD),
	LDT(RSC_FEATURES_TBM),
	LDT(RSC_FEATURES_TCE),
	LDT(RSC_FEATURES_TSC),
	LDT(RSC_FEATURES_TSC_DEADLN),
	LDT(RSC_FEATURES_TSXABORT),
	LDT(RSC_FEATURES_TSXLDTRK),
	LDT(RSC_FEATURES_UMIP),
	LDT(RSC_FEATURES_VME),
	LDT(RSC_FEATURES_VMX),
	LDT(RSC_FEATURES_WBNOINVD),
	LDT(RSC_FEATURES_X2APIC),
	LDT(RSC_FEATURES_X2AVIC),
	LDT(RSC_FEATURES_XD_BIT),
	LDT(RSC_FEATURES_XSAVE),
	LDT(RSC_FEATURES_XTPR),
	LDT(RSC_FEATURES_XOP),
	LDT(RSC_FEAT_SECTION_MECH),
	LDT(RSC_FEAT_SECTION_SEC),
	LDT(RSC_TECHNOLOGIES_TITLE),
	LDT(RSC_TECHNOLOGIES_DCU),
	LDT(RSC_TECHNOLOGIES_ICU),
	LDT(RSC_TECHNOLOGIES_PF),
	LDT(RSC_TECH_L1_HW_PREFETCH),
	LDT(RSC_TECH_L1_HW_IP_PREFETCH),
	LDT(RSC_TECH_L1_NPP_PREFETCH),
	LDT(RSC_TECH_L1_SCRUBBING),
	LDT(RSC_TECH_L2_HW_PREFETCH),
	LDT(RSC_TECH_L2_HW_CL_PREFETCH),
	LDT(RSC_TECH_L2_AMP_PREFETCH),
	LDT(RSC_TECH_L2_NLP_PREFETCH),
	LDT(RSC_TECH_L1_STRIDE_PF),
	LDT(RSC_TECH_L1_REGION_PF),
	LDT(RSC_TECH_L1_BURST_PF),
	LDT(RSC_TECH_L2_STREAM_HW_PF),
	LDT(RSC_TECH_L2_UPDOWN_PF),
	LDT(RSC_TECH_LLC_STREAMER),
	LDT(RSC_TECHNOLOGIES_SMM),
	LDT(RSC_TECH_INTEL_SMM_COMM),
	LDT(RSC_TECH_AMD_SMM_COMM),
	LDT(RSC_TECHNOLOGIES_HTT),
	LDT(RSC_TECHNOLOGIES_EIST),
	LDT(RSC_TECHNOLOGIES_IDA),
	LDT(RSC_TECHNOLOGIES_TURBO),
	LDT(RSC_TECHNOLOGIES_TBMT3),
	LDT(RSC_TECHNOLOGIES_VM),
	LDT(RSC_TECH_INTEL_VMX_COMM),
	LDT(RSC_TECH_AMD_SVM_COMM),
	LDT(RSC_TECHNOLOGIES_IOMMU),
	LDT(RSC_TECH_INTEL_VTD_COMM),
	LDT(RSC_TECH_AMD_V_COMM),
	LDT(RSC_TECHNOLOGIES_SMT),
	LDT(RSC_TECHNOLOGIES_CNQ),
	LDT(RSC_TECHNOLOGIES_CPB),
	LDT(RSC_TECH_AMD_CPB_COMM),
	LDT(RSC_TECHNOLOGIES_EEO),
	LDT(RSC_TECH_INTEL_EEO_COMM),
	LDT(RSC_TECHNOLOGIES_R2H),
	LDT(RSC_TECH_INTEL_R2H_COMM),
	LDT(RSC_TECHNOLOGIES_HYPERV),
	LDT(RSC_TECHNOLOGIES_WDT),
	LDT(RSC_TECH_INTEL_WDT_COMM),
	LDT(RSC_TECH_AMD_WDT_COMM),
	LDQ(RSC_TECH_HYPERV_NONE),
	LDQ(RSC_TECH_BARE_METAL),
	LDQ(RSC_TECH_HYPERV_XEN),
	LDQ(RSC_TECH_HYPERV_KVM),
	LDQ(RSC_TECH_HYPERV_VBOX),
	LDQ(RSC_TECH_HYPERV_KBOX),
	LDQ(RSC_TECH_HYPERV_VMWARE),
	LDQ(RSC_TECH_HYPERV_HYPERV),
	LDT(RSC_TECHNOLOGIES_VMD),
	LDT(RSC_TECHNOLOGIES_GNA),
	LDT(RSC_TECHNOLOGIES_HDCP),
	LDT(RSC_TECH_HDCP_COMM),
	LDT(RSC_TECHNOLOGIES_IPU),
	LDT(RSC_TECHNOLOGIES_VPU),
	LDT(RSC_TECHNOLOGIES_OC),
	LDT(RSC_TECH_OC_COMM),
	LDT(RSC_PERF_MON_TITLE),
	LDT(RSC_PERF_CAPS_TITLE),
	LDT(RSC_VERSION),
	LDT(RSC_COUNTERS),
	LDT(RSC_GENERAL_CTRS),
	LDT(RSC_FIXED_CTRS),
	LDT(RSC_PERF_MON_UNIT_BIT),
	LDT(RSC_PERF_MON_C1E),
	LDT(RSC_PERF_MON_C1A),
	LDT(RSC_PERF_MON_C3A),
	LDT(RSC_PERF_MON_C1U),
	LDT(RSC_PERF_MON_C2U),
	LDT(RSC_PERF_MON_C3U),
	LDT(RSC_PERF_MON_C6D),
	LDT(RSC_PERF_MON_MC6),
	LDT(RSC_PERF_MON_CC6),
	LDT(RSC_PERF_MON_PC6),
	LDT(RSC_PERF_MON_FID),
	LDT(RSC_PERF_MON_VID),
	LDT(RSC_PERF_MON_HWCF),
	LDT(RSC_PERF_MON_CPPC),
	LDT(RSC_PERF_MON_PCT),
	LDT(RSC_PERF_MON_PSS),
	LDT(RSC_PERF_MON_PPC),
	LDT(RSC_PERF_MON_CPC),
	LDT(RSC_PERF_MON_CST),
	LDT(RSC_PERF_MON_HWP),
	LDT(RSC_PERF_MON_HDC),
	LDT(RSC_PERF_MON_PKG_CSTATE),
	LDT(RSC_PERF_MON_CORE_CSTATE),
	LDT(RSC_PERF_MON_CFG_CTRL),
	LDT(RSC_PERF_MON_LOW_CSTATE),
	LDT(RSC_PERF_MON_IOMWAIT),
	LDT(RSC_PERF_MON_MAX_CSTATE),
	LDT(RSC_PERF_MON_CSTATE_BAR),
	LDT(RSC_PERF_MON_MONITOR_MWAIT),
	LDT(RSC_PERF_MON_MWAIT_IDX_CSTATE),
	LDT(RSC_PERF_MON_MWAIT_SUB_CSTATE),
	LDT(RSC_PERF_MON_MWAIT_EMX_MWAIT),
	LDT(RSC_PERF_MON_MWAIT_IBE_MWAIT),
	LDT(RSC_PERF_MON_CORE_CYCLE),
	LDT(RSC_PERF_MON_INST_RET),
	LDT(RSC_PERF_MON_REF_CYCLE),
	LDT(RSC_PERF_MON_REF_LLC),
	LDT(RSC_PERF_MON_MISS_LLC),
	LDT(RSC_PERF_MON_BRANCH_RET),
	LDT(RSC_PERF_MON_BRANCH_MIS),
	LDT(RSC_PERF_MON_TOPDOWN_SLOTS),
	LDT(RSC_PERF_MON_TSC),
	LDT(RSC_PERF_MON_NB_DF),
	LDT(RSC_PERF_MON_CORE),
	LDT(RSC_PERF_MON_PMC_COMM),
	LDT(RSC_PERF_MON_CPPC_COMM),
	LDQ(RSC_PERF_LABEL_VER),
	LDQ(RSC_PERF_LABEL_C1E),
	LDQ(RSC_PERF_LABEL_C1A),
	LDQ(RSC_PERF_LABEL_C3A),
	LDQ(RSC_PERF_LABEL_C1U),
	LDQ(RSC_PERF_LABEL_C2U),
	LDQ(RSC_PERF_LABEL_C3U),
	LDQ(RSC_PERF_LABEL_CC6),
	LDQ(RSC_PERF_LABEL_PC6),
	LDQ(RSC_PERF_LABEL_MC6),
	LDQ(RSC_PERF_LABEL_FID),
	LDQ(RSC_PERF_LABEL_VID),
	LDQ(RSC_PERF_LABEL_HWCF),
	LDQ(RSC_PERF_LABEL_CPPC),
	LDQ(RSC_PERF_LABEL_PCT),
	LDQ(RSC_PERF_LABEL_PSS),
	LDQ(RSC_PERF_LABEL_PPC),
	LDQ(RSC_PERF_LABEL_CPC),
	LDQ(RSC_PERF_LABEL_CST),
	LDQ(RSC_PERF_LABEL_EMX),
	LDQ(RSC_PERF_LABEL_IBE),
	LDQ(RSC_PERF_LABEL_HWP),
	LDQ(RSC_PERF_LABEL_HDC),
	LDQ(RSC_PERF_LABEL_CFG_CTRL),
	LDQ(RSC_PERF_LABEL_LOW_CST),
	LDQ(RSC_PERF_LABEL_IOMWAIT),
	LDQ(RSC_PERF_LABEL_MAX_CST),
	LDQ(RSC_PERF_LABEL_CST_BAR),
	LDQ(RSC_PERF_LABEL_MWAIT_IDX),
	LDQ(RSC_PERF_ENCODING_C0),
	LDQ(RSC_PERF_ENCODING_C1),
	LDQ(RSC_PERF_ENCODING_C2),
	LDQ(RSC_PERF_ENCODING_C3),
	LDQ(RSC_PERF_ENCODING_C4),
	LDQ(RSC_PERF_ENCODING_C6),
	LDQ(RSC_PERF_ENCODING_C6R),
	LDQ(RSC_PERF_ENCODING_C7),
	LDQ(RSC_PERF_ENCODING_C7S),
	LDQ(RSC_PERF_ENCODING_C8),
	LDQ(RSC_PERF_ENCODING_C9),
	LDQ(RSC_PERF_ENCODING_C10),
	LDQ(RSC_PERF_ENCODING_UNS),
	LDT(RSC_POWER_THERMAL_TITLE),
	LDT(RSC_POWER_THERMAL_ODCM),
	LDT(RSC_POWER_THERMAL_DUTY),
	LDT(RSC_POWER_THERMAL_MGMT),
	LDT(RSC_POWER_THERMAL_BIAS),
	LDT(RSC_POWER_THERMAL_CPPC),
	LDT(RSC_POWER_THERMAL_TJMAX),
	LDT(RSC_POWER_THERMAL_DTS),
	LDT(RSC_POWER_THERMAL_PLN),
	LDT(RSC_POWER_THERMAL_PTM),
	LDT(RSC_POWER_THERMAL_TM1),
	LDT(RSC_POWER_THERMAL_TM2),
	LDT(RSC_POWER_THERMAL_UNITS),
	LDT(RSC_POWER_THERMAL_POWER),
	LDT(RSC_POWER_THERMAL_ENERGY),
	LDT(RSC_POWER_THERMAL_WINDOW),
	LDT(RSC_POWER_THERMAL_WATT),
	LDT(RSC_POWER_THERMAL_JOULE),
	LDT(RSC_POWER_THERMAL_SECOND),
	LDT(RSC_POWER_THERMAL_TDP),
	LDT(RSC_POWER_THERMAL_MIN),
	LDT(RSC_POWER_THERMAL_MAX),
	LDT(RSC_POWER_THERMAL_PPT),
	LDT(RSC_POWER_THERMAL_TPL),
	LDT(RSC_POWER_THERMAL_TW),
	LDT(RSC_POWER_THERMAL_EDC),
	LDT(RSC_POWER_THERMAL_TDC),
	LDT(RSC_POWER_THERMAL_POINT),
	LDT(RSC_THERMAL_POINT_THRESHOLD),
	LDT(RSC_THERMAL_POINT_LIMIT),
	LDT(RSC_THERMAL_POINT_THRESHOLD_1),
	LDT(RSC_THERMAL_POINT_THRESHOLD_2),
	LDT(RSC_THERMAL_POINT_TRIP_LIMIT),
	LDT(RSC_THERMAL_POINT_HTC_LIMIT),
	LDT(RSC_THERMAL_POINT_HTC_HYST),
	LDT(RSC_THERMAL_OFFSET_TITLE),
	LDQ(RSC_POWER_LABEL_ODCM),
	LDQ(RSC_POWER_LABEL_PWM),
	LDQ(RSC_POWER_LABEL_CPPC),
	LDQ(RSC_POWER_LABEL_BIAS),
	LDQ(RSC_POWER_LABEL_EPP),
	LDQ(RSC_POWER_LABEL_TJ),
	LDQ(RSC_POWER_LABEL_DTS),
	LDQ(RSC_POWER_LABEL_PLN),
	LDQ(RSC_POWER_LABEL_PTM),
	LDQ(RSC_POWER_LABEL_TM1),
	LDQ(RSC_POWER_LABEL_TM2),
	LDQ(RSC_POWER_LABEL_TTP),
	LDQ(RSC_POWER_LABEL_HTC),
	LDQ(RSC_POWER_LABEL_TDP),
	LDQ(RSC_POWER_LABEL_MIN),
	LDQ(RSC_POWER_LABEL_MAX),
	LDQ(RSC_POWER_LABEL_PPT),
	LDQ(RSC_POWER_LABEL_PL1),
	LDQ(RSC_POWER_LABEL_PL2),
	LDQ(RSC_POWER_LABEL_TW1),
	LDQ(RSC_POWER_LABEL_TW2),
	LDQ(RSC_POWER_LABEL_EDC),
	LDQ(RSC_POWER_LABEL_TDC),
	LDQ(RSC_POWER_LABEL_PKG),
	LDQ(RSC_POWER_LABEL_CORE),
	LDQ(RSC_POWER_LABEL_UNCORE),
	LDQ(RSC_POWER_LABEL_DRAM),
	LDQ(RSC_POWER_LABEL_PLATFORM),
	LDT(RSC_KERNEL_TITLE),
	LDC(RSC_KERNEL_TOTAL_RAM, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_SHARED_RAM, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_FREE_RAM, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_BUFFER_RAM, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_TOTAL_HIGH, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_FREE_HIGH, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_GOVERNOR, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_FREQ_DRIVER, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_IDLE_DRIVER, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_CLOCK_SOURCE, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_RELEASE, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_VERSION, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_MACHINE, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_MEMORY, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_STATE, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_POWER, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_LATENCY, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_RESIDENCY, RSC_SYSINFO_KERNEL),
	LDC(RSC_KERNEL_LIMIT, RSC_SYSINFO_KERNEL),
	LDT(RSC_TOPOLOGY_TITLE),
	LDQ(RSC_TOPOLOGY_FMT0),
	LDQ(RSC_TOPOLOGY_FMT1),
	LDQ(RSC_TOPOLOGY_OFF_0),
	LDQ(RSC_TOPOLOGY_OFF_1),
	LDQ(RSC_TOPOLOGY_OFF_2),
	LDQ(RSC_TOPOLOGY_OFF_3),
	LDQ(RSC_TOPOLOGY_HDR_PKG),
	LDQ(RSC_TOPOLOGY_HDR_SMT),
	LDQ(RSC_TOPOLOGY_HDR_CACHE),
	LDQ(RSC_TOPOLOGY_HDR_WRBAK),
	LDQ(RSC_TOPOLOGY_HDR_INCL),
	LDQ(RSC_TOPOLOGY_HDR_EMPTY),
	LDQ(RSC_TOPOLOGY_SUB_ITEM1),
	LDQ(RSC_TOPOLOGY_SUB_ITEM3),
	LDQ(RSC_TOPOLOGY_SUB_ITEM4),
	LDQ(RSC_TOPOLOGY_SUB_ITEM5),
	LDQ(RSC_TOPOLOGY_SUB_ITEM6),
	LDQ(RSC_TOPOLOGY_ALT_ITEM1),
	LDQ(RSC_TOPOLOGY_ALT_ITEM2),
	LDQ(RSC_TOPOLOGY_ALT_ITEM3),
	LDQ(RSC_TOPOLOGY_ALT_ITEM4),
	LDQ(RSC_TOPOLOGY_BSP_COMM),
	LDT(RSC_MEM_CTRL_TITLE),
	LDQ(RSC_MEM_CTRL_UNIT_MHZ),
	LDQ(RSC_MEM_CTRL_UNIT_MTS),
	LDQ(RSC_MEM_CTRL_UNIT_MBS),
	LDQ(RSC_MEM_CTRL_MTY_CELL),
	LDQ(RSC_MEM_CTRL_CHANNEL),
	LDT(RSC_MEM_CTRL_SUBSECT1_0),
	LDT(RSC_MEM_CTRL_SUBSECT1_1),
	LDT(RSC_MEM_CTRL_SUBSECT1_2),
	LDT(RSC_MEM_CTRL_SINGLE_CHA_0),
	LDT(RSC_MEM_CTRL_SINGLE_CHA_1),
	LDT(RSC_MEM_CTRL_SINGLE_CHA_2),
	LDT(RSC_MEM_CTRL_DUAL_CHA_0),
	LDT(RSC_MEM_CTRL_DUAL_CHA_1),
	LDT(RSC_MEM_CTRL_DUAL_CHA_2),
	LDT(RSC_MEM_CTRL_TRIPLE_CHA_0),
	LDT(RSC_MEM_CTRL_TRIPLE_CHA_1),
	LDT(RSC_MEM_CTRL_TRIPLE_CHA_2),
	LDT(RSC_MEM_CTRL_QUAD_CHA_0),
	LDT(RSC_MEM_CTRL_QUAD_CHA_1),
	LDT(RSC_MEM_CTRL_QUAD_CHA_2),
	LDT(RSC_MEM_CTRL_SIX_CHA_0),
	LDT(RSC_MEM_CTRL_SIX_CHA_1),
	LDT(RSC_MEM_CTRL_SIX_CHA_2),
	LDT(RSC_MEM_CTRL_EIGHT_CHA_0),
	LDT(RSC_MEM_CTRL_EIGHT_CHA_1),
	LDT(RSC_MEM_CTRL_EIGHT_CHA_2),
	LDT(RSC_MEM_CTRL_TWELVE_CHA_0),
	LDT(RSC_MEM_CTRL_TWELVE_CHA_1),
	LDT(RSC_MEM_CTRL_TWELVE_CHA_2),
	LDT(RSC_MEM_CTRL_UNDEFINED_0),
	LDT(RSC_MEM_CTRL_UNDEFINED_1),
	LDT(RSC_MEM_CTRL_UNDEFINED_2),
	LDT(RSC_MEM_CTRL_BUS_RATE_0),
	LDT(RSC_MEM_CTRL_BUS_RATE_1),
	LDT(RSC_MEM_CTRL_BUS_SPEED_0),
	LDT(RSC_MEM_CTRL_BUS_SPEED_1),
	LDT(RSC_MEM_CTRL_RAM_STD_0),
	LDT(RSC_MEM_CTRL_RAM_STD_1),
	LDT(RSC_MEM_CTRL_RAM_STD_2),
	LDT(RSC_MEM_CTRL_RAM_STD_3),
	LDT(RSC_MEM_CTRL_DRAM_DDR2_0),
	LDT(RSC_MEM_CTRL_DRAM_DDR3_0),
	LDT(RSC_MEM_CTRL_DRAM_DDR4_0),
	LDT(RSC_MEM_CTRL_DRAM_DDR5_0),
	LDT(RSC_MEM_CTRL_DRAM_SPEED_0),
	LDT(RSC_MEM_CTRL_DRAM_SPEED_1),
	LDT(RSC_MEM_CTRL_SUBSECT2_0),
	LDT(RSC_MEM_CTRL_SUBSECT2_1),
	LDT(RSC_MEM_CTRL_SUBSECT2_2),
	LDT(RSC_MEM_CTRL_SUBSECT2_3),
	LDT(RSC_MEM_CTRL_SUBSECT2_4),
	LDT(RSC_MEM_CTRL_SUBSECT2_5),
	LDT(RSC_MEM_CTRL_DIMM_SLOT),
	LDT(RSC_MEM_CTRL_DIMM_BANK),
	LDT(RSC_MEM_CTRL_DIMM_RANK),
	LDT(RSC_MEM_CTRL_DIMM_ROW),
	LDT(RSC_MEM_CTRL_DIMM_COLUMN0),
	LDT(RSC_MEM_CTRL_DIMM_COLUMN1),
	LDT(RSC_MEM_CTRL_DIMM_SIZE_0),
	LDT(RSC_MEM_CTRL_DIMM_SIZE_1),
	LDT(RSC_MEM_CTRL_DIMM_SIZE_2),
	LDT(RSC_MEM_CTRL_DIMM_SIZE_3),
	LDQ(RSC_DDR3_CL),
	LDQ(RSC_DDR3_RCD),
	LDQ(RSC_DDR3_RP),
	LDQ(RSC_DDR3_RAS),
	LDQ(RSC_DDR3_RRD),
	LDQ(RSC_DDR3_RFC),
	LDQ(RSC_DDR3_WR),
	LDQ(RSC_DDR3_RTP),
	LDQ(RSC_DDR3_WTP),
	LDQ(RSC_DDR3_FAW),
	LDQ(RSC_DDR3_B2B),
	LDQ(RSC_DDR3_CWL),
	LDQ(RSC_DDR3_CMD),
	LDQ(RSC_DDR3_REFI),
	LDQ(RSC_DDR3_DDWRTRD),
	LDQ(RSC_DDR3_DRWRTRD),
	LDQ(RSC_DDR3_SRWRTRD),
	LDQ(RSC_DDR3_DDRDTWR),
	LDQ(RSC_DDR3_DRRDTWR),
	LDQ(RSC_DDR3_SRRDTWR),
	LDQ(RSC_DDR3_DDRDTRD),
	LDQ(RSC_DDR3_DRRDTRD),
	LDQ(RSC_DDR3_SRRDTRD),
	LDQ(RSC_DDR3_DDWRTWR),
	LDQ(RSC_DDR3_DRWRTWR),
	LDQ(RSC_DDR3_SRWRTWR),
	LDQ(RSC_DDR3_XS),
	LDQ(RSC_DDR3_XP),
	LDQ(RSC_DDR3_CKE),
	LDQ(RSC_DDR3_ECC),
	LDQ(RSC_DDR4_CL),
	LDQ(RSC_DDR4_RCD_R),
	LDQ(RSC_DDR4_RCD_W),
	LDQ(RSC_DDR4_RP),
	LDQ(RSC_DDR4_RAS),
	LDQ(RSC_DDR4_RRD),
	LDQ(RSC_DDR4_RFC),
	LDQ(RSC_DDR4_WR),
	LDQ(RSC_DDR4_RTP),
	LDQ(RSC_DDR4_WTP),
	LDQ(RSC_DDR4_FAW),
	LDQ(RSC_DDR4_GEAR),
	LDQ(RSC_DDR4_CWL),
	LDQ(RSC_DDR4_CMD),
	LDQ(RSC_DDR4_REFI),
	LDQ(RSC_DDR4_RDRD_SCL),
	LDQ(RSC_DDR4_RDRD_SC),
	LDQ(RSC_DDR4_RDRD_SD),
	LDQ(RSC_DDR4_RDRD_DD),
	LDQ(RSC_DDR4_RDWR_SCL),
	LDQ(RSC_DDR4_RDWR_SC),
	LDQ(RSC_DDR4_RDWR_SD),
	LDQ(RSC_DDR4_RDWR_DD),
	LDQ(RSC_DDR4_WRRD_SCL),
	LDQ(RSC_DDR4_WRRD_SC),
	LDQ(RSC_DDR4_WRRD_SD),
	LDQ(RSC_DDR4_WRRD_DD),
	LDQ(RSC_DDR4_WRWR_SCL),
	LDQ(RSC_DDR4_WRWR_SC),
	LDQ(RSC_DDR4_WRWR_SD),
	LDQ(RSC_DDR4_WRWR_DD),
	LDQ(RSC_DDR4_RRD_S),
	LDQ(RSC_DDR4_RRD_L),
	LDQ(RSC_DDR4_CKE),
	LDQ(RSC_DDR4_CPDED),
	LDQ(RSC_DDR4_ECC),
	LDQ(RSC_DDR4_ZEN_CL),
	LDQ(RSC_DDR4_ZEN_RP),
	LDQ(RSC_DDR4_ZEN_RAS),
	LDQ(RSC_DDR4_ZEN_RC),
	LDQ(RSC_DDR4_ZEN_FAW),
	LDQ(RSC_DDR4_ZEN_WTR_S),
	LDQ(RSC_DDR4_ZEN_WTR_L),
	LDQ(RSC_DDR4_ZEN_WR),
	LDQ(RSC_DDR4_ZEN_RDRD_SCL),
	LDQ(RSC_DDR4_ZEN_WRWR_SCL),
	LDQ(RSC_DDR4_ZEN_CWL),
	LDQ(RSC_DDR4_ZEN_RTP),
	LDQ(RSC_DDR4_ZEN_RDWR),
	LDQ(RSC_DDR4_ZEN_WRRD),
	LDQ(RSC_DDR4_ZEN_WRWR_SC),
	LDQ(RSC_DDR4_ZEN_WRWR_SD),
	LDQ(RSC_DDR4_ZEN_WRWR_DD),
	LDQ(RSC_DDR4_ZEN_RDRD_SC),
	LDQ(RSC_DDR4_ZEN_RDRD_SD),
	LDQ(RSC_DDR4_ZEN_RDRD_DD),
	LDQ(RSC_DDR4_ZEN_RTR_DLR),
	LDQ(RSC_DDR4_ZEN_WTW_DLR),
	LDQ(RSC_DDR4_ZEN_WTR_DLR),
	LDQ(RSC_DDR4_ZEN_RRD_DLR),
	LDQ(RSC_DDR4_ZEN_REFI),
	LDQ(RSC_DDR4_ZEN_RFC1),
	LDQ(RSC_DDR4_ZEN_RFC2),
	LDQ(RSC_DDR4_ZEN_RFC4),
	LDQ(RSC_DDR4_ZEN_RCPB),
	LDQ(RSC_DDR4_ZEN_RPPB),
	LDQ(RSC_DDR4_ZEN_BGS),
	LDQ(RSC_DDR4_ZEN_BGS_ALT),
	LDQ(RSC_DDR4_ZEN_BAN),
	LDQ(RSC_DDR4_ZEN_RCPAGE),
	LDQ(RSC_DDR4_ZEN_GDM),
	LDQ(RSC_DDR4_ZEN_ECC),
	LDQ(RSC_DDR4_ZEN_MRD),
	LDQ(RSC_DDR4_ZEN_MOD),
	LDQ(RSC_DDR4_ZEN_MRD_PDA),
	LDQ(RSC_DDR4_ZEN_MOD_PDA),
	LDQ(RSC_DDR4_ZEN_WRMPR),
	LDQ(RSC_DDR4_ZEN_STAG),
	LDQ(RSC_DDR4_ZEN_PDM),
	LDQ(RSC_DDR4_ZEN_RDDATA),
	LDQ(RSC_DDR4_ZEN_PHYWRD),
	LDQ(RSC_DDR4_ZEN_PHYWRL),
	LDQ(RSC_DDR4_ZEN_PHYRDL),
	LDQ(RSC_DDR5_ZEN_RFC_SB),
	LDQ(RSC_DDR5_ZEN_RCPB),
	LDQ(RSC_DDR5_ZEN_RPPB),
	LDQ(RSC_DDR5_ZEN_BGS),
	LDT(RSC_DDR3_CL_COMM),
	LDT(RSC_DDR3_RCD_COMM),
	LDT(RSC_DDR3_RP_COMM),
	LDT(RSC_DDR3_RAS_COMM),
	LDT(RSC_DDR3_RRD_COMM),
	LDT(RSC_DDR3_RFC_COMM),
	LDT(RSC_DDR3_WR_COMM),
	LDT(RSC_DDR3_RTP_COMM),
	LDT(RSC_DDR3_WTP_COMM),
	LDT(RSC_DDR3_FAW_COMM),
	LDT(RSC_DDR3_B2B_COMM),
	LDT(RSC_DDR3_CWL_COMM),
	LDT(RSC_DDR3_CMD_COMM),
	LDT(RSC_DDR3_REFI_COMM),
	LDT(RSC_DDR3_DDWRTRD_COMM),
	LDT(RSC_DDR3_DRWRTRD_COMM),
	LDT(RSC_DDR3_SRWRTRD_COMM),
	LDT(RSC_DDR3_DDRDTWR_COMM),
	LDT(RSC_DDR3_DRRDTWR_COMM),
	LDT(RSC_DDR3_SRRDTWR_COMM),
	LDT(RSC_DDR3_DDRDTRD_COMM),
	LDT(RSC_DDR3_DRRDTRD_COMM),
	LDT(RSC_DDR3_SRRDTRD_COMM),
	LDT(RSC_DDR3_DDWRTWR_COMM),
	LDT(RSC_DDR3_DRWRTWR_COMM),
	LDT(RSC_DDR3_SRWRTWR_COMM),
	LDT(RSC_DDR3_XS_COMM),
	LDT(RSC_DDR3_XP_COMM),
	LDT(RSC_DDR3_CKE_COMM),
	LDT(RSC_DDR3_ECC_COMM),
	LDT(RSC_DDR4_RCD_R_COMM),
	LDT(RSC_DDR4_RCD_W_COMM),
	LDT(RSC_DDR4_RDRD_SCL_COMM),
	LDT(RSC_DDR4_RDRD_SC_COMM),
	LDT(RSC_DDR4_RDRD_SD_COMM),
	LDT(RSC_DDR4_RDRD_DD_COMM),
	LDT(RSC_DDR4_RDWR_SCL_COMM),
	LDT(RSC_DDR4_RDWR_SC_COMM),
	LDT(RSC_DDR4_RDWR_SD_COMM),
	LDT(RSC_DDR4_RDWR_DD_COMM),
	LDT(RSC_DDR4_WRRD_SCL_COMM),
	LDT(RSC_DDR4_WRRD_SC_COMM),
	LDT(RSC_DDR4_WRRD_SD_COMM),
	LDT(RSC_DDR4_WRRD_DD_COMM),
	LDT(RSC_DDR4_WRWR_SCL_COMM),
	LDT(RSC_DDR4_WRWR_SC_COMM),
	LDT(RSC_DDR4_WRWR_SD_COMM),
	LDT(RSC_DDR4_WRWR_DD_COMM),
	LDT(RSC_DDR4_RRD_S_COMM),
	LDT(RSC_DDR4_RRD_L_COMM),
	LDT(RSC_DDR4_CPDED_COMM),
	LDT(RSC_DDR4_GEAR_COMM),
	LDT(RSC_DDR4_ZEN_RC_COMM),
	LDT(RSC_DDR4_ZEN_WTR_S_COMM),
	LDT(RSC_DDR4_ZEN_WTR_L_COMM),
	LDT(RSC_DDR4_ZEN_RDRD_SCL_COMM),
	LDT(RSC_DDR4_ZEN_WRWR_SCL_COMM),
	LDT(RSC_DDR4_ZEN_RTP_COMM),
	LDT(RSC_DDR4_ZEN_RDWR_COMM),
	LDT(RSC_DDR4_ZEN_WRRD_COMM),
	LDT(RSC_DDR4_ZEN_WRWR_SC_COMM),
	LDT(RSC_DDR4_ZEN_WRWR_SD_COMM),
	LDT(RSC_DDR4_ZEN_WRWR_DD_COMM),
	LDT(RSC_DDR4_ZEN_RDRD_SC_COMM),
	LDT(RSC_DDR4_ZEN_RDRD_SD_COMM),
	LDT(RSC_DDR4_ZEN_RDRD_DD_COMM),
	LDT(RSC_DDR4_ZEN_RTR_DLR_COMM),
	LDT(RSC_DDR4_ZEN_WTW_DLR_COMM),
	LDT(RSC_DDR4_ZEN_WTR_DLR_COMM),
	LDT(RSC_DDR4_ZEN_RRD_DLR_COMM),
	LDT(RSC_DDR4_ZEN_RFC1_COMM),
	LDT(RSC_DDR4_ZEN_RFC2_COMM),
	LDT(RSC_DDR4_ZEN_RFC4_COMM),
	LDT(RSC_DDR4_ZEN_RCPB_COMM),
	LDT(RSC_DDR4_ZEN_RPPB_COMM),
	LDT(RSC_DDR4_ZEN_BGS_COMM),
	LDT(RSC_DDR4_ZEN_BGS_ALT_COMM),
	LDT(RSC_DDR4_ZEN_BAN_COMM),
	LDT(RSC_DDR4_ZEN_RCPAGE_COMM),
	LDT(RSC_DDR4_ZEN_GDM_COMM),
	LDT(RSC_DDR4_ZEN_MRD_COMM),
	LDT(RSC_DDR4_ZEN_MOD_COMM),
	LDT(RSC_DDR4_ZEN_MRD_PDA_COMM),
	LDT(RSC_DDR4_ZEN_MOD_PDA_COMM),
	LDT(RSC_DDR4_ZEN_WRMPR_COMM),
	LDT(RSC_DDR4_ZEN_STAG_COMM),
	LDT(RSC_DDR4_ZEN_PDM_COMM),
	LDT(RSC_DDR4_ZEN_PHYWRD_COMM),
	LDT(RSC_DDR4_ZEN_PHYWRL_COMM),
	LDT(RSC_DDR4_ZEN_PHYRDL_COMM),
	LDT(RSC_DDR4_ZEN_RDDATA_COMM),
	LDT(RSC_DDR5_ZEN_RFC_SB_COMM),
	LDT(RSC_TASKS_SORTBY_STATE),
	LDT(RSC_TASKS_SORTBY_RTIME),
	LDT(RSC_TASKS_SORTBY_UTIME),
	LDT(RSC_TASKS_SORTBY_STIME),
	LDT(RSC_TASKS_SORTBY_PID),
	LDT(RSC_TASKS_SORTBY_COMM),
	LDS(RSC_MENU_ITEM_MENU),
	LDS(RSC_MENU_ITEM_VIEW),
	LDS(RSC_MENU_ITEM_WINDOW),
	LDT(RSC_MENU_ITEM_SPACER),
	LDT(RSC_MENU_ITEM_DATE_TIME),
	LDT(RSC_MENU_ITEM_FULL_TIME),
	LDT(RSC_MENU_ITEM_TINY_TIME),
	LDT(RSC_MENU_ITEM_SETTINGS),
	LDT(RSC_MENU_ITEM_SMBIOS),
	LDT(RSC_MENU_ITEM_KERNEL),
	LDT(RSC_MENU_ITEM_HOTPLUG),
	LDT(RSC_MENU_ITEM_TOOLS),
	LDT(RSC_MENU_ITEM_THEME),
	LDT(RSC_MENU_ITEM_ABOUT),
	LDT(RSC_MENU_ITEM_HELP),
	LDT(RSC_MENU_ITEM_KEYS),
	LDT(RSC_MENU_ITEM_LANG),
	LDT(RSC_MENU_ITEM_QUIT),
	LDT(RSC_MENU_ITEM_DASHBOARD),
	LDT(RSC_MENU_ITEM_FREQUENCY),
	LDT(RSC_MENU_ITEM_INST_CYCLES),
	LDT(RSC_MENU_ITEM_CORE_CYCLES),
	LDT(RSC_MENU_ITEM_IDLE_STATES),
	LDT(RSC_MENU_ITEM_PKG_CYCLES),
	LDT(RSC_MENU_ITEM_TASKS_MON),
	LDT(RSC_MENU_ITEM_SYS_INTER),
	LDT(RSC_MENU_ITEM_SENSORS),
	LDT(RSC_MENU_ITEM_VOLTAGE),
	LDT(RSC_MENU_ITEM_POWER),
	LDT(RSC_MENU_ITEM_SLICE_CTRS),
	LDT(RSC_MENU_ITEM_CUSTOM),
	LDT(RSC_MENU_ITEM_PROCESSOR),
	LDT(RSC_MENU_ITEM_TOPOLOGY),
	LDT(RSC_MENU_ITEM_FEATURES),
	LDT(RSC_MENU_ITEM_ISA_EXT),
	LDT(RSC_MENU_ITEM_TECH),
	LDT(RSC_MENU_ITEM_PERF_MON),
	LDT(RSC_MENU_ITEM_PERF_CAPS),
	LDT(RSC_MENU_ITEM_POW_THERM),
	LDT(RSC_MENU_ITEM_CPUID),
	LDT(RSC_MENU_ITEM_SYS_REGS),
	LDT(RSC_MENU_ITEM_MEM_CTRL),
	LDT(RSC_MENU_ITEM_EVENTS),
	LDT(RSC_SETTINGS_TITLE),
	LDT(RSC_SETTINGS_DAEMON),
	LDT(RSC_SETTINGS_INTERVAL),
	LDT(RSC_SETTINGS_SYS_TICK),
	LDT(RSC_SETTINGS_POLL_WAIT),
	LDT(RSC_SETTINGS_RING_WAIT),
	LDT(RSC_SETTINGS_CHILD_WAIT),
	LDT(RSC_SETTINGS_SLICE_WAIT),
	LDT(RSC_SETTINGS_RECORDER),
	LDT(RSC_SETTINGS_AUTO_CLOCK),
	LDT(RSC_SETTINGS_EXPERIMENTAL),
	LDT(RSC_SETTINGS_CPU_HOTPLUG),
	LDT(RSC_SETTINGS_PCI_ENABLED),
	LDT(RSC_SETTINGS_HSMP_ENABLED),
	LDT(RSC_SETTINGS_NMI_REGISTERED),
	LDT(RSC_SETTINGS_CPUIDLE_REGISTERED),
	LDT(RSC_SETTINGS_CPUFREQ_REGISTERED),
	LDT(RSC_SETTINGS_GOVERNOR_REGISTERED),
	LDT(RSC_SETTINGS_CS_REGISTERED),
	LDT(RSC_SETTINGS_THERMAL_SCOPE),
	LDT(RSC_SETTINGS_VOLTAGE_SCOPE),
	LDT(RSC_SETTINGS_POWER_SCOPE),
	LDT(RSC_SETTINGS_IDLE_ROUTE),
	LDT(RSC_SETTINGS_ROUTE_TITLE),
	LDQ(RSC_SETTINGS_ROUTE_DFLT),
	LDQ(RSC_SETTINGS_ROUTE_IO),
	LDQ(RSC_SETTINGS_ROUTE_HALT),
	LDQ(RSC_SETTINGS_ROUTE_MWAIT),
	LDT(RSC_HELP_TITLE),
	LDT(RSC_HELP_KEY_ESCAPE),
	LDT(RSC_HELP_KEY_SHIFT_TAB),
	LDT(RSC_HELP_KEY_TAB),
	LDT(RSC_HELP_KEY_UP),
	LDT(RSC_HELP_KEY_LEFT_RIGHT),
	LDT(RSC_HELP_KEY_DOWN),
	LDT(RSC_HELP_KEY_END),
	LDT(RSC_HELP_KEY_HOME),
	LDT(RSC_HELP_KEY_ENTER),
	LDT(RSC_HELP_KEY_PAGE_UP),
	LDT(RSC_HELP_KEY_PAGE_DOWN),
	LDT(RSC_HELP_KEY_MINUS),
	LDT(RSC_HELP_KEY_PLUS),
	LDQ(RSC_HELP_BLANK),
	LDT(RSC_HELP_KEY_MENU),
	LDT(RSC_HELP_MENU),
	LDT(RSC_HELP_CLOSE_WINDOW),
	LDT(RSC_HELP_PREV_WINDOW),
	LDT(RSC_HELP_NEXT_WINDOW),
	LDT(RSC_HELP_KEY_SHIFT_GR1),
	LDT(RSC_HELP_KEY_SHIFT_GR2),
	LDT(RSC_HELP_MOVE_WINDOW),
	LDT(RSC_HELP_KEY_ALT_GR3),
	LDT(RSC_HELP_SIZE_WINDOW),
	LDT(RSC_HELP_MOVE_SELECT),
	LDT(RSC_HELP_LAST_CELL),
	LDT(RSC_HELP_FIRST_CELL),
	LDT(RSC_HELP_TRIGGER_SELECT),
	LDT(RSC_HELP_PREV_PAGE),
	LDT(RSC_HELP_NEXT_PAGE),
	LDT(RSC_HELP_SCROLL_DOWN),
	LDT(RSC_HELP_SCROLL_UP),
	LDT(RSC_ADV_HELP_TITLE),
	LDT(RSC_ADV_HELP_SECT_FREQ),
	LDT(RSC_ADV_HELP_ITEM_AVG),
	LDT(RSC_ADV_HELP_SECT_TASK),
	LDT(RSC_ADV_HELP_ITEM_ORDER),
	LDT(RSC_ADV_HELP_ITEM_RST),
	LDT(RSC_ADV_HELP_ITEM_SEL),
	LDT(RSC_ADV_HELP_ITEM_REV),
	LDT(RSC_ADV_HELP_ITEM_HIDE),
	LDT(RSC_ADV_HELP_SECT_ANY),
	LDT(RSC_ADV_HELP_ITEM_POWER),
	LDT(RSC_ADV_HELP_ITEM_TOP),
	LDT(RSC_ADV_HELP_ITEM_UPD),
	LDT(RSC_ADV_HELP_ITEM_START),
	LDT(RSC_ADV_HELP_ITEM_STOP),
	LDT(RSC_ADV_HELP_ITEM_TOOLS),
	LDT(RSC_ADV_HELP_ITEM_GO_UP),
	LDT(RSC_ADV_HELP_ITEM_GO_DW),
	LDT(RSC_ADV_HELP_ITEM_TERMINAL),
	LDT(RSC_ADV_HELP_ITEM_PRT_SCR),
	LDT(RSC_ADV_HELP_ITEM_REC_SCR),
	LDT(RSC_ADV_HELP_ITEM_FAHR_CELS),
	LDT(RSC_ADV_HELP_ITEM_SYSGATE),
	LDT(RSC_ADV_HELP_ITEM_PROC_EVENT),
	LDT(RSC_ADV_HELP_ITEM_SECRET),
	LDT(RSC_TURBO_CLOCK_TITLE),
	LDT(RSC_RATIO_CLOCK_TITLE),
	LDT(RSC_UNCORE_CLOCK_TITLE),
	LDT(RSC_SELECT_CPU_TITLE),
	LDT(RSC_SELECT_FREQ_TITLE),
	LDT(RSC_BOX_DISABLE_COND0),
	LDT(RSC_BOX_DISABLE_COND1),
	LDT(RSC_BOX_ENABLE_COND0),
	LDT(RSC_BOX_ENABLE_COND1),
	LDT(RSC_BOX_INTERVAL_TITLE),
	LDQ(RSC_BOX_INTERVAL_STEP1),
	LDQ(RSC_BOX_INTERVAL_STEP2),
	LDQ(RSC_BOX_INTERVAL_STEP3),
	LDQ(RSC_BOX_INTERVAL_STEP4),
	LDQ(RSC_BOX_INTERVAL_STEP5),
	LDQ(RSC_BOX_INTERVAL_STEP6),
	LDQ(RSC_BOX_INTERVAL_STEP7),
	LDQ(RSC_BOX_INTERVAL_STEP8),
	LDQ(RSC_BOX_INTERVAL_STEP9),
	LDQ(RSC_BOX_INTERVAL_STEP10),
	LDT(RSC_BOX_AUTO_CLOCK_TITLE),
	LDT(RSC_BOX_MODE_TITLE),
	LDT(RSC_BOX_MODE_DESC),
	LDQ(RSC_BOX_CU_L1_TITLE),
	LDQ(RSC_BOX_CU_L1_IP_TITLE),
	LDQ(RSC_BOX_CU_L1_NPP_TITLE),
	LDQ(RSC_BOX_L1_SCRUBBING_TITLE),
	LDQ(RSC_BOX_CU_L2_TITLE),
	LDQ(RSC_BOX_CU_L2_CL_TITLE),
	LDQ(RSC_BOX_L2_AMP_TITLE),
	LDQ(RSC_BOX_CU_L2_NLP_TITLE),
	LDQ(RSC_BOX_L1_STRIDE_TITLE),
	LDQ(RSC_BOX_L1_REGION_TITLE),
	LDQ(RSC_BOX_L1_BURST_TITLE),
	LDQ(RSC_BOX_L2_STREAM_HW_TITLE),
	LDQ(RSC_BOX_L2_UPDOWN_TITLE),
	LDQ(RSC_BOX_LLC_STREAMER_TITLE),
	LDQ(RSC_BOX_EIST_TITLE),
	LDT(RSC_BOX_EIST_DESC),
	LDQ(RSC_BOX_C1E_TITLE),
	LDT(RSC_BOX_C1E_DESC),
	LDQ(RSC_BOX_TURBO_TITLE),
	LDT(RSC_BOX_TURBO_DESC),
	LDQ(RSC_BOX_C1A_TITLE),
	LDT(RSC_BOX_C1A_DESC),
	LDQ(RSC_BOX_C3A_TITLE),
	LDT(RSC_BOX_C3A_DESC),
	LDQ(RSC_BOX_C1U_TITLE),
	LDT(RSC_BOX_C1U_DESC),
	LDQ(RSC_BOX_C2U_TITLE),
	LDT(RSC_BOX_C2U_DESC),
	LDQ(RSC_BOX_C3U_TITLE),
	LDT(RSC_BOX_C3U_DESC),
	LDT(RSC_BOX_C6D_DESC),
	LDQ(RSC_BOX_MC6_TITLE),
	LDT(RSC_BOX_MC6_DESC),
	LDQ(RSC_BOX_CC6_TITLE),
	LDQ(RSC_BOX_C6D_TITLE),
	LDT(RSC_BOX_CC6_DESC),
	LDQ(RSC_BOX_PC6_TITLE),
	LDT(RSC_BOX_PC6_DESC),
	LDQ(RSC_BOX_CPPC_TITLE),
	LDQ(RSC_BOX_HWP_TITLE),
	LDT(RSC_BOX_HWP_DESC),
	LDT(RSC_BOX_FMW_DESC),
	LDQ(RSC_BOX_HDC_TITLE),
	LDT(RSC_BOX_HDC_DESC),
	LDQ(RSC_BOX_EEO_TITLE),
	LDT(RSC_BOX_EEO_DESC),
	LDQ(RSC_BOX_R2H_TITLE),
	LDT(RSC_BOX_R2H_DESC),
	LDQ(RSC_BOX_WDT_TITLE),
	LDT(RSC_BOX_WDT_DESC),
	LDQ(RSC_BOX_HSMP_TITLE),
	LDT(RSC_BOX_HSMP_DESC),
	LDQ(RSC_BOX_BLANK_DESC),
	LDT(RSC_BOX_NOMINAL_MODE_COND0),
	LDT(RSC_BOX_NOMINAL_MODE_COND1),
	LDT(RSC_BOX_EXPERIMENT_MODE_COND0),
	LDT(RSC_BOX_EXPERIMENT_MODE_COND1),
	LDT(RSC_BOX_INTERRUPT_TITLE),
	LDT(RSC_BOX_CPU_IDLE_TITLE),
	LDT(RSC_BOX_CPU_FREQ_TITLE),
	LDT(RSC_BOX_GOVERNOR_TITLE),
	LDT(RSC_BOX_CLOCK_SOURCE_TITLE),
	LDT(RSC_BOX_OPS_REGISTER_COND0),
	LDT(RSC_BOX_OPS_REGISTER_COND1),
	LDT(RSC_BOX_OPS_UNREGISTER_COND0),
	LDT(RSC_BOX_OPS_UNREGISTER_COND1),
	LDT(RSC_BOX_EVENT_TITLE),
	LDT(RSC_BOX_EVENT_SPACE),
	LDT(RSC_BOX_EVENT_THERMAL_SENSOR),
	LDT(RSC_BOX_EVENT_PROCHOT_STS),
	LDT(RSC_BOX_EVENT_CRITICAL_TEMP),
	LDT(RSC_BOX_EVENT_THOLD1_STS),
	LDT(RSC_BOX_EVENT_THOLD2_STS),
	LDT(RSC_BOX_EVENT_POWER_LIMIT),
	LDT(RSC_BOX_EVENT_CURRENT_LIMIT),
	LDT(RSC_BOX_EVENT_CROSS_DOM_LIMIT),
	LDT(RSC_BOX_EVENT_RESIDENCY),
	LDT(RSC_BOX_EVENT_AVG_THERMAL),
	LDT(RSC_BOX_EVENT_VR_THERMAL),
	LDT(RSC_BOX_EVENT_VR_TDC),
	LDT(RSC_BOX_EVENT_POWER_PL1),
	LDT(RSC_BOX_EVENT_POWER_PL2),
	LDT(RSC_BOX_EVENT_ELECTRICAL),
	LDT(RSC_BOX_EVENT_INEFFICIENCY),
	LDT(RSC_BOX_EVENT_MAX_TURBO),
	LDT(RSC_BOX_EVENT_TURBO_ATTEN),
	LDT(RSC_BOX_EVENT_THERMAL_TVB),
	LDT(RSC_BOX_EVENT_ALL_OF_THEM),
	LDT(RSC_BOX_STATE_UNSPECIFIED),
	LDQ(RSC_BOX_STATE_C8),
	LDQ(RSC_BOX_STATE_C7),
	LDQ(RSC_BOX_STATE_C6),
	LDQ(RSC_BOX_STATE_C4),
	LDQ(RSC_BOX_STATE_C3),
	LDQ(RSC_BOX_STATE_C0),
	LDT(RSC_BOX_PKG_STATE_LIMIT_TITLE),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C10),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C9),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C8),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C7S),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C7),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C6R),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C6),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C4),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C3),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C2),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C1),
	LDQ(RSC_BOX_PKG_STATE_LIMIT_C0),
	LDT(RSC_BOX_IO_MWAIT_TITLE),
	LDT(RSC_BOX_IO_MWAIT_DESC),
	LDT(RSC_BOX_MWAIT_MAX_STATE_TITLE),
	LDT(RSC_BOX_ODCM_TITLE),
	LDT(RSC_BOX_ODCM_DESC),
	LDT(RSC_BOX_EXT_DUTY_CYCLE_TITLE),
	LDT(RSC_BOX_DUTY_CYCLE_TITLE),
	LDT(RSC_BOX_DUTY_CYCLE_RESERVED),
	LDQ(RSC_BOX_DUTY_CYCLE_PCT1),
	LDQ(RSC_BOX_DUTY_CYCLE_PCT2),
	LDQ(RSC_BOX_DUTY_CYCLE_PCT3),
	LDQ(RSC_BOX_DUTY_CYCLE_PCT4),
	LDQ(RSC_BOX_DUTY_CYCLE_PCT5),
	LDQ(RSC_BOX_DUTY_CYCLE_PCT6),
	LDQ(RSC_BOX_DUTY_CYCLE_PCT7),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT1),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT2),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT3),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT4),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT5),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT6),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT7),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT8),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT9),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT10),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT11),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT12),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT13),
	LDQ(RSC_BOX_EXT_DUTY_CYCLE_PCT14),
	LDT(RSC_BOX_POWER_POLICY_TITLE),
	LDT(RSC_BOX_POWER_POLICY_LOW),
	LDQ(RSC_BOX_POWER_POLICY_1),
	LDQ(RSC_BOX_POWER_POLICY_2),
	LDQ(RSC_BOX_POWER_POLICY_3),
	LDQ(RSC_BOX_POWER_POLICY_4),
	LDQ(RSC_BOX_POWER_POLICY_5),
	LDQ(RSC_BOX_POWER_POLICY_6),
	LDQ(RSC_BOX_POWER_POLICY_7),
	LDQ(RSC_BOX_POWER_POLICY_8),
	LDQ(RSC_BOX_POWER_POLICY_9),
	LDQ(RSC_BOX_POWER_POLICY_10),
	LDQ(RSC_BOX_POWER_POLICY_11),
	LDQ(RSC_BOX_POWER_POLICY_12),
	LDQ(RSC_BOX_POWER_POLICY_13),
	LDQ(RSC_BOX_POWER_POLICY_14),
	LDT(RSC_BOX_POWER_POLICY_HIGH),
	LDT(RSC_BOX_HWP_POLICY_MIN),
	LDT(RSC_BOX_HWP_POLICY_020),
	LDT(RSC_BOX_HWP_POLICY_040),
	LDT(RSC_BOX_HWP_POLICY_060),
	LDT(RSC_BOX_HWP_POLICY_MED),
	LDT(RSC_BOX_HWP_POLICY_0A0),
	LDT(RSC_BOX_HWP_POLICY_PWR),
	LDT(RSC_BOX_HWP_POLICY_0E0),
	LDT(RSC_BOX_HWP_POLICY_MAX),
	LDT(RSC_BOX_CFG_TDP_TITLE),
	LDT(RSC_BOX_CFG_TDP_DESC),
	LDQ(RSC_BOX_CFG_TDP_BLANK),
	LDT(RSC_BOX_CFG_TDP_LVL0),
	LDT(RSC_BOX_CFG_TDP_LVL1),
	LDT(RSC_BOX_CFG_TDP_LVL2),
	LDT(RSC_BOX_TDP_PKG_TITLE),
	LDT(RSC_BOX_TDP_CORES_TITLE),
	LDT(RSC_BOX_TDP_UNCORE_TITLE),
	LDT(RSC_BOX_TDP_RAM_TITLE),
	LDT(RSC_BOX_TDP_PLATFORM_TITLE),
	LDT(RSC_BOX_PL1_DESC),
	LDT(RSC_BOX_PL2_DESC),
	LDQ(RSC_BOX_PWR_OFFSET_00),
	LDQ(RSC_BOX_PWR_OFFSET_01),
	LDQ(RSC_BOX_PWR_OFFSET_02),
	LDQ(RSC_BOX_PWR_OFFSET_03),
	LDQ(RSC_BOX_PWR_OFFSET_04),
	LDQ(RSC_BOX_PWR_OFFSET_05),
	LDQ(RSC_BOX_PWR_OFFSET_06),
	LDQ(RSC_BOX_PWR_OFFSET_07),
	LDQ(RSC_BOX_PWR_OFFSET_08),
	LDQ(RSC_BOX_PWR_OFFSET_09),
	LDQ(RSC_BOX_PWR_OFFSET_10),
	LDQ(RSC_BOX_PWR_OFFSET_11),
	LDQ(RSC_BOX_PWR_OFFSET_12),
	LDQ(RSC_BOX_PWR_OFFSET_13),
	LDQ(RSC_BOX_CLAMPING_OFF_COND0),
	LDQ(RSC_BOX_CLAMPING_OFF_COND1),
	LDQ(RSC_BOX_CLAMPING_ON_COND0),
	LDQ(RSC_BOX_CLAMPING_ON_COND1),
	LDT(RSC_BOX_TDC_TITLE),
	LDT(RSC_BOX_TDC_DESC),
	LDQ(RSC_BOX_AMP_OFFSET_00),
	LDQ(RSC_BOX_AMP_OFFSET_01),
	LDQ(RSC_BOX_AMP_OFFSET_02),
	LDQ(RSC_BOX_AMP_OFFSET_03),
	LDQ(RSC_BOX_AMP_OFFSET_04),
	LDQ(RSC_BOX_AMP_OFFSET_05),
	LDQ(RSC_BOX_AMP_OFFSET_06),
	LDQ(RSC_BOX_AMP_OFFSET_07),
	LDQ(RSC_BOX_AMP_OFFSET_08),
	LDQ(RSC_BOX_AMP_OFFSET_09),
	LDQ(RSC_BOX_AMP_OFFSET_10),
	LDQ(RSC_BOX_AMP_OFFSET_11),
	LDQ(RSC_BOX_AMP_OFFSET_12),
	LDQ(RSC_BOX_AMP_OFFSET_13),
	LDT(RSC_BOX_TOOLS_TITLE),
	LDT(RSC_BOX_TOOLS_STOP_BURN),
	LDT(RSC_BOX_TOOLS_ATOMIC_BURN),
	LDT(RSC_BOX_TOOLS_CRC32_BURN),
	LDT(RSC_BOX_TOOLS_CONIC_BURN),
	LDT(RSC_BOX_TOOLS_RANDOM_CPU),
	LDT(RSC_BOX_TOOLS_ROUND_ROBIN_CPU),
	LDT(RSC_BOX_TOOLS_USER_CPU),
	LDT(RSC_BOX_TOOLS_MONTE_CARLO),
	LDT(RSC_BOX_CONIC_TITLE),
	LDT(RSC_BOX_CONIC_ITEM_1),
	LDT(RSC_BOX_CONIC_ITEM_2),
	LDT(RSC_BOX_CONIC_ITEM_3),
	LDT(RSC_BOX_CONIC_ITEM_4),
	LDT(RSC_BOX_CONIC_ITEM_5),
	LDT(RSC_BOX_CONIC_ITEM_6),
	LDT(RSC_BOX_LANG_TITLE),
	LDT(RSC_BOX_LANG_ENGLISH),
	LDT(RSC_BOX_LANG_FRENCH),
	LDQ(RSC_BOX_LANG_BLANK),
	LDT(RSC_BOX_THEME_TITLE),
	LDQ(RSC_BOX_THEME_BLANK),
	LDT(RSC_BOX_SCOPE_THERMAL_TITLE),
	LDT(RSC_BOX_SCOPE_VOLTAGE_TITLE),
	LDT(RSC_BOX_SCOPE_POWER_TITLE),
	LDT(RSC_BOX_SCOPE_NONE),
	LDT(RSC_BOX_SCOPE_THREAD),
	LDT(RSC_BOX_SCOPE_CORE),
	LDT(RSC_BOX_SCOPE_PACKAGE),
	LDT(RSC_ERROR_CMD_SYNTAX),
	LDT(RSC_ERROR_SHARED_MEM),
	LDT(RSC_ERROR_SYS_CALL),
	LDT(RSC_ERROR_UNIMPLEMENTED),
	LDT(RSC_ERROR_EXPERIMENTAL),
	LDT(RSC_ERROR_TURBO_PREREQ),
	LDT(RSC_ERROR_UNCORE_PREREQ),
	LDT(RSC_ERROR_PSTATE_NOT_FOUND),
	LDT(RSC_ERROR_CLOCKSOURCE),
	LDT(RSC_BOX_IDLE_LIMIT_TITLE),
	LDQ(RSC_BOX_IDLE_LIMIT_RESET),
	LDT(RSC_BOX_RECORDER_TITLE),
	LDT(RSC_SMBIOS_TITLE),
	LDT(RSC_MECH_IBRS),
	LDT(RSC_MECH_IBPB),
	LDT(RSC_MECH_SBPB),
	LDT(RSC_MECH_STIBP),
	LDT(RSC_MECH_SSBD),
	LDT(RSC_MECH_L1D_FLUSH),
	LDT(RSC_MECH_MD_CLEAR),
	LDT(RSC_MECH_RDCL_NO),
	LDT(RSC_MECH_IBRS_ALL),
	LDT(RSC_MECH_RSBA),
	LDT(RSC_MECH_L1DFL_VMENTRY_NO),
	LDT(RSC_MECH_SSB_NO),
	LDT(RSC_MECH_MDS_NO),
	LDT(RSC_MECH_PSCHANGE_MC_NO),
	LDT(RSC_MECH_TAA_NO),
	LDT(RSC_MECH_STLB),
	LDT(RSC_MECH_FUSA),
	LDT(RSC_MECH_RSM_CPL0),
	LDT(RSC_MECH_SPLA),
	LDT(RSC_MECH_SNOOP_FILTER),
	LDT(RSC_MECH_PSFD),
	LDT(RSC_MECH_EPSF),
	LDT(RSC_MECH_IBRS_ALWAYS_ON),
	LDT(RSC_MECH_IBRS_PREFERRED),
	LDT(RSC_MECH_IBRS_SAME_MODE),
	LDT(RSC_MECH_SSBD_VIRTSPECCTRL),
	LDT(RSC_MECH_SSBD_NOT_REQUIRED),
	LDT(RSC_MECH_DOITM),
	LDT(RSC_MECH_SBDR_SSDP_NO),
	LDT(RSC_MECH_FBSDP_NO),
	LDT(RSC_MECH_PSDP_NO),
	LDT(RSC_MECH_FB_CLEAR),
	LDT(RSC_MECH_SRBDS),
	LDT(RSC_MECH_RNGDS),
	LDT(RSC_MECH_RTM),
	LDT(RSC_MECH_VERW),
	LDT(RSC_MECH_RRSBA),
	LDT(RSC_MECH_BHI_NO),
	LDT(RSC_MECH_XAPIC_DIS),
	LDT(RSC_MECH_PBRSB_NO),
	LDT(RSC_MECH_GDS_NO),
	LDT(RSC_MECH_RFDS_NO),
	LDT(RSC_MECH_IPRED_DIS_U),
	LDT(RSC_MECH_IPRED_DIS_S),
	LDT(RSC_MECH_RRSBA_DIS_U),
	LDT(RSC_MECH_RRSBA_DIS_S),
	LDT(RSC_MECH_DDPD_U_DIS),
	LDT(RSC_MECH_BHI_DIS_S),
	LDT(RSC_MECH_MCDT_NO),
	LDT(RSC_MECH_UMON_MITG_NO),
	LDT(RSC_MECH_SRSO_NO),
	LDT(RSC_MECH_SRSO_USR_KNL_NO),
	LDT(RSC_MECH_BTC_NO),
	LDT(RSC_MECH_BTC_NOBR),
	LDT(RSC_MECH_XPROC_LEAK),
	LDT(RSC_MECH_AGENPICK),
	LDT(RSC_MECH_OVERCLOCKING),
	LDT(RSC_MECH_OC_UTILIZED),
	LDT(RSC_MECH_OC_UNDERVOLT),
	LDT(RSC_MECH_OC_UNLOCKED),
	LDT(RSC_SECURITY_CPUID_KL),
	LDT(RSC_SECURITY_AESKLE),
	LDT(RSC_SECURITY_CET_SS),
	LDT(RSC_SECURITY_CET_IBT),
	LDT(RSC_SECURITY_CET_SSS),
	LDT(RSC_SECURITY_WIDE_KL),
	LDT(RSC_SECURITY_SGX1),
	LDT(RSC_SECURITY_SGX2),
	LDT(RSC_SECURITY_SKINIT),
	LDT(RSC_SECURITY_SEV),
	LDT(RSC_SECURITY_SEV_ES),
	LDT(RSC_SECURITY_SEV_SNP),
	LDT(RSC_SECURITY_GMET),
	LDT(RSC_SECURITY_SSS),
	LDT(RSC_SECURITY_VMPL),
	LDT(RSC_SECURITY_VMPL_SSS),
	LDT(RSC_SECURITY_SME),
	LDT(RSC_SECURITY_SME_MK),
	LDT(RSC_SECURITY_SCRAMBLER),
	LDT(RSC_SECURITY_TSME),
	LDQ(RSC_CF0),
	LDQ(RSC_CF1),
	LDQ(RSC_CF2),
	LDQ(RSC_CF3),
	LDQ(RSC_CF4),
	LDQ(RSC_CF5),
	LDT(RSC_COPY0),
	LDT(RSC_COPY1),
	LDT(RSC_COPY2),
	LDT(RSC_CREATE_SELECT_AUTO_TURBO),
	LDT(RSC_CREATE_SELECT_FREQ_TURBO),
	LDT(RSC_CREATE_SELECT_FREQ_TGT),
	LDT(RSC_CREATE_SELECT_FREQ_HWP_TGT),
	LDT(RSC_CREATE_SELECT_FREQ_HWP_MAX),
	LDT(RSC_CREATE_SELECT_FREQ_HWP_MIN),
	LDT(RSC_CREATE_SELECT_FREQ_MAX),
	LDT(RSC_CREATE_SELECT_FREQ_MIN),
	LDT(RSC_CREATE_SELECT_FREQ_OFFLINE),
	LDT(RSC_POPUP_DRIVER_TITLE),
	LDT(RSC_EXIT_TITLE),
	LDT(RSC_EXIT_HEADER),
	LDT(RSC_EXIT_CONFIRM),
	LDT(RSC_EXIT_FOOTER)
};

#undef LDV
#undef LDA
#undef LDB
#undef LDS
#undef LDT
#undef LDC
#undef LDQ
#undef DEF_LDA
#undef DEF_LDB
