/**
 * Copyright (c) 2014-2024 The xterm.js authors. All rights reserved.
 * @license MIT
 *
 * Copyright (c) 2012-2013, Christopher Jeffrey (MIT License)
 * @license MIT
 *
 * Originally forked from (with the author's permission):
 *   Fabrice Bellard's javascript vt100 for jslinux:
 *   http://bellard.org/jslinux/
 *   Copyright (c) 2011 Fabrice Bellard
 */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var m=0,b=0,_=0,p=0;var g;(t=>{function l(r,a,s,i){return i!==void 0?`#${w(r)}${w(a)}${w(s)}${w(i)}`:`#${w(r)}${w(a)}${w(s)}`}t.toCss=l;function n(r,a,s,i=255){return(r<<24|a<<16|s<<8|i)>>>0}t.toRgba=n;function e(r,a,s,i){return{css:t.toCss(r,a,s,i),rgba:t.toRgba(r,a,s,i)}}t.toColor=e})(g||={});var U;(i=>{function l(o,u){if(p=(u.rgba&255)/255,p===1)return{css:u.css,rgba:u.rgba};let f=u.rgba>>24&255,C=u.rgba>>16&255,c=u.rgba>>8&255,h=o.rgba>>24&255,d=o.rgba>>16&255,I=o.rgba>>8&255;m=h+Math.round((f-h)*p),b=d+Math.round((C-d)*p),_=I+Math.round((c-I)*p);let L=g.toCss(m,b,_),E=g.toRgba(m,b,_);return{css:L,rgba:E}}i.blend=l;function n(o){return(o.rgba&255)===255}i.isOpaque=n;function e(o,u,f){let C=B.ensureContrastRatio(o.rgba,u.rgba,f);if(C)return g.toColor(C>>24&255,C>>16&255,C>>8&255)}i.ensureContrastRatio=e;function t(o){let u=(o.rgba|255)>>>0;return[m,b,_]=B.toChannels(u),{css:g.toCss(m,b,_),rgba:u}}i.opaque=t;function r(o,u){return p=Math.round(u*255),[m,b,_]=B.toChannels(o.rgba),{css:g.toCss(m,b,_,p),rgba:g.toRgba(m,b,_,p)}}i.opacity=r;function a(o,u){return p=o.rgba&255,r(o,p*u/255)}i.multiplyOpacity=a;function s(o){return[o.rgba>>24&255,o.rgba>>16&255,o.rgba>>8&255]}i.toColorRGB=s})(U||={});var x;(t=>{let l,n;try{let r=document.createElement("canvas");r.width=1,r.height=1;let a=r.getContext("2d",{willReadFrequently:!0});a&&(l=a,l.globalCompositeOperation="copy",n=l.createLinearGradient(0,0,1,1))}catch{}function e(r){if(r.match(/#[\da-f]{3,8}/i))switch(r.length){case 4:return m=parseInt(r.slice(1,2).repeat(2),16),b=parseInt(r.slice(2,3).repeat(2),16),_=parseInt(r.slice(3,4).repeat(2),16),g.toColor(m,b,_);case 5:return m=parseInt(r.slice(1,2).repeat(2),16),b=parseInt(r.slice(2,3).repeat(2),16),_=parseInt(r.slice(3,4).repeat(2),16),p=parseInt(r.slice(4,5).repeat(2),16),g.toColor(m,b,_,p);case 7:return{css:r,rgba:(parseInt(r.slice(1),16)<<8|255)>>>0};case 9:return{css:r,rgba:parseInt(r.slice(1),16)>>>0}}let a=r.match(/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(,\s*(0|1|\d?\.(\d+))\s*)?\)/);if(a)return m=parseInt(a[1]),b=parseInt(a[2]),_=parseInt(a[3]),p=Math.round((a[5]===void 0?1:parseFloat(a[5]))*255),g.toColor(m,b,_,p);if(r==="transparent")return{css:"transparent",rgba:0};if(!l||!n)throw new Error("css.toColor: Unsupported css format");if(l.fillStyle=n,l.fillStyle=r,typeof l.fillStyle!="string")throw new Error("css.toColor: Unsupported css format");if(l.fillRect(0,0,1,1),[m,b,_,p]=l.getImageData(0,0,1,1).data,p!==255)throw new Error("css.toColor: Unsupported css format");return{rgba:g.toRgba(m,b,_,p),css:r}}t.toColor=e})(x||={});var v;(e=>{function l(t){return n(t>>16&255,t>>8&255,t&255)}e.relativeLuminance=l;function n(t,r,a){let s=t/255,i=r/255,o=a/255,u=s<=.03928?s/12.92:Math.pow((s+.055)/1.055,2.4),f=i<=.03928?i/12.92:Math.pow((i+.055)/1.055,2.4),C=o<=.03928?o/12.92:Math.pow((o+.055)/1.055,2.4);return u*.2126+f*.7152+C*.0722}e.relativeLuminance2=n})(v||={});var B;(a=>{function l(s,i){if(p=(i&255)/255,p===1)return i;let o=i>>24&255,u=i>>16&255,f=i>>8&255,C=s>>24&255,c=s>>16&255,h=s>>8&255;return m=C+Math.round((o-C)*p),b=c+Math.round((u-c)*p),_=h+Math.round((f-h)*p),g.toRgba(m,b,_)}a.blend=l;function n(s,i,o){let u=v.relativeLuminance(s>>8),f=v.relativeLuminance(i>>8);if(F(u,f)<o){if(f<u){let d=e(s,i,o),I=F(u,v.relativeLuminance(d>>8));if(I<o){let L=t(s,i,o),E=F(u,v.relativeLuminance(L>>8));return I>E?d:L}return d}let c=t(s,i,o),h=F(u,v.relativeLuminance(c>>8));if(h<o){let d=e(s,i,o),I=F(u,v.relativeLuminance(d>>8));return h>I?c:d}return c}}a.ensureContrastRatio=n;function e(s,i,o){let u=s>>24&255,f=s>>16&255,C=s>>8&255,c=i>>24&255,h=i>>16&255,d=i>>8&255,I=F(v.relativeLuminance2(c,h,d),v.relativeLuminance2(u,f,C));for(;I<o&&(c>0||h>0||d>0);)c-=Math.max(0,Math.ceil(c*.1)),h-=Math.max(0,Math.ceil(h*.1)),d-=Math.max(0,Math.ceil(d*.1)),I=F(v.relativeLuminance2(c,h,d),v.relativeLuminance2(u,f,C));return(c<<24|h<<16|d<<8|255)>>>0}a.reduceLuminance=e;function t(s,i,o){let u=s>>24&255,f=s>>16&255,C=s>>8&255,c=i>>24&255,h=i>>16&255,d=i>>8&255,I=F(v.relativeLuminance2(c,h,d),v.relativeLuminance2(u,f,C));for(;I<o&&(c<255||h<255||d<255);)c=Math.min(255,c+Math.ceil((255-c)*.1)),h=Math.min(255,h+Math.ceil((255-h)*.1)),d=Math.min(255,d+Math.ceil((255-d)*.1)),I=F(v.relativeLuminance2(c,h,d),v.relativeLuminance2(u,f,C));return(c<<24|h<<16|d<<8|255)>>>0}a.increaseLuminance=t;function r(s){return[s>>24&255,s>>16&255,s>>8&255,s&255]}a.toChannels=r})(B||={});function w(l){let n=l.toString(16);return n.length<2?"0"+n:n}function F(l,n){return l<n?(n+.05)/(l+.05):(l+.05)/(n+.05)}var T=Object.freeze((()=>{let l=[x.toColor("#2e3436"),x.toColor("#cc0000"),x.toColor("#4e9a06"),x.toColor("#c4a000"),x.toColor("#3465a4"),x.toColor("#75507b"),x.toColor("#06989a"),x.toColor("#d3d7cf"),x.toColor("#555753"),x.toColor("#ef2929"),x.toColor("#8ae234"),x.toColor("#fce94f"),x.toColor("#729fcf"),x.toColor("#ad7fa8"),x.toColor("#34e2e2"),x.toColor("#eeeeec")],n=[0,95,135,175,215,255];for(let e=0;e<216;e++){let t=n[e/36%6|0],r=n[e/6%6|0],a=n[e%6];l.push({css:g.toCss(t,r,a),rgba:g.toRgba(t,r,a)})}for(let e=0;e<24;e++){let t=8+e*10;l.push({css:g.toCss(t,t,t),rgba:g.toRgba(t,t,t)})}return l})());function M(l,n,e){return Math.max(n,Math.min(l,e))}function z(l){switch(l){case"&":return"&amp;";case"<":return"&lt;"}return l}var S=class{constructor(n){this._buffer=n}serialize(n,e){let t=this._buffer.getNullCell(),r=this._buffer.getNullCell(),a=t,s=n.start.y,i=n.end.y,o=n.start.x,u=n.end.x;this._beforeSerialize(i-s,s,i);for(let f=s;f<=i;f++){let C=this._buffer.getLine(f);if(C){let c=f===n.start.y?o:0,h=f===n.end.y?u:C.length;for(let d=c;d<h;d++){let I=C.getCell(d,a===t?r:t);if(!I){console.warn(`Can't get cell at row=${f}, col=${d}`);continue}this._nextCell(I,a,f,d),a=I}}this._rowEnd(f,f===i)}return this._afterSerialize(),this._serializeString(e)}_nextCell(n,e,t,r){}_rowEnd(n,e){}_beforeSerialize(n,e,t){}_afterSerialize(){}_serializeString(n){return""}};function A(l,n){return l.getFgColorMode()===n.getFgColorMode()&&l.getFgColor()===n.getFgColor()}function R(l,n){return l.getBgColorMode()===n.getBgColorMode()&&l.getBgColor()===n.getBgColor()}function H(l,n){if(!l.isUnderline()&&!n.isUnderline())return!0;let e=l,t=n;return e.getUnderlineStyle()===t.getUnderlineStyle()&&e.getUnderlineColor()===t.getUnderlineColor()&&e.getUnderlineColorMode()===t.getUnderlineColorMode()}function O(l,n){return l.isInverse()===n.isInverse()&&l.isBold()===n.isBold()&&l.isUnderline()===n.isUnderline()&&H(l,n)&&l.isOverline()===n.isOverline()&&l.isBlink()===n.isBlink()&&l.isInvisible()===n.isInvisible()&&l.isItalic()===n.isItalic()&&l.isDim()===n.isDim()&&l.isStrikethrough()===n.isStrikethrough()}var y=class extends S{constructor(e,t){super(e);this._terminal=t;this._rowIndex=0;this._allRows=new Array;this._allRowSeparators=new Array;this._currentRow="";this._nullCellCount=0;this._cursorStyle=this._buffer.getNullCell();this._cursorStyleRow=0;this._cursorStyleCol=0;this._backgroundCell=this._buffer.getNullCell();this._firstRow=0;this._lastCursorRow=0;this._lastCursorCol=0;this._lastContentCursorRow=0;this._lastContentCursorCol=0;this._thisRowLastChar=this._buffer.getNullCell();this._thisRowLastSecondChar=this._buffer.getNullCell();this._nextRowFirstChar=this._buffer.getNullCell()}_beforeSerialize(e,t,r){this._allRows=new Array(e),this._lastContentCursorRow=t,this._lastCursorRow=t,this._firstRow=t}_rowEnd(e,t){this._nullCellCount>0&&!R(this._cursorStyle,this._backgroundCell)&&(this._currentRow+=`\x1B[${this._nullCellCount}X`);let r="";if(!t){e-this._firstRow>=this._terminal.rows&&this._buffer.getLine(this._cursorStyleRow)?.getCell(this._cursorStyleCol,this._backgroundCell);let a=this._buffer.getLine(e),s=this._buffer.getLine(e+1);if(!s.isWrapped)r=`\r
`,this._lastCursorRow=e+1,this._lastCursorCol=0;else{r="";let i=a.getCell(a.length-1,this._thisRowLastChar),o=a.getCell(a.length-2,this._thisRowLastSecondChar),u=s.getCell(0,this._nextRowFirstChar),f=u.getWidth()>1,C=!1;(u.getChars()&&f?this._nullCellCount<=1:this._nullCellCount<=0)&&((i.getChars()||i.getWidth()===0)&&R(i,u)&&(C=!0),f&&(o.getChars()||o.getWidth()===0)&&R(i,u)&&R(o,u)&&(C=!0)),C||(r="-".repeat(this._nullCellCount+1),r+="\x1B[1D\x1B[1X",this._nullCellCount>0&&(r+="\x1B[A",r+=`\x1B[${a.length-this._nullCellCount}C`,r+=`\x1B[${this._nullCellCount}X`,r+=`\x1B[${a.length-this._nullCellCount}D`,r+="\x1B[B"),this._lastContentCursorRow=e+1,this._lastContentCursorCol=0,this._lastCursorRow=e+1,this._lastCursorCol=0)}}this._allRows[this._rowIndex]=this._currentRow,this._allRowSeparators[this._rowIndex++]=r,this._currentRow="",this._nullCellCount=0}_diffStyle(e,t){let r=[],a=!A(e,t),s=!R(e,t),i=!O(e,t);if(a||s||i)if(e.isAttributeDefault())t.isAttributeDefault()||r.push(0);else{if(a){let o=e.getFgColor();e.isFgRGB()?r.push(38,2,o>>>16&255,o>>>8&255,o&255):e.isFgPalette()?o>=16?r.push(38,5,o):r.push(o&8?90+(o&7):30+(o&7)):r.push(39)}if(s){let o=e.getBgColor();e.isBgRGB()?r.push(48,2,o>>>16&255,o>>>8&255,o&255):e.isBgPalette()?o>=16?r.push(48,5,o):r.push(o&8?100+(o&7):40+(o&7)):r.push(49)}if(i){if(e.isInverse()!==t.isInverse()&&r.push(e.isInverse()?7:27),e.isBold()!==t.isBold()&&r.push(e.isBold()?1:22),H(e,t))e.isUnderline()!==t.isUnderline()&&r.push(e.isUnderline()?4:24);else{let o=e,u=o.getUnderlineStyle();if(u===0)r.push(24);else if(r.push("4:"+u),!o.isUnderlineColorDefault()){let f=o.getUnderlineColor();o.isUnderlineColorRGB()?r.push("58:2::"+(f>>>16&255)+":"+(f>>>8&255)+":"+(f&255)):r.push("58:5:"+f)}}e.isOverline()!==t.isOverline()&&r.push(e.isOverline()?53:55),e.isBlink()!==t.isBlink()&&r.push(e.isBlink()?5:25),e.isInvisible()!==t.isInvisible()&&r.push(e.isInvisible()?8:28),e.isItalic()!==t.isItalic()&&r.push(e.isItalic()?3:23),e.isDim()!==t.isDim()&&r.push(e.isDim()?2:22),e.isStrikethrough()!==t.isStrikethrough()&&r.push(e.isStrikethrough()?9:29)}}return r}_nextCell(e,t,r,a){if(e.getWidth()===0)return;let i=e.getChars()==="",o=this._diffStyle(e,this._cursorStyle);if(i?!R(this._cursorStyle,e):o.length>0){this._nullCellCount>0&&(R(this._cursorStyle,this._backgroundCell)||(this._currentRow+=`\x1B[${this._nullCellCount}X`),this._currentRow+=`\x1B[${this._nullCellCount}C`,this._nullCellCount=0),this._lastContentCursorRow=this._lastCursorRow=r,this._lastContentCursorCol=this._lastCursorCol=a,this._currentRow+=`\x1B[${o.join(";")}m`;let f=this._buffer.getLine(r);f!==void 0&&(f.getCell(a,this._cursorStyle),this._cursorStyleRow=r,this._cursorStyleCol=a)}i?this._nullCellCount+=e.getWidth():(this._nullCellCount>0&&(R(this._cursorStyle,this._backgroundCell)?this._currentRow+=`\x1B[${this._nullCellCount}C`:(this._currentRow+=`\x1B[${this._nullCellCount}X`,this._currentRow+=`\x1B[${this._nullCellCount}C`),this._nullCellCount=0),this._currentRow+=e.getChars(),this._lastContentCursorRow=this._lastCursorRow=r,this._lastContentCursorCol=this._lastCursorCol=a+e.getWidth())}_serializeString(e){let t=this._allRows.length;this._buffer.length-this._firstRow<=this._terminal.rows&&(t=this._lastContentCursorRow+1-this._firstRow,this._lastCursorCol=this._lastContentCursorCol,this._lastCursorRow=this._lastContentCursorRow);let r="";for(let i=0;i<t;i++)r+=this._allRows[i],i+1<t&&(r+=this._allRowSeparators[i]);if(!e){let i=this._buffer.baseY+this._buffer.cursorY,o=this._buffer.cursorX,u=i!==this._lastCursorRow||o!==this._lastCursorCol,f=c=>{c>0?r+=`\x1B[${c}C`:c<0&&(r+=`\x1B[${-c}D`)};u&&((c=>{c>0?r+=`\x1B[${c}B`:c<0&&(r+=`\x1B[${-c}A`)})(i-this._lastCursorRow),f(o-this._lastCursorCol))}let a=this._terminal._core._inputHandler._curAttrData,s=this._diffStyle(a,this._cursorStyle);return s.length>0&&(r+=`\x1B[${s.join(";")}m`),r}},k=class{activate(n){this._terminal=n}_serializeBufferByScrollback(n,e,t){let r=e.length,a=t===void 0?r:M(t+n.rows,0,r);return this._serializeBufferByRange(n,e,{start:r-a,end:r-1},!1)}_serializeBufferByRange(n,e,t,r){return new y(e,n).serialize({start:{x:0,y:typeof t.start=="number"?t.start:t.start.line},end:{x:n.cols,y:typeof t.end=="number"?t.end:t.end.line}},r)}_serializeBufferAsHTML(n,e){let t=n.buffer.active,r=new D(t,n,e),a=e.onlySelection??!1,s=e.range;if(s)return r.serialize({start:{x:s.startCol,y:(typeof s.startLine=="number",s.startLine)},end:{x:n.cols,y:(typeof s.endLine=="number",s.endLine)}});if(!a){let o=t.length,u=e.scrollback,f=u===void 0?o:M(u+n.rows,0,o);return r.serialize({start:{x:0,y:o-f},end:{x:n.cols,y:o-1}})}let i=this._terminal?.getSelectionPosition();return i!==void 0?r.serialize({start:{x:i.start.x,y:i.start.y},end:{x:i.end.x,y:i.end.y}}):""}_serializeScrollRegion(n){let e=n._core.buffer,t=e.scrollTop,r=e.scrollBottom;return t!==0||r!==n.rows-1?`\x1B[${t+1};${r+1}r`:""}_serializeModes(n){let e="",t=n.modes;if(t.applicationCursorKeysMode&&(e+="\x1B[?1h"),t.applicationKeypadMode&&(e+="\x1B[?66h"),t.bracketedPasteMode&&(e+="\x1B[?2004h"),t.insertMode&&(e+="\x1B[4h"),t.originMode&&(e+="\x1B[?6h"),t.reverseWraparoundMode&&(e+="\x1B[?45h"),t.sendFocusMode&&(e+="\x1B[?1004h"),t.wraparoundMode===!1&&(e+="\x1B[?7l"),t.mouseTrackingMode!=="none")switch(t.mouseTrackingMode){case"x10":e+="\x1B[?9h";break;case"vt200":e+="\x1B[?1000h";break;case"drag":e+="\x1B[?1002h";break;case"any":e+="\x1B[?1003h";break}return t.showCursor||(e+="\x1B[?25l"),e}serialize(n){if(!this._terminal)throw new Error("Cannot use addon until it has been loaded");let e=n?.range?this._serializeBufferByRange(this._terminal,this._terminal.buffer.normal,n.range,!0):this._serializeBufferByScrollback(this._terminal,this._terminal.buffer.normal,n?.scrollback);if(!n?.excludeAltBuffer&&this._terminal.buffer.active.type==="alternate"){let t=this._serializeBufferByScrollback(this._terminal,this._terminal.buffer.alternate,void 0);e+=`\x1B[?1049h\x1B[H${t}`}return n?.excludeModes||(e+=this._serializeModes(this._terminal),e+=this._serializeScrollRegion(this._terminal)),e}serializeAsHTML(n){if(!this._terminal)throw new Error("Cannot use addon until it has been loaded");return this._serializeBufferAsHTML(this._terminal,n??{})}dispose(){}},D=class extends S{constructor(e,t,r){super(e);this._terminal=t;this._options=r;this._currentRow="";this._htmlContent="";t._core._themeService?this._ansiColors=t._core._themeService.colors.ansi:this._ansiColors=T}_beforeSerialize(e,t,r){this._htmlContent+="<html><body><!--StartFragment--><pre>";let a="#000000",s="#ffffff";(this._options.includeGlobalBackground??!1)&&(a=this._terminal.options.theme?.foreground??"#ffffff",s=this._terminal.options.theme?.background??"#000000");let i=[];i.push("color: "+a+";"),i.push("background-color: "+s+";"),i.push("font-family: "+this._terminal.options.fontFamily+";"),i.push("font-size: "+this._terminal.options.fontSize+"px;"),this._htmlContent+="<div style='"+i.join(" ")+"'>"}_afterSerialize(){this._htmlContent+="</div>",this._htmlContent+="</pre><!--EndFragment--></body></html>"}_rowEnd(e,t){this._htmlContent+="<div><span>"+this._currentRow+"</span></div>",this._currentRow=""}_getHexColor(e,t){let r=t?e.getFgColor():e.getBgColor();if(t?e.isFgRGB():e.isBgRGB())return"#"+[r>>16&255,r>>8&255,r&255].map(s=>s.toString(16).padStart(2,"0")).join("");if(t?e.isFgPalette():e.isBgPalette())return this._ansiColors[r].css}_getUnderlineColor(e){let t=e;if(t.isUnderlineColorDefault())return;let r=t.getUnderlineColor();return t.isUnderlineColorRGB()?"#"+[r>>16&255,r>>8&255,r&255].map(s=>s.toString(16).padStart(2,"0")).join(""):this._ansiColors[r].css}_getUnderlineStyle(e){switch(e.getUnderlineStyle()){case 1:return"underline";case 2:return"underline double";case 3:return"underline wavy";case 4:return"underline dotted";case 5:return"underline dashed";default:return"underline"}}_diffStyle(e,t){let r=[],a=!A(e,t),s=!R(e,t),i=!O(e,t);if(a||s||i){let o=this._getHexColor(e,!0);o&&r.push("color: "+o+";");let u=this._getHexColor(e,!1);u&&r.push("background-color: "+u+";"),e.isInverse()&&r.push("color: #000000; background-color: #BFBFBF;"),e.isBold()&&r.push("font-weight: bold;");let f=[];if(e.isUnderline()&&f.push(this._getUnderlineStyle(e)),e.isOverline()&&f.push("overline"),e.isStrikethrough()&&f.push("line-through"),e.isBlink()&&f.push("blink"),f.length>0&&r.push("text-decoration: "+f.join(" ")+";"),e.isUnderline()){let C=this._getUnderlineColor(e);C&&r.push("text-decoration-color: "+C+";")}return e.isInvisible()&&r.push("visibility: hidden;"),e.isItalic()&&r.push("font-style: italic;"),e.isDim()&&r.push("opacity: 0.5;"),r}}_nextCell(e,t,r,a){if(e.getWidth()===0)return;let i=e.getChars()==="",o=this._diffStyle(e,t);o&&(this._currentRow+=o.length===0?"</span><span>":"</span><span style='"+o.join(" ")+"'>"),i?this._currentRow+=" ":this._currentRow+=z(e.getChars())}_serializeString(){return this._htmlContent}};export{D as HTMLSerializeHandler,k as SerializeAddon};
//# sourceMappingURL=addon-serialize.mjs.map
